/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.assertions;

import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public class Assert
extends org.testng.Assert {
    private Assert() {
    }

    @SuppressModernizer
    public static void assertEquals(Iterable<?> actual, Iterable<?> expected) {
        Assert.assertEquals(actual, expected, null);
    }

    @SuppressModernizer
    public static void assertEquals(Iterable<?> actual, Iterable<?> expected, String message) {
        try {
            org.testng.Assert.assertEquals(actual, expected, (String)message);
        }
        catch (AssertionError error) {
            org.testng.Assert.assertEquals(actual, expected, (String)message);
            throw error;
        }
    }

    public static void assertEventually(Runnable assertion) {
        Assert.assertEventually(new Duration(30.0, TimeUnit.SECONDS), assertion);
    }

    public static void assertEventually(Duration timeout, Runnable assertion) {
        Assert.assertEventually(timeout, new Duration(50.0, TimeUnit.MILLISECONDS), assertion);
    }

    public static void assertEventually(Duration timeout, Duration retryFrequency, Runnable assertion) {
        long start = System.nanoTime();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                assertion.run();
                return;
            }
            catch (AssertionError | Exception e) {
                if (Duration.nanosSince((long)start).compareTo(timeout) > 0) {
                    throw e;
                }
                try {
                    Thread.sleep(retryFrequency.toMillis());
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e2);
                }
            }
        }
    }
}

