/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.execution.scheduler.PartitionMemoryEstimator;
import io.trino.spi.ErrorCode;
import io.trino.spi.StandardErrorCode;

public class FallbackToFullNodePartitionMemoryEstimator
implements PartitionMemoryEstimator {
    public static final DataSize FULL_NODE_MEMORY = DataSize.of((long)512L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private static final PartitionMemoryEstimator.MemoryRequirements FULL_NODE_MEMORY_REQUIREMENTS = new PartitionMemoryEstimator.MemoryRequirements(FULL_NODE_MEMORY, true);

    @Override
    public PartitionMemoryEstimator.MemoryRequirements getInitialMemoryRequirements(Session session, DataSize defaultMemoryLimit) {
        return new PartitionMemoryEstimator.MemoryRequirements(defaultMemoryLimit, false);
    }

    @Override
    public PartitionMemoryEstimator.MemoryRequirements getNextRetryMemoryRequirements(Session session, PartitionMemoryEstimator.MemoryRequirements previousMemoryRequirements, ErrorCode errorCode) {
        if (this.shouldRescheduleWithFullNode(errorCode)) {
            return FULL_NODE_MEMORY_REQUIREMENTS;
        }
        return previousMemoryRequirements;
    }

    private boolean shouldRescheduleWithFullNode(ErrorCode errorCode) {
        return StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT.toErrorCode().equals((Object)errorCode) || StandardErrorCode.CLUSTER_OUT_OF_MEMORY.toErrorCode().equals((Object)errorCode);
    }
}

