/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import io.airlift.units.DataSize;
import io.trino.metadata.InternalNode;
import java.util.Objects;

public class NodeInfo {
    private final InternalNode node;
    private final DataSize maxMemory;

    public static NodeInfo unlimitedMemoryNode(InternalNode node) {
        return new NodeInfo(node, DataSize.ofBytes((long)Long.MAX_VALUE));
    }

    public NodeInfo(InternalNode node, DataSize maxMemory) {
        this.node = Objects.requireNonNull(node, "node is null");
        this.maxMemory = Objects.requireNonNull(maxMemory, "maxMemory is null");
    }

    public InternalNode getNode() {
        return this.node;
    }

    public DataSize getMaxMemory() {
        return this.maxMemory;
    }
}

