/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.spi.ErrorCode;
import java.util.Objects;

public interface PartitionMemoryEstimator {
    public MemoryRequirements getInitialMemoryRequirements(Session var1, DataSize var2);

    public MemoryRequirements getNextRetryMemoryRequirements(Session var1, MemoryRequirements var2, ErrorCode var3);

    public static class MemoryRequirements {
        private final DataSize requiredMemory;
        private final boolean limitReached;

        MemoryRequirements(DataSize requiredMemory, boolean limitReached) {
            this.requiredMemory = Objects.requireNonNull(requiredMemory, "requiredMemory is null");
            this.limitReached = limitReached;
        }

        public DataSize getRequiredMemory() {
            return this.requiredMemory;
        }

        public boolean isLimitReached() {
            return this.limitReached;
        }
    }
}

