/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import io.trino.TaskMemoryInfo;
import io.trino.spi.QueryId;
import io.trino.spi.memory.MemoryPoolInfo;
import java.util.Objects;

public class MemoryInfo {
    private final int availableProcessors;
    private final MemoryPoolInfo pool;
    private final ListMultimap<QueryId, TaskMemoryInfo> tasksMemoryInfo;

    public MemoryInfo(int availableProcessors, MemoryPoolInfo pool) {
        this(availableProcessors, pool, (ListMultimap<QueryId, TaskMemoryInfo>)ImmutableListMultimap.of());
    }

    @JsonCreator
    public MemoryInfo(@JsonProperty(value="availableProcessors") int availableProcessors, @JsonProperty(value="pool") MemoryPoolInfo pool, @JsonProperty(value="tasksMemoryInfo") ListMultimap<QueryId, TaskMemoryInfo> tasksMemoryInfo) {
        this.availableProcessors = availableProcessors;
        this.pool = Objects.requireNonNull(pool, "pool is null");
        this.tasksMemoryInfo = ImmutableListMultimap.copyOf((Multimap)((Multimap)Objects.requireNonNull(tasksMemoryInfo, "tasksMemoryInfo is null")));
    }

    @JsonProperty
    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    @JsonProperty
    public MemoryPoolInfo getPool() {
        return this.pool;
    }

    @JsonProperty
    public ListMultimap<QueryId, TaskMemoryInfo> getTasksMemoryInfo() {
        return this.tasksMemoryInfo;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("availableProcessors", this.availableProcessors).add("pool", (Object)this.pool).add("tasksMemoryInfo", this.tasksMemoryInfo).toString();
    }

    public MemoryInfo withTasksMemoryInfo(ListMultimap<QueryId, TaskMemoryInfo> tasksMemoryInfo) {
        return new MemoryInfo(this.availableProcessors, this.pool, tasksMemoryInfo);
    }
}

