/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"experimental.cluster-memory-manager-enabled", "query.low-memory-killer.enabled", "resources.reserved-system-memory"})
public class MemoryManagerConfig {
    public static final String FAULT_TOLERANT_TASK_MEMORY_CONFIG = "fault-tolerant-execution-task-memory";
    private DataSize maxQueryMemory = DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private DataSize maxQueryTotalMemory;
    private DataSize faultTolerantExecutionTaskMemory = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private LowMemoryKillerPolicy lowMemoryKillerPolicy = LowMemoryKillerPolicy.TOTAL_RESERVATION_ON_BLOCKED_NODES;
    private Duration killOnOutOfMemoryDelay = new Duration(5.0, TimeUnit.MINUTES);

    public LowMemoryKillerPolicy getLowMemoryKillerPolicy() {
        return this.lowMemoryKillerPolicy;
    }

    @Config(value="query.low-memory-killer.policy")
    public MemoryManagerConfig setLowMemoryKillerPolicy(LowMemoryKillerPolicy lowMemoryKillerPolicy) {
        this.lowMemoryKillerPolicy = lowMemoryKillerPolicy;
        return this;
    }

    @NotNull
    @MinDuration(value="5s")
    public @NotNull @MinDuration(value="5s") Duration getKillOnOutOfMemoryDelay() {
        return this.killOnOutOfMemoryDelay;
    }

    @Config(value="query.low-memory-killer.delay")
    @ConfigDescription(value="Delay between cluster running low on memory and invoking killer")
    public MemoryManagerConfig setKillOnOutOfMemoryDelay(Duration killOnOutOfMemoryDelay) {
        this.killOnOutOfMemoryDelay = killOnOutOfMemoryDelay;
        return this;
    }

    @NotNull
    public DataSize getMaxQueryMemory() {
        return this.maxQueryMemory;
    }

    @Config(value="query.max-memory")
    public MemoryManagerConfig setMaxQueryMemory(DataSize maxQueryMemory) {
        this.maxQueryMemory = maxQueryMemory;
        return this;
    }

    @NotNull
    public DataSize getMaxQueryTotalMemory() {
        if (this.maxQueryTotalMemory == null) {
            return DataSize.succinctBytes((long)(this.maxQueryMemory.toBytes() * 2L));
        }
        return this.maxQueryTotalMemory;
    }

    @Config(value="query.max-total-memory")
    public MemoryManagerConfig setMaxQueryTotalMemory(DataSize maxQueryTotalMemory) {
        this.maxQueryTotalMemory = maxQueryTotalMemory;
        return this;
    }

    @NotNull
    public DataSize getFaultTolerantExecutionTaskMemory() {
        return this.faultTolerantExecutionTaskMemory;
    }

    @Config(value="fault-tolerant-execution-task-memory")
    @ConfigDescription(value="Estimated amount of memory a single task will use when task level retries are used; value is used allocating nodes for tasks execution")
    public MemoryManagerConfig setFaultTolerantExecutionTaskMemory(DataSize faultTolerantExecutionTaskMemory) {
        this.faultTolerantExecutionTaskMemory = faultTolerantExecutionTaskMemory;
        return this;
    }

    public static enum LowMemoryKillerPolicy {
        NONE,
        TOTAL_RESERVATION,
        TOTAL_RESERVATION_ON_BLOCKED_NODES;


        public static LowMemoryKillerPolicy fromString(String value) {
            switch (Objects.requireNonNull(value, "value is null").toLowerCase(Locale.ENGLISH)) {
                case "none": {
                    return NONE;
                }
                case "total-reservation": {
                    return TOTAL_RESERVATION;
                }
                case "total-reservation-on-blocked-nodes": {
                    return TOTAL_RESERVATION_ON_BLOCKED_NODES;
                }
            }
            throw new IllegalArgumentException(String.format("Unrecognized value: '%s'", value));
        }
    }
}

