/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.trino.SystemSessionProperties;
import io.trino.TaskMemoryInfo;
import io.trino.execution.SqlTask;
import io.trino.execution.SqlTaskManager;
import io.trino.memory.LocalMemoryManager;
import io.trino.memory.MemoryInfo;
import io.trino.operator.RetryPolicy;
import io.trino.server.security.ResourceSecurity;
import io.trino.spi.QueryId;
import io.trino.spi.memory.MemoryPoolInfo;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/v1/memory")
public class MemoryResource {
    private final LocalMemoryManager memoryManager;
    private final SqlTaskManager taskManager;

    @Inject
    public MemoryResource(LocalMemoryManager memoryManager, SqlTaskManager taskManager) {
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.taskManager = Objects.requireNonNull(taskManager, "taskManager is null");
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.INTERNAL_ONLY)
    @GET
    @Produces(value={"application/json"})
    public MemoryInfo getMemoryInfo() {
        return this.memoryManager.getInfo().withTasksMemoryInfo(this.buildTasksMemoryInfo());
    }

    private ListMultimap<QueryId, TaskMemoryInfo> buildTasksMemoryInfo() {
        List<SqlTask> tasks = this.taskManager.getAllTasks();
        return (ListMultimap)tasks.stream().filter(task -> !task.getTaskState().isDone()).filter(task -> task.getTaskContext().map(context -> SystemSessionProperties.getRetryPolicy(context.getSession()) == RetryPolicy.TASK).orElse(false)).collect(ImmutableListMultimap.toImmutableListMultimap(task -> task.getTaskId().getQueryId(), task -> new TaskMemoryInfo(task.getTaskId(), task.getTaskContext().map(taskContext -> taskContext.getMemoryReservation().toBytes()).orElse(0L))));
    }

    private Response toSuccessfulResponse(MemoryPoolInfo memoryInfo) {
        return Response.ok().entity((Object)memoryInfo).build();
    }
}

