/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableSet;
import io.trino.TaskMemoryInfo;
import io.trino.execution.TaskId;
import io.trino.memory.KillTarget;
import io.trino.memory.LowMemoryKiller;
import io.trino.memory.MemoryInfo;
import io.trino.spi.memory.MemoryPoolInfo;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class TotalReservationOnBlockedNodesLowMemoryKiller
implements LowMemoryKiller {
    @Override
    public Optional<KillTarget> chooseQueryToKill(List<LowMemoryKiller.QueryMemoryInfo> runningQueries, List<MemoryInfo> nodes) {
        Optional<KillTarget> killTarget = this.chooseTasksToKill(nodes);
        if (killTarget.isEmpty()) {
            killTarget = this.chooseWholeQueryToKill(nodes);
        }
        return killTarget;
    }

    private Optional<KillTarget> chooseTasksToKill(List<MemoryInfo> nodes) {
        ImmutableSet.Builder tasksToKillBuilder = ImmutableSet.builder();
        for (MemoryInfo node : nodes) {
            MemoryPoolInfo memoryPool = node.getPool();
            if (memoryPool == null || memoryPool.getFreeBytes() + memoryPool.getReservedRevocableBytes() > 0L) continue;
            node.getTasksMemoryInfo().values().stream().max(Comparator.comparing(TaskMemoryInfo::getMemoryReservation)).map(TaskMemoryInfo::getTaskId).ifPresent(arg_0 -> ((ImmutableSet.Builder)tasksToKillBuilder).add(arg_0));
        }
        ImmutableSet tasksToKill = tasksToKillBuilder.build();
        if (tasksToKill.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(KillTarget.selectedTasks((Set<TaskId>)tasksToKill));
    }

    private Optional<KillTarget> chooseWholeQueryToKill(List<MemoryInfo> nodes) {
        HashMap memoryReservationOnBlockedNodes = new HashMap();
        for (MemoryInfo node : nodes) {
            MemoryPoolInfo memoryPool = node.getPool();
            if (memoryPool == null || memoryPool.getFreeBytes() + memoryPool.getReservedRevocableBytes() > 0L) continue;
            Map queryMemoryReservations = memoryPool.getQueryMemoryReservations();
            queryMemoryReservations.forEach((queryId, memoryReservation) -> memoryReservationOnBlockedNodes.compute(queryId, (id, oldValue) -> oldValue == null ? memoryReservation : oldValue + memoryReservation));
        }
        return memoryReservationOnBlockedNodes.entrySet().stream().max(Comparator.comparingLong(Map.Entry::getValue)).map(Map.Entry::getKey).map(KillTarget::wholeQuery);
    }
}

