/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.primitives.Primitives;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.trino.FeaturesConfig;
import io.trino.client.NodeVersion;
import io.trino.collect.cache.CacheUtils;
import io.trino.collect.cache.NonEvictableCache;
import io.trino.collect.cache.SafeCaches;
import io.trino.metadata.BlockEncodingManager;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionId;
import io.trino.metadata.FunctionInvoker;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.InternalBlockEncodingSerde;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.LiteralFunction;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.SystemFunctionBundle;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.window.WindowFunctionSupplier;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.type.BlockTypeOperators;
import io.trino.type.InternalTypeManager;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class FunctionManager {
    private final NonEvictableCache<FunctionKey, FunctionInvoker> specializedScalarCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS));
    private final NonEvictableCache<FunctionKey, AggregationMetadata> specializedAggregationCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS));
    private final NonEvictableCache<FunctionKey, WindowFunctionSupplier> specializedWindowCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS));
    private final GlobalFunctionCatalog globalFunctionCatalog;

    @Inject
    public FunctionManager(GlobalFunctionCatalog globalFunctionCatalog) {
        this.globalFunctionCatalog = globalFunctionCatalog;
    }

    public FunctionInvoker getScalarFunctionInvoker(ResolvedFunction resolvedFunction, InvocationConvention invocationConvention) {
        try {
            return (FunctionInvoker)CacheUtils.uncheckedCacheGet(this.specializedScalarCache, (Object)new FunctionKey(resolvedFunction, invocationConvention), () -> this.getScalarFunctionInvokerInternal(resolvedFunction, invocationConvention));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private FunctionInvoker getScalarFunctionInvokerInternal(ResolvedFunction resolvedFunction, InvocationConvention invocationConvention) {
        FunctionDependencies functionDependencies = this.getFunctionDependencies(resolvedFunction);
        FunctionInvoker functionInvoker = this.globalFunctionCatalog.getScalarFunctionInvoker(resolvedFunction.getFunctionId(), resolvedFunction.getSignature(), functionDependencies, invocationConvention);
        FunctionManager.verifyMethodHandleSignature(resolvedFunction.getSignature(), functionInvoker, invocationConvention);
        return functionInvoker;
    }

    public AggregationMetadata getAggregateFunctionImplementation(ResolvedFunction resolvedFunction) {
        try {
            return (AggregationMetadata)CacheUtils.uncheckedCacheGet(this.specializedAggregationCache, (Object)new FunctionKey(resolvedFunction), () -> this.getAggregateFunctionImplementationInternal(resolvedFunction));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private AggregationMetadata getAggregateFunctionImplementationInternal(ResolvedFunction resolvedFunction) {
        FunctionDependencies functionDependencies = this.getFunctionDependencies(resolvedFunction);
        return this.globalFunctionCatalog.getAggregateFunctionImplementation(resolvedFunction.getFunctionId(), resolvedFunction.getSignature(), functionDependencies);
    }

    public WindowFunctionSupplier getWindowFunctionImplementation(ResolvedFunction resolvedFunction) {
        try {
            return (WindowFunctionSupplier)CacheUtils.uncheckedCacheGet(this.specializedWindowCache, (Object)new FunctionKey(resolvedFunction), () -> this.getWindowFunctionImplementationInternal(resolvedFunction));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private WindowFunctionSupplier getWindowFunctionImplementationInternal(ResolvedFunction resolvedFunction) {
        FunctionDependencies functionDependencies = this.getFunctionDependencies(resolvedFunction);
        return this.globalFunctionCatalog.getWindowFunctionImplementation(resolvedFunction.getFunctionId(), resolvedFunction.getSignature(), functionDependencies);
    }

    private FunctionDependencies getFunctionDependencies(ResolvedFunction resolvedFunction) {
        return new FunctionDependencies(this::getScalarFunctionInvoker, resolvedFunction.getTypeDependencies(), resolvedFunction.getFunctionDependencies());
    }

    private static void verifyMethodHandleSignature(BoundSignature boundSignature, FunctionInvoker functionInvoker, InvocationConvention convention) {
        MethodHandle methodHandle = functionInvoker.getMethodHandle();
        MethodType methodType = methodHandle.type();
        Preconditions.checkArgument((convention.getArgumentConventions().size() == boundSignature.getArgumentTypes().size() ? 1 : 0) != 0, (String)"Expected %s arguments, but got %s", (int)boundSignature.getArgumentTypes().size(), (int)convention.getArgumentConventions().size());
        int expectedParameterCount = convention.getArgumentConventions().stream().mapToInt(InvocationConvention.InvocationArgumentConvention::getParameterCount).sum();
        expectedParameterCount = (int)((long)expectedParameterCount + methodType.parameterList().stream().filter(ConnectorSession.class::equals).count());
        if (functionInvoker.getInstanceFactory().isPresent()) {
            ++expectedParameterCount;
        }
        Preconditions.checkArgument((expectedParameterCount == methodType.parameterCount() ? 1 : 0) != 0, (String)"Expected %s method parameters, but got %s", (int)expectedParameterCount, (int)methodType.parameterCount());
        int parameterIndex = 0;
        if (functionInvoker.getInstanceFactory().isPresent()) {
            FunctionManager.verifyFunctionSignature(convention.supportsInstanceFactor(), "Method requires instance factory, but calling convention does not support an instance factory", new Object[0]);
            MethodHandle factoryMethod = functionInvoker.getInstanceFactory().orElseThrow();
            FunctionManager.verifyFunctionSignature(methodType.parameterType(parameterIndex).equals(factoryMethod.type().returnType()), "Invalid return type", new Object[0]);
            ++parameterIndex;
        }
        int lambdaArgumentIndex = 0;
        for (int argumentIndex = 0; argumentIndex < boundSignature.getArgumentTypes().size(); ++argumentIndex) {
            while (methodType.parameterType(parameterIndex).equals(ConnectorSession.class)) {
                FunctionManager.verifyFunctionSignature(convention.supportsSession(), "Method requires session, but calling convention does not support session", new Object[0]);
                ++parameterIndex;
            }
            TypeDescriptor.OfField parameterType = methodType.parameterType(parameterIndex);
            Type argumentType = boundSignature.getArgumentTypes().get(argumentIndex);
            InvocationConvention.InvocationArgumentConvention argumentConvention = convention.getArgumentConvention(argumentIndex);
            switch (argumentConvention) {
                case NEVER_NULL: {
                    FunctionManager.verifyFunctionSignature(((Class)parameterType).isAssignableFrom(argumentType.getJavaType()), "Expected argument type to be %s, but is %s", argumentType, parameterType);
                    break;
                }
                case NULL_FLAG: {
                    FunctionManager.verifyFunctionSignature(((Class)parameterType).isAssignableFrom(argumentType.getJavaType()), "Expected argument type to be %s, but is %s", argumentType.getJavaType(), parameterType);
                    FunctionManager.verifyFunctionSignature(methodType.parameterType(parameterIndex + 1).equals(Boolean.TYPE), "Expected null flag parameter to be followed by a boolean parameter", new Object[0]);
                    break;
                }
                case BOXED_NULLABLE: {
                    FunctionManager.verifyFunctionSignature(((Class)parameterType).isAssignableFrom(Primitives.wrap((Class)argumentType.getJavaType())), "Expected argument type to be %s, but is %s", Primitives.wrap((Class)argumentType.getJavaType()), parameterType);
                    break;
                }
                case BLOCK_POSITION: {
                    FunctionManager.verifyFunctionSignature(parameterType.equals(Block.class) && methodType.parameterType(parameterIndex + 1).equals(Integer.TYPE), "Expected BLOCK_POSITION argument have parameters Block and int", new Object[0]);
                    break;
                }
                case FUNCTION: {
                    Class<?> lambdaInterface = functionInvoker.getLambdaInterfaces().get(lambdaArgumentIndex);
                    FunctionManager.verifyFunctionSignature(parameterType.equals(lambdaInterface), "Expected function interface to be %s, but is %s", lambdaInterface, parameterType);
                    ++lambdaArgumentIndex;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown argument convention: " + argumentConvention);
                }
            }
            parameterIndex += argumentConvention.getParameterCount();
        }
        Type returnType = boundSignature.getReturnType();
        switch (convention.getReturnConvention()) {
            case FAIL_ON_NULL: {
                FunctionManager.verifyFunctionSignature(((Class)methodType.returnType()).isAssignableFrom(returnType.getJavaType()), "Expected return type to be %s, but is %s", returnType.getJavaType(), methodType.returnType());
                break;
            }
            case NULLABLE_RETURN: {
                FunctionManager.verifyFunctionSignature(((Class)methodType.returnType()).isAssignableFrom(Primitives.wrap((Class)returnType.getJavaType())), "Expected return type to be %s, but is %s", returnType.getJavaType(), Primitives.wrap((Class)methodType.returnType()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown return convention: " + convention.getReturnConvention());
            }
        }
    }

    private static void verifyFunctionSignature(boolean check, String message, Object ... args) {
        if (!check) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format(message, args));
        }
    }

    public static FunctionManager createTestingFunctionManager() {
        TypeOperators typeOperators = new TypeOperators();
        GlobalFunctionCatalog functionCatalog = new GlobalFunctionCatalog();
        functionCatalog.addFunctions(SystemFunctionBundle.create(new FeaturesConfig(), typeOperators, new BlockTypeOperators(typeOperators), NodeVersion.UNKNOWN));
        functionCatalog.addFunctions(new InternalFunctionBundle(new LiteralFunction(new InternalBlockEncodingSerde(new BlockEncodingManager(), InternalTypeManager.TESTING_TYPE_MANAGER))));
        return new FunctionManager(functionCatalog);
    }

    private static class FunctionKey {
        private final FunctionId functionId;
        private final BoundSignature boundSignature;
        private final Optional<InvocationConvention> invocationConvention;

        public FunctionKey(ResolvedFunction resolvedFunction) {
            this(resolvedFunction.getFunctionId(), resolvedFunction.getSignature(), Optional.empty());
        }

        public FunctionKey(ResolvedFunction resolvedFunction, InvocationConvention invocationConvention) {
            this(resolvedFunction.getFunctionId(), resolvedFunction.getSignature(), Optional.of(invocationConvention));
        }

        public FunctionKey(FunctionId functionId, BoundSignature boundSignature, Optional<InvocationConvention> invocationConvention) {
            this.functionId = Objects.requireNonNull(functionId, "functionId is null");
            this.boundSignature = Objects.requireNonNull(boundSignature, "boundSignature is null");
            this.invocationConvention = Objects.requireNonNull(invocationConvention, "invocationConvention is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionKey that = (FunctionKey)o;
            return this.functionId.equals(that.functionId) && this.boundSignature.equals(that.boundSignature) && this.invocationConvention.equals(that.invocationConvention);
        }

        public int hashCode() {
            return Objects.hash(this.functionId, this.boundSignature, this.invocationConvention);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("functionId", (Object)this.functionId).add("boundSignature", (Object)this.boundSignature).add("invocationConvention", this.invocationConvention.orElse(null)).toString();
        }
    }
}

