/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionId;
import io.trino.metadata.FunctionInvoker;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.window.WindowFunctionSupplier;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.tree.QualifiedName;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class GlobalFunctionCatalog {
    private volatile FunctionMap functions = new FunctionMap();

    public final synchronized void addFunctions(FunctionBundle functionBundle) {
        for (FunctionMetadata functionMetadata : functionBundle.getFunctions()) {
            Preconditions.checkArgument((!functionMetadata.getSignature().getName().contains("|") ? 1 : 0) != 0, (String)"Function name cannot contain '|' character: %s", (Object)functionMetadata.getSignature());
            Preconditions.checkArgument((!functionMetadata.getSignature().getName().contains("@") ? 1 : 0) != 0, (String)"Function name cannot contain '@' character: %s", (Object)functionMetadata.getSignature());
            GlobalFunctionCatalog.checkNotSpecializedTypeOperator(functionMetadata.getSignature());
            for (FunctionMetadata existingFunction : this.functions.list()) {
                Preconditions.checkArgument((!functionMetadata.getFunctionId().equals(existingFunction.getFunctionId()) ? 1 : 0) != 0, (String)"Function already registered: %s", (Object)functionMetadata.getFunctionId());
                Preconditions.checkArgument((!functionMetadata.getSignature().equals(existingFunction.getSignature()) ? 1 : 0) != 0, (String)"Function already registered: %s", (Object)functionMetadata.getSignature());
            }
        }
        this.functions = new FunctionMap(this.functions, functionBundle);
    }

    private static void checkNotSpecializedTypeOperator(Signature signature) {
        TypeVariableConstraint typeParameter;
        BooleanType expectedReturnType;
        String name = signature.getName();
        if (!Signature.isOperatorName(name)) {
            return;
        }
        OperatorType operatorType = Signature.unmangleOperator(name);
        switch (operatorType) {
            case EQUAL: 
            case IS_DISTINCT_FROM: 
            case INDETERMINATE: {
                expectedReturnType = BooleanType.BOOLEAN;
                typeParameter = Signature.comparableTypeParameter("T");
                break;
            }
            case HASH_CODE: 
            case XX_HASH_64: {
                expectedReturnType = BigintType.BIGINT;
                typeParameter = Signature.comparableTypeParameter("T");
                break;
            }
            case COMPARISON_UNORDERED_FIRST: 
            case COMPARISON_UNORDERED_LAST: {
                expectedReturnType = IntegerType.INTEGER;
                typeParameter = Signature.orderableTypeParameter("T");
                break;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                expectedReturnType = BooleanType.BOOLEAN;
                typeParameter = Signature.orderableTypeParameter("T");
                break;
            }
            default: {
                return;
            }
        }
        Signature expectedSignature = new Signature(signature.getName(), (List<TypeVariableConstraint>)ImmutableList.of((Object)typeParameter), (List<LongVariableConstraint>)ImmutableList.of(), expectedReturnType.getTypeSignature(), Collections.nCopies(operatorType.getArgumentCount(), new TypeSignature("T", new TypeSignatureParameter[0])), false);
        Preconditions.checkArgument((boolean)signature.equals(expectedSignature), (String)"Can not register %s functionMetadata: %s", (Object)operatorType, (Object)signature);
    }

    public List<FunctionMetadata> listFunctions() {
        return this.functions.list();
    }

    public Collection<FunctionMetadata> getFunctions(QualifiedName name) {
        return this.functions.get(name);
    }

    public FunctionMetadata getFunctionMetadata(FunctionId functionId) {
        return this.functions.get(functionId);
    }

    public AggregationFunctionMetadata getAggregationFunctionMetadata(FunctionId functionId) {
        return this.functions.getFunctionBundle(functionId).getAggregationFunctionMetadata(functionId);
    }

    public WindowFunctionSupplier getWindowFunctionImplementation(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        return this.functions.getFunctionBundle(functionId).getWindowFunctionImplementation(functionId, boundSignature, functionDependencies);
    }

    public AggregationMetadata getAggregateFunctionImplementation(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        return this.functions.getFunctionBundle(functionId).getAggregateFunctionImplementation(functionId, boundSignature, functionDependencies);
    }

    public FunctionDependencyDeclaration getFunctionDependencies(FunctionId functionId, BoundSignature boundSignature) {
        return this.functions.getFunctionBundle(functionId).getFunctionDependencies(functionId, boundSignature);
    }

    public FunctionInvoker getScalarFunctionInvoker(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies, InvocationConvention invocationConvention) {
        return this.functions.getFunctionBundle(functionId).getScalarFunctionInvoker(functionId, boundSignature, functionDependencies, invocationConvention);
    }

    private static class FunctionMap {
        private final Map<FunctionId, FunctionBundle> functionBundlesById;
        private final Map<FunctionId, FunctionMetadata> functionsById;
        private final Multimap<QualifiedName, FunctionMetadata> functionsByName;

        public FunctionMap() {
            this.functionBundlesById = ImmutableMap.of();
            this.functionsById = ImmutableMap.of();
            this.functionsByName = ImmutableListMultimap.of();
        }

        public FunctionMap(FunctionMap map, FunctionBundle functionBundle) {
            this.functionBundlesById = ImmutableMap.builder().putAll(map.functionBundlesById).putAll((Map)functionBundle.getFunctions().stream().collect(ImmutableMap.toImmutableMap(FunctionMetadata::getFunctionId, functionMetadata -> functionBundle))).buildOrThrow();
            this.functionsById = ImmutableMap.builder().putAll(map.functionsById).putAll((Map)functionBundle.getFunctions().stream().collect(ImmutableMap.toImmutableMap(FunctionMetadata::getFunctionId, Function.identity()))).buildOrThrow();
            ImmutableListMultimap.Builder functionsByName = ImmutableListMultimap.builder().putAll(map.functionsByName);
            functionBundle.getFunctions().forEach(functionMetadata -> functionsByName.put((Object)QualifiedName.of((String)functionMetadata.getSignature().getName()), functionMetadata));
            this.functionsByName = functionsByName.build();
            for (Map.Entry entry : this.functionsByName.asMap().entrySet()) {
                Collection values = (Collection)entry.getValue();
                long aggregations = values.stream().map(FunctionMetadata::getKind).filter(kind -> kind == FunctionKind.AGGREGATE).count();
                Preconditions.checkState((aggregations == 0L || aggregations == (long)values.size() ? 1 : 0) != 0, (String)"'%s' is both an aggregation and a scalar function", entry.getKey());
            }
        }

        public List<FunctionMetadata> list() {
            return ImmutableList.copyOf((Collection)this.functionsByName.values());
        }

        public Collection<FunctionMetadata> get(QualifiedName name) {
            return this.functionsByName.get((Object)name);
        }

        public FunctionMetadata get(FunctionId functionId) {
            FunctionMetadata functionMetadata = this.functionsById.get(functionId);
            Preconditions.checkArgument((functionMetadata != null ? 1 : 0) != 0, (Object)("Unknown function implementation: " + functionId));
            return functionMetadata;
        }

        public FunctionBundle getFunctionBundle(FunctionId functionId) {
            FunctionBundle functionBundle = this.functionBundlesById.get(functionId);
            Preconditions.checkArgument((functionBundle != null ? 1 : 0) != 0, (Object)("Unknown function implementation: " + functionId));
            return functionBundle;
        }
    }
}

