/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.SystemSessionPropertiesProvider;
import io.trino.connector.CatalogName;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.ParameterRewriter;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import javax.inject.Inject;

public final class SessionPropertyManager {
    private static final JsonCodecFactory JSON_CODEC_FACTORY = new JsonCodecFactory();
    private final ConcurrentMap<String, PropertyMetadata<?>> systemSessionProperties = new ConcurrentHashMap();
    private final ConcurrentMap<CatalogName, Map<String, PropertyMetadata<?>>> connectorSessionProperties = new ConcurrentHashMap();

    public SessionPropertyManager() {
        this(new SystemSessionProperties());
    }

    public SessionPropertyManager(SystemSessionPropertiesProvider systemSessionPropertiesProvider) {
        this((Set<SystemSessionPropertiesProvider>)ImmutableSet.of((Object)systemSessionPropertiesProvider));
    }

    @Inject
    public SessionPropertyManager(Set<SystemSessionPropertiesProvider> systemSessionProperties) {
        this((List)systemSessionProperties.stream().flatMap(provider -> provider.getSessionProperties().stream()).collect(ImmutableList.toImmutableList()));
    }

    public SessionPropertyManager(List<PropertyMetadata<?>> systemSessionProperties) {
        this.addSystemSessionProperties(systemSessionProperties);
    }

    public void addSystemSessionProperties(List<PropertyMetadata<?>> systemSessionProperties) {
        systemSessionProperties.forEach(this::addSystemSessionProperty);
    }

    public void addSystemSessionProperty(PropertyMetadata<?> sessionProperty) {
        Objects.requireNonNull(sessionProperty, "sessionProperty is null");
        Preconditions.checkState((this.systemSessionProperties.put(sessionProperty.getName(), sessionProperty) == null ? 1 : 0) != 0, (String)"System session property '%s' are already registered", (Object)sessionProperty.getName());
    }

    public void addConnectorSessionProperties(CatalogName catalogName, List<PropertyMetadata<?>> properties) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(properties, "properties is null");
        ImmutableMap propertiesByName = Maps.uniqueIndex(properties, PropertyMetadata::getName);
        Preconditions.checkState((this.connectorSessionProperties.putIfAbsent(catalogName, (Map<String, PropertyMetadata<?>>)propertiesByName) == null ? 1 : 0) != 0, (String)"Session properties for catalog '%s' are already registered", (Object)catalogName);
    }

    public void removeConnectorSessionProperties(CatalogName catalogName) {
        this.connectorSessionProperties.remove(catalogName);
    }

    public Optional<PropertyMetadata<?>> getSystemSessionPropertyMetadata(String name) {
        Objects.requireNonNull(name, "name is null");
        return Optional.ofNullable((PropertyMetadata)this.systemSessionProperties.get(name));
    }

    public Optional<PropertyMetadata<?>> getConnectorSessionPropertyMetadata(CatalogName catalogName, String propertyName) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        Map properties = (Map)this.connectorSessionProperties.get(catalogName);
        if (properties == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown catalog: " + catalogName);
        }
        if (properties.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "No session properties found for catalog: " + catalogName);
        }
        return Optional.ofNullable((PropertyMetadata)properties.get(propertyName));
    }

    public List<SessionPropertyValue> getAllSessionProperties(Session session, Map<String, CatalogName> catalogs) {
        Objects.requireNonNull(session, "session is null");
        ImmutableList.Builder sessionPropertyValues = ImmutableList.builder();
        Map<String, String> systemProperties = session.getSystemProperties();
        for (PropertyMetadata<?> propertyMetadata : new TreeMap(this.systemSessionProperties).values()) {
            String defaultValue = MoreObjects.firstNonNull((Object)propertyMetadata.getDefaultValue(), (Object)"").toString();
            String value = systemProperties.getOrDefault(propertyMetadata.getName(), defaultValue);
            sessionPropertyValues.add((Object)new SessionPropertyValue(value, defaultValue, propertyMetadata.getName(), Optional.empty(), propertyMetadata.getName(), propertyMetadata.getDescription(), propertyMetadata.getSqlType().getDisplayName(), propertyMetadata.isHidden()));
        }
        for (Map.Entry entry : new TreeMap<String, CatalogName>(catalogs).entrySet()) {
            String catalog = (String)entry.getKey();
            CatalogName catalogName = (CatalogName)entry.getValue();
            Map<String, String> connectorProperties = session.getCatalogProperties(catalog);
            for (PropertyMetadata property : new TreeMap((Map)this.connectorSessionProperties.get(catalogName)).values()) {
                String defaultValue = MoreObjects.firstNonNull((Object)property.getDefaultValue(), (Object)"").toString();
                String value = connectorProperties.getOrDefault(property.getName(), defaultValue);
                sessionPropertyValues.add((Object)new SessionPropertyValue(value, defaultValue, catalog + "." + property.getName(), Optional.of(catalog), property.getName(), property.getDescription(), property.getSqlType().getDisplayName(), property.isHidden()));
            }
        }
        return sessionPropertyValues.build();
    }

    public <T> T decodeSystemPropertyValue(String name, @Nullable String value, Class<T> type) {
        PropertyMetadata<?> property = this.getSystemSessionPropertyMetadata(name).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + name));
        return SessionPropertyManager.decodePropertyValue(name, value, type, property);
    }

    public <T> T decodeCatalogPropertyValue(CatalogName catalog, String catalogName, String propertyName, @Nullable String propertyValue, Class<T> type) {
        String fullPropertyName = catalogName + "." + propertyName;
        PropertyMetadata<?> property = this.getConnectorSessionPropertyMetadata(catalog, propertyName).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + fullPropertyName));
        return SessionPropertyManager.decodePropertyValue(fullPropertyName, propertyValue, type, property);
    }

    public void validateSystemSessionProperty(String propertyName, String propertyValue) {
        PropertyMetadata<?> propertyMetadata = this.getSystemSessionPropertyMetadata(propertyName).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + propertyName));
        SessionPropertyManager.decodePropertyValue(propertyName, propertyValue, propertyMetadata.getJavaType(), propertyMetadata);
    }

    public void validateCatalogSessionProperty(CatalogName catalog, String propertyName, String propertyValue) {
        String fullPropertyName = catalog.getCatalogName() + "." + propertyName;
        PropertyMetadata<?> propertyMetadata = this.getConnectorSessionPropertyMetadata(catalog, propertyName).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + fullPropertyName));
        SessionPropertyManager.decodePropertyValue(fullPropertyName, propertyValue, propertyMetadata.getJavaType(), propertyMetadata);
    }

    private static <T> T decodePropertyValue(String fullPropertyName, @Nullable String propertyValue, Class<T> type, PropertyMetadata<?> metadata) {
        if (metadata.getJavaType() != type) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Property %s is type %s, but requested type was %s", fullPropertyName, metadata.getJavaType().getName(), type.getName()));
        }
        if (propertyValue == null) {
            return type.cast(metadata.getDefaultValue());
        }
        Object objectValue = SessionPropertyManager.deserializeSessionProperty(metadata.getSqlType(), propertyValue);
        try {
            return type.cast(metadata.decode(objectValue));
        }
        catch (TrinoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s is invalid: %s", fullPropertyName, propertyValue), (Throwable)e);
        }
    }

    public static Object evaluatePropertyValue(Expression expression, Type expectedType, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters) {
        Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(parameters), (Expression)expression);
        Object value = ExpressionInterpreter.evaluateConstantExpression(rewritten, expectedType, plannerContext, session, accessControl, parameters);
        BlockBuilder blockBuilder = expectedType.createBlockBuilder(null, 1);
        TypeUtils.writeNativeValue((Type)expectedType, (BlockBuilder)blockBuilder, (Object)value);
        Object objectValue = expectedType.getObjectValue(session.toConnectorSession(), (Block)blockBuilder, 0);
        if (objectValue == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Session property value must not be null");
        }
        return objectValue;
    }

    public static String serializeSessionProperty(Type type, Object value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Session property cannot be null");
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return value.toString();
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return value.toString();
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return value.toString();
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return value.toString();
        }
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return value.toString();
        }
        if (type instanceof ArrayType || type instanceof MapType) {
            return SessionPropertyManager.getJsonCodecForType(type).toJson(value);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Session property type %s is not supported", type));
    }

    private static Object deserializeSessionProperty(Type type, String value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Session property cannot be null");
        }
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return value;
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return Boolean.valueOf(value);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return Long.valueOf(value);
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return Integer.valueOf(value);
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return Double.valueOf(value);
        }
        if (type instanceof ArrayType || type instanceof MapType) {
            return SessionPropertyManager.getJsonCodecForType(type).fromJson(value);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Session property type %s is not supported", type));
    }

    private static <T> JsonCodec<T> getJsonCodecForType(Type type) {
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(String.class);
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(Boolean.class);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(Long.class);
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(Integer.class);
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(Double.class);
        }
        if (type instanceof ArrayType) {
            Type elementType = ((ArrayType)type).getElementType();
            return JSON_CODEC_FACTORY.listJsonCodec(SessionPropertyManager.getJsonCodecForType(elementType));
        }
        if (type instanceof MapType) {
            Type keyType = ((MapType)type).getKeyType();
            Type valueType = ((MapType)type).getValueType();
            return JSON_CODEC_FACTORY.mapJsonCodec(SessionPropertyManager.getMapKeyType(keyType), SessionPropertyManager.getJsonCodecForType(valueType));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Session property type %s is not supported", type));
    }

    private static Class<?> getMapKeyType(Type type) {
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return String.class;
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return Boolean.class;
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return Long.class;
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return Integer.class;
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return Double.class;
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Session property map key type %s is not supported", type));
    }

    public static class SessionPropertyValue {
        private final String fullyQualifiedName;
        private final Optional<String> catalogName;
        private final String propertyName;
        private final String description;
        private final String type;
        private final String value;
        private final String defaultValue;
        private final boolean hidden;

        private SessionPropertyValue(String value, String defaultValue, String fullyQualifiedName, Optional<String> catalogName, String propertyName, String description, String type, boolean hidden) {
            this.fullyQualifiedName = fullyQualifiedName;
            this.catalogName = catalogName;
            this.propertyName = propertyName;
            this.description = description;
            this.type = type;
            this.value = value;
            this.defaultValue = defaultValue;
            this.hidden = hidden;
        }

        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public Optional<String> getCatalogName() {
            return this.catalogName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getDescription() {
            return this.description;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isHidden() {
            return this.hidden;
        }
    }
}

