/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.connector.CatalogName;
import io.trino.execution.Lifespan;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public final class Split {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(Split.class).instanceSize();
    private final CatalogName catalogName;
    private final ConnectorSplit connectorSplit;
    private final Lifespan lifespan;

    @JsonCreator
    public Split(@JsonProperty(value="catalogName") CatalogName catalogName, @JsonProperty(value="connectorSplit") ConnectorSplit connectorSplit, @JsonProperty(value="lifespan") Lifespan lifespan) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.connectorSplit = Objects.requireNonNull(connectorSplit, "connectorSplit is null");
        this.lifespan = Objects.requireNonNull(lifespan, "lifespan is null");
    }

    @JsonProperty
    public CatalogName getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public ConnectorSplit getConnectorSplit() {
        return this.connectorSplit;
    }

    @JsonProperty
    public Lifespan getLifespan() {
        return this.lifespan;
    }

    public Object getInfo() {
        return this.connectorSplit.getInfo();
    }

    public List<HostAddress> getAddresses() {
        return this.connectorSplit.getAddresses();
    }

    public boolean isRemotelyAccessible() {
        return this.connectorSplit.isRemotelyAccessible();
    }

    public SplitWeight getSplitWeight() {
        return this.connectorSplit.getSplitWeight();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogName", (Object)this.catalogName).add("connectorSplit", (Object)this.connectorSplit).add("lifespan", (Object)this.lifespan).toString();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.catalogName.getRetainedSizeInBytes() + this.connectorSplit.getRetainedSizeInBytes() + this.lifespan.getRetainedSizeInBytes();
    }
}

