/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.connector.CatalogName;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.sql.planner.PartitioningHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TableLayout {
    private final CatalogName catalogName;
    private final ConnectorTransactionHandle transactionHandle;
    private final ConnectorTableLayout layout;

    @JsonCreator
    public TableLayout(@JsonProperty(value="catalogName") CatalogName catalogName, @JsonProperty(value="transactionHandle") ConnectorTransactionHandle transactionHandle, @JsonProperty(value="layout") ConnectorTableLayout layout) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.transactionHandle = Objects.requireNonNull(transactionHandle, "transactionHandle is null");
        this.layout = Objects.requireNonNull(layout, "layout is null");
    }

    @JsonProperty
    public CatalogName getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public ConnectorTableLayout getLayout() {
        return this.layout;
    }

    public Optional<PartitioningHandle> getPartitioning() {
        return this.layout.getPartitioning().map(partitioning -> new PartitioningHandle(Optional.of(this.catalogName), Optional.of(this.transactionHandle), (ConnectorPartitioningHandle)partitioning));
    }

    public List<String> getPartitionColumns() {
        return this.layout.getPartitionColumns();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableLayout that = (TableLayout)o;
        return Objects.equals(this.catalogName, that.catalogName) && Objects.equals(this.transactionHandle, that.transactionHandle) && Objects.equals(this.layout, that.layout);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.transactionHandle, this.layout);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogName", (Object)this.catalogName).add("transactionHandle", (Object)this.transactionHandle).add("layout", (Object)this.layout).toString();
    }
}

