/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import io.trino.operator.AbstractRowChangeOperator;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Objects;

public class DeleteOperator
extends AbstractRowChangeOperator {
    private final int rowIdChannel;

    public DeleteOperator(OperatorContext operatorContext, int rowIdChannel) {
        super(operatorContext);
        this.rowIdChannel = rowIdChannel;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.state == AbstractRowChangeOperator.State.RUNNING ? 1 : 0) != 0, (String)"Operator is %s", (Object)((Object)this.state));
        Block rowIds = page.getBlock(this.rowIdChannel);
        this.pageSource().deleteRows(rowIds);
        this.rowCount += (long)rowIds.getPositionCount();
    }

    public static class DeleteOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final int rowIdChannel;
        private boolean closed;

        public DeleteOperatorFactory(int operatorId, PlanNodeId planNodeId, int rowIdChannel) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.rowIdChannel = rowIdChannel;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, DeleteOperator.class.getSimpleName());
            return new DeleteOperator(context, this.rowIdChannel);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new DeleteOperatorFactory(this.operatorId, this.planNodeId, this.rowIdChannel);
        }
    }
}

