/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.memory.context.MemoryTrackingContext;
import io.trino.operator.BasicWorkProcessorOperatorAdapter;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.OperatorFactory;
import io.trino.operator.ProcessorContext;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorOperator;
import io.trino.operator.project.MergePages;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class FilterAndProjectOperator
implements WorkProcessorOperator {
    private final WorkProcessor<Page> pages;

    private FilterAndProjectOperator(Session session, MemoryTrackingContext memoryTrackingContext, DriverYieldSignal yieldSignal, WorkProcessor<Page> sourcePages, PageProcessor pageProcessor, List<Type> types, DataSize minOutputPageSize, int minOutputPageRowCount, boolean avoidPageMaterialization) {
        AggregatedMemoryContext localAggregatedMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        LocalMemoryContext outputMemoryContext = localAggregatedMemoryContext.newLocalMemoryContext(FilterAndProjectOperator.class.getSimpleName());
        ConnectorSession connectorSession = session.toConnectorSession();
        this.pages = sourcePages.flatMap(page -> pageProcessor.createWorkProcessor(connectorSession, yieldSignal, outputMemoryContext, (Page)page, avoidPageMaterialization)).transformProcessor(processor -> MergePages.mergePages(types, minOutputPageSize.toBytes(), minOutputPageRowCount, processor, localAggregatedMemoryContext)).blocking(() -> memoryTrackingContext.localUserMemoryContext().setBytes(localAggregatedMemoryContext.getBytes()));
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    public static OperatorFactory createOperatorFactory(int operatorId, PlanNodeId planNodeId, Supplier<PageProcessor> processor, List<Type> types, DataSize minOutputPageSize, int minOutputPageRowCount) {
        return BasicWorkProcessorOperatorAdapter.createAdapterOperatorFactory(new Factory(operatorId, planNodeId, processor, types, minOutputPageSize, minOutputPageRowCount));
    }

    private static class Factory
    implements BasicWorkProcessorOperatorAdapter.BasicAdapterWorkProcessorOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Supplier<PageProcessor> processor;
        private final List<Type> types;
        private final DataSize minOutputPageSize;
        private final int minOutputPageRowCount;
        private boolean closed;

        private Factory(int operatorId, PlanNodeId planNodeId, Supplier<PageProcessor> processor, List<Type> types, DataSize minOutputPageSize, int minOutputPageRowCount) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.processor = Objects.requireNonNull(processor, "processor is null");
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.minOutputPageSize = Objects.requireNonNull(minOutputPageSize, "minOutputPageSize is null");
            this.minOutputPageRowCount = minOutputPageRowCount;
        }

        @Override
        public WorkProcessorOperator create(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return new FilterAndProjectOperator(processorContext.getSession(), processorContext.getMemoryTrackingContext(), processorContext.getDriverYieldSignal(), sourcePages, this.processor.get(), this.types, this.minOutputPageSize, this.minOutputPageRowCount, true);
        }

        @Override
        public WorkProcessorOperator createAdapterOperator(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return new FilterAndProjectOperator(processorContext.getSession(), processorContext.getMemoryTrackingContext(), processorContext.getDriverYieldSignal(), sourcePages, this.processor.get(), this.types, this.minOutputPageSize, this.minOutputPageRowCount, false);
        }

        @Override
        public int getOperatorId() {
            return this.operatorId;
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.planNodeId;
        }

        @Override
        public String getOperatorType() {
            return FilterAndProjectOperator.class.getSimpleName();
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public BasicWorkProcessorOperatorAdapter.BasicAdapterWorkProcessorOperatorFactory duplicate() {
            return new Factory(this.operatorId, this.planNodeId, this.processor, this.types, this.minOutputPageSize, this.minOutputPageRowCount);
        }
    }
}

