/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AtomicDouble;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.stats.CounterStat;
import io.airlift.stats.GcMonitor;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.execution.DynamicFiltersCollector;
import io.trino.execution.Lifespan;
import io.trino.execution.TaskId;
import io.trino.execution.TaskState;
import io.trino.execution.TaskStateMachine;
import io.trino.execution.buffer.LazyOutputBuffer;
import io.trino.memory.QueryContext;
import io.trino.memory.QueryContextVisitor;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.memory.context.MemoryTrackingContext;
import io.trino.operator.BlockedReason;
import io.trino.operator.PipelineContext;
import io.trino.operator.PipelineStats;
import io.trino.operator.TaskStats;
import io.trino.spi.predicate.Domain;
import io.trino.sql.planner.LocalDynamicFiltersCollector;
import io.trino.sql.planner.plan.DynamicFilterId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public class TaskContext {
    private final QueryContext queryContext;
    private final TaskStateMachine taskStateMachine;
    private final GcMonitor gcMonitor;
    private final Executor notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final Session session;
    private final long createNanos = System.nanoTime();
    private final AtomicLong startNanos = new AtomicLong();
    private final AtomicLong startFullGcCount = new AtomicLong(-1L);
    private final AtomicLong startFullGcTimeNanos = new AtomicLong(-1L);
    private final AtomicLong endNanos = new AtomicLong();
    private final AtomicLong endFullGcCount = new AtomicLong(-1L);
    private final AtomicLong endFullGcTimeNanos = new AtomicLong(-1L);
    private final AtomicReference<DateTime> executionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> lastExecutionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> executionEndTime = new AtomicReference();
    private final Set<Lifespan> completedDriverGroups = Sets.newConcurrentHashSet();
    private final List<PipelineContext> pipelineContexts = new CopyOnWriteArrayList<PipelineContext>();
    private final boolean perOperatorCpuTimerEnabled;
    private final boolean cpuTimerEnabled;
    private final Object cumulativeMemoryLock = new Object();
    private final AtomicDouble cumulativeUserMemory = new AtomicDouble(0.0);
    @GuardedBy(value="cumulativeMemoryLock")
    private long lastUserMemoryReservation;
    @GuardedBy(value="cumulativeMemoryLock")
    private long lastTaskStatCallNanos;
    private final MemoryTrackingContext taskMemoryContext;
    private final DynamicFiltersCollector dynamicFiltersCollector;
    private final LocalDynamicFiltersCollector localDynamicFiltersCollector;

    public static TaskContext createTaskContext(QueryContext queryContext, TaskStateMachine taskStateMachine, GcMonitor gcMonitor, Executor notificationExecutor, ScheduledExecutorService yieldExecutor, Session session, MemoryTrackingContext taskMemoryContext, Runnable notifyStatusChanged, boolean perOperatorCpuTimerEnabled, boolean cpuTimerEnabled) {
        TaskContext taskContext = new TaskContext(queryContext, taskStateMachine, gcMonitor, notificationExecutor, yieldExecutor, session, taskMemoryContext, notifyStatusChanged, perOperatorCpuTimerEnabled, cpuTimerEnabled);
        taskContext.initialize();
        return taskContext;
    }

    private TaskContext(QueryContext queryContext, TaskStateMachine taskStateMachine, GcMonitor gcMonitor, Executor notificationExecutor, ScheduledExecutorService yieldExecutor, Session session, MemoryTrackingContext taskMemoryContext, Runnable notifyStatusChanged, boolean perOperatorCpuTimerEnabled, boolean cpuTimerEnabled) {
        this.taskStateMachine = Objects.requireNonNull(taskStateMachine, "taskStateMachine is null");
        this.gcMonitor = Objects.requireNonNull(gcMonitor, "gcMonitor is null");
        this.queryContext = Objects.requireNonNull(queryContext, "queryContext is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.yieldExecutor = Objects.requireNonNull(yieldExecutor, "yieldExecutor is null");
        this.session = session;
        this.taskMemoryContext = Objects.requireNonNull(taskMemoryContext, "taskMemoryContext is null");
        this.taskMemoryContext.initializeLocalMemoryContexts(LazyOutputBuffer.class.getSimpleName());
        this.dynamicFiltersCollector = new DynamicFiltersCollector(notifyStatusChanged);
        this.localDynamicFiltersCollector = new LocalDynamicFiltersCollector(session);
        this.perOperatorCpuTimerEnabled = perOperatorCpuTimerEnabled;
        this.cpuTimerEnabled = cpuTimerEnabled;
    }

    private void initialize() {
        this.taskStateMachine.addStateChangeListener(this::updateStatsIfDone);
    }

    public TaskId getTaskId() {
        return this.taskStateMachine.getTaskId();
    }

    public PipelineContext addPipelineContext(int pipelineId, boolean inputPipeline, boolean outputPipeline, boolean partitioned) {
        PipelineContext pipelineContext = new PipelineContext(pipelineId, this, this.notificationExecutor, this.yieldExecutor, this.taskMemoryContext.newMemoryTrackingContext(), inputPipeline, outputPipeline, partitioned);
        this.pipelineContexts.add(pipelineContext);
        return pipelineContext;
    }

    public Session getSession() {
        return this.session;
    }

    public void start() {
        DateTime now = DateTime.now();
        this.executionStartTime.compareAndSet(null, now);
        this.startNanos.compareAndSet(0L, System.nanoTime());
        this.startFullGcCount.compareAndSet(-1L, this.gcMonitor.getMajorGcCount());
        this.startFullGcTimeNanos.compareAndSet(-1L, this.gcMonitor.getMajorGcTime().roundTo(TimeUnit.NANOSECONDS));
        this.lastExecutionStartTime.set(now);
    }

    private void updateStatsIfDone(TaskState newState) {
        if (newState.isDone()) {
            DateTime now = DateTime.now();
            long majorGcCount = this.gcMonitor.getMajorGcCount();
            long majorGcTime = this.gcMonitor.getMajorGcTime().roundTo(TimeUnit.NANOSECONDS);
            this.executionStartTime.compareAndSet(null, now);
            this.startNanos.compareAndSet(0L, System.nanoTime());
            this.startFullGcCount.compareAndSet(-1L, majorGcCount);
            this.startFullGcTimeNanos.compareAndSet(-1L, majorGcTime);
            this.lastExecutionStartTime.compareAndSet(null, now);
            this.executionEndTime.compareAndSet(null, now);
            this.endNanos.compareAndSet(0L, System.nanoTime());
            this.endFullGcCount.compareAndSet(-1L, majorGcCount);
            this.endFullGcTimeNanos.compareAndSet(-1L, majorGcTime);
        }
    }

    public void failed(Throwable cause) {
        this.taskStateMachine.failed(cause);
    }

    public boolean isDone() {
        return this.taskStateMachine.getState().isDone();
    }

    public TaskState getState() {
        return this.taskStateMachine.getState();
    }

    public DataSize getMemoryReservation() {
        return DataSize.ofBytes((long)this.taskMemoryContext.getUserMemory());
    }

    public DataSize getRevocableMemoryReservation() {
        return DataSize.ofBytes((long)this.taskMemoryContext.getRevocableMemory());
    }

    public Set<Lifespan> getCompletedDriverGroups() {
        return this.completedDriverGroups;
    }

    public void addCompletedDriverGroup(Lifespan driverGroup) {
        Preconditions.checkArgument((!driverGroup.isTaskWide() ? 1 : 0) != 0, (Object)"driverGroup is task-wide, not a driver group.");
        this.completedDriverGroups.add(driverGroup);
    }

    public List<PipelineContext> getPipelineContexts() {
        return this.pipelineContexts;
    }

    public synchronized ListenableFuture<Void> reserveSpill(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        return this.queryContext.reserveSpill(bytes);
    }

    public synchronized void freeSpill(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        this.queryContext.freeSpill(bytes);
    }

    public LocalMemoryContext localMemoryContext() {
        return this.taskMemoryContext.localUserMemoryContext();
    }

    public boolean isPerOperatorCpuTimerEnabled() {
        return this.perOperatorCpuTimerEnabled;
    }

    public boolean isCpuTimerEnabled() {
        return this.cpuTimerEnabled;
    }

    public CounterStat getProcessedInputDataSize() {
        CounterStat stat = new CounterStat();
        for (PipelineContext pipelineContext : this.pipelineContexts) {
            if (!pipelineContext.isInputPipeline()) continue;
            stat.merge(pipelineContext.getProcessedInputDataSize());
        }
        return stat;
    }

    public CounterStat getInputPositions() {
        CounterStat stat = new CounterStat();
        for (PipelineContext pipelineContext : this.pipelineContexts) {
            if (!pipelineContext.isInputPipeline()) continue;
            stat.merge(pipelineContext.getInputPositions());
        }
        return stat;
    }

    public CounterStat getOutputDataSize() {
        CounterStat stat = new CounterStat();
        for (PipelineContext pipelineContext : this.pipelineContexts) {
            if (!pipelineContext.isOutputPipeline()) continue;
            stat.merge(pipelineContext.getOutputDataSize());
        }
        return stat;
    }

    public CounterStat getOutputPositions() {
        CounterStat stat = new CounterStat();
        for (PipelineContext pipelineContext : this.pipelineContexts) {
            if (!pipelineContext.isOutputPipeline()) continue;
            stat.merge(pipelineContext.getOutputPositions());
        }
        return stat;
    }

    public Duration getFullGcTime() {
        long startFullGcTimeNanos = this.startFullGcTimeNanos.get();
        if (startFullGcTimeNanos < 0L) {
            return new Duration(0.0, TimeUnit.MILLISECONDS);
        }
        long endFullGcTimeNanos = this.endFullGcTimeNanos.get();
        if (endFullGcTimeNanos < 0L) {
            endFullGcTimeNanos = this.gcMonitor.getMajorGcTime().roundTo(TimeUnit.NANOSECONDS);
        }
        return new Duration((double)Math.max(0L, endFullGcTimeNanos - startFullGcTimeNanos), TimeUnit.NANOSECONDS);
    }

    public int getFullGcCount() {
        long startFullGcCount = this.startFullGcCount.get();
        if (startFullGcCount < 0L) {
            return 0;
        }
        long endFullGcCount = this.endFullGcCount.get();
        if (endFullGcCount <= 0L) {
            endFullGcCount = this.gcMonitor.getMajorGcCount();
        }
        return Math.toIntExact(Math.max(0L, endFullGcCount - startFullGcCount));
    }

    public void updateDomains(Map<DynamicFilterId, Domain> dynamicFilterDomains) {
        this.dynamicFiltersCollector.updateDomains(dynamicFilterDomains);
    }

    public long getDynamicFiltersVersion() {
        return this.dynamicFiltersCollector.getDynamicFiltersVersion();
    }

    public DynamicFiltersCollector.VersionedDynamicFilterDomains acknowledgeAndGetNewDynamicFilterDomains(long callersCurrentVersion) {
        return this.dynamicFiltersCollector.acknowledgeAndGetNewDomains(callersCurrentVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskStats getTaskStats() {
        this.updateStatsIfDone(this.taskStateMachine.getState());
        ImmutableList pipelineStats = ImmutableList.copyOf((Iterable)Iterables.transform(this.pipelineContexts, PipelineContext::getPipelineStats));
        long lastExecutionEndTime = 0L;
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int queuedPartitionedDrivers = 0;
        long queuedPartitionedSplitsWeight = 0L;
        int runningDrivers = 0;
        int runningPartitionedDrivers = 0;
        long runningPartitionedSplitsWeight = 0L;
        int blockedDrivers = 0;
        int completedDrivers = 0;
        long totalScheduledTime = 0L;
        long totalCpuTime = 0L;
        long totalBlockedTime = 0L;
        long physicalInputDataSize = 0L;
        long physicalInputPositions = 0L;
        long physicalInputReadTime = 0L;
        long internalNetworkInputDataSize = 0L;
        long internalNetworkInputPositions = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        long processedInputDataSize = 0L;
        long processedInputPositions = 0L;
        long outputDataSize = 0L;
        long outputPositions = 0L;
        long physicalWrittenDataSize = 0L;
        boolean hasRunningPipelines = false;
        boolean runningPipelinesFullyBlocked = true;
        ImmutableSet.Builder blockedReasons = ImmutableSet.builder();
        for (PipelineStats pipeline : pipelineStats) {
            if (pipeline.getLastEndTime() != null) {
                lastExecutionEndTime = Math.max(pipeline.getLastEndTime().getMillis(), lastExecutionEndTime);
            }
            if (pipeline.getRunningDrivers() > 0 || pipeline.getRunningPartitionedDrivers() > 0 || pipeline.getBlockedDrivers() > 0) {
                hasRunningPipelines = true;
                runningPipelinesFullyBlocked &= pipeline.isFullyBlocked();
                blockedReasons.addAll(pipeline.getBlockedReasons());
            }
            totalDrivers += pipeline.getTotalDrivers();
            queuedDrivers += pipeline.getQueuedDrivers();
            queuedPartitionedDrivers += pipeline.getQueuedPartitionedDrivers();
            queuedPartitionedSplitsWeight += pipeline.getQueuedPartitionedSplitsWeight();
            runningDrivers += pipeline.getRunningDrivers();
            runningPartitionedDrivers += pipeline.getRunningPartitionedDrivers();
            runningPartitionedSplitsWeight += pipeline.getRunningPartitionedSplitsWeight();
            blockedDrivers += pipeline.getBlockedDrivers();
            completedDrivers += pipeline.getCompletedDrivers();
            totalScheduledTime += pipeline.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
            totalCpuTime += pipeline.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
            totalBlockedTime += pipeline.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            if (pipeline.isInputPipeline()) {
                physicalInputDataSize += pipeline.getPhysicalInputDataSize().toBytes();
                physicalInputPositions += pipeline.getPhysicalInputPositions();
                physicalInputReadTime += pipeline.getPhysicalInputReadTime().roundTo(TimeUnit.NANOSECONDS);
                internalNetworkInputDataSize += pipeline.getInternalNetworkInputDataSize().toBytes();
                internalNetworkInputPositions += pipeline.getInternalNetworkInputPositions();
                rawInputDataSize += pipeline.getRawInputDataSize().toBytes();
                rawInputPositions += pipeline.getRawInputPositions();
                processedInputDataSize += pipeline.getProcessedInputDataSize().toBytes();
                processedInputPositions += pipeline.getProcessedInputPositions();
            }
            if (pipeline.isOutputPipeline()) {
                outputDataSize += pipeline.getOutputDataSize().toBytes();
                outputPositions += pipeline.getOutputPositions();
            }
            physicalWrittenDataSize += pipeline.getPhysicalWrittenDataSize().toBytes();
        }
        long startNanos = this.startNanos.get();
        if (startNanos == 0L) {
            startNanos = System.nanoTime();
        }
        Duration queuedTime = new Duration((double)(startNanos - this.createNanos), TimeUnit.NANOSECONDS);
        long endNanos = this.endNanos.get();
        Duration elapsedTime = endNanos >= startNanos ? new Duration((double)(endNanos - this.createNanos), TimeUnit.NANOSECONDS) : new Duration((double)(System.nanoTime() - this.createNanos), TimeUnit.NANOSECONDS);
        int fullGcCount = this.getFullGcCount();
        Duration fullGcTime = this.getFullGcTime();
        long userMemory = this.taskMemoryContext.getUserMemory();
        Object object = this.cumulativeMemoryLock;
        synchronized (object) {
            long currentTimeNanos = System.nanoTime();
            double sinceLastPeriodMillis = (double)(currentTimeNanos - this.lastTaskStatCallNanos) / 1000000.0;
            long averageUserMemoryForLastPeriod = (userMemory + this.lastUserMemoryReservation) / 2L;
            this.cumulativeUserMemory.addAndGet((double)averageUserMemoryForLastPeriod * sinceLastPeriodMillis);
            this.lastTaskStatCallNanos = currentTimeNanos;
            this.lastUserMemoryReservation = userMemory;
        }
        boolean fullyBlocked = hasRunningPipelines && runningPipelinesFullyBlocked;
        return new TaskStats(this.taskStateMachine.getCreatedTime(), this.executionStartTime.get(), this.lastExecutionStartTime.get(), lastExecutionEndTime == 0L ? null : new DateTime(lastExecutionEndTime), this.executionEndTime.get(), elapsedTime.convertToMostSuccinctTimeUnit(), queuedTime.convertToMostSuccinctTimeUnit(), totalDrivers, queuedDrivers, queuedPartitionedDrivers, queuedPartitionedSplitsWeight, runningDrivers, runningPartitionedDrivers, runningPartitionedSplitsWeight, blockedDrivers, completedDrivers, this.cumulativeUserMemory.get(), DataSize.succinctBytes((long)userMemory), DataSize.succinctBytes((long)this.taskMemoryContext.getRevocableMemory()), new Duration((double)totalScheduledTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalCpuTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), fullyBlocked && (runningDrivers > 0 || runningPartitionedDrivers > 0), (Set<BlockedReason>)blockedReasons.build(), DataSize.succinctBytes((long)physicalInputDataSize), physicalInputPositions, new Duration((double)physicalInputReadTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)internalNetworkInputDataSize), internalNetworkInputPositions, DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, DataSize.succinctBytes((long)processedInputDataSize), processedInputPositions, DataSize.succinctBytes((long)outputDataSize), outputPositions, DataSize.succinctBytes((long)physicalWrittenDataSize), fullGcCount, fullGcTime, (List<PipelineStats>)pipelineStats);
    }

    public <C, R> R accept(QueryContextVisitor<C, R> visitor, C context) {
        return visitor.visitTaskContext(this, context);
    }

    public <C, R> List<R> acceptChildren(QueryContextVisitor<C, R> visitor, C context) {
        return this.pipelineContexts.stream().map(pipelineContext -> pipelineContext.accept(visitor, context)).collect(Collectors.toList());
    }

    @VisibleForTesting
    public synchronized MemoryTrackingContext getTaskMemoryContext() {
        return this.taskMemoryContext;
    }

    @VisibleForTesting
    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    public LocalDynamicFiltersCollector getLocalDynamicFiltersCollector() {
        return this.localDynamicFiltersCollector;
    }

    public void addDynamicFilter(Map<DynamicFilterId, Domain> dynamicFilterDomains) {
        this.localDynamicFiltersCollector.collectDynamicFilterDomains(dynamicFilterDomains);
    }

    public void sourceTaskFailed(TaskId taskId, Throwable failure) {
        this.taskStateMachine.sourceTaskFailed(taskId, failure);
    }
}

