/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.operator.window.FrameInfo;
import io.trino.operator.window.MappedWindowFunction;
import io.trino.operator.window.WindowFunctionSupplier;
import io.trino.spi.function.WindowFunction;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class WindowFunctionDefinition {
    private final WindowFunctionSupplier functionSupplier;
    private final Type type;
    private final Optional<FrameInfo> frameInfo;
    private final List<Integer> argumentChannels;
    private final boolean ignoreNulls;
    private final List<Supplier<Object>> lambdaProviders;

    public static WindowFunctionDefinition window(WindowFunctionSupplier functionSupplier, Type type, FrameInfo frameInfo, boolean ignoreNulls, List<Supplier<Object>> lambdaProviders, List<Integer> inputs) {
        return new WindowFunctionDefinition(functionSupplier, type, Optional.of(frameInfo), ignoreNulls, lambdaProviders, inputs);
    }

    public static WindowFunctionDefinition window(WindowFunctionSupplier functionSupplier, Type type, FrameInfo frameInfo, boolean ignoreNulls, List<Supplier<Object>> lambdaProviders, Integer ... inputs) {
        return WindowFunctionDefinition.window(functionSupplier, type, frameInfo, ignoreNulls, lambdaProviders, Arrays.asList(inputs));
    }

    public static WindowFunctionDefinition window(WindowFunctionSupplier functionSupplier, Type type, boolean ignoreNulls, List<Supplier<Object>> lambdaProviders, List<Integer> inputs) {
        return new WindowFunctionDefinition(functionSupplier, type, Optional.empty(), ignoreNulls, lambdaProviders, inputs);
    }

    private WindowFunctionDefinition(WindowFunctionSupplier functionSupplier, Type type, Optional<FrameInfo> frameInfo, boolean ignoreNulls, List<Supplier<Object>> lambdaProviders, List<Integer> argumentChannels) {
        Objects.requireNonNull(functionSupplier, "functionSupplier is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(frameInfo, "frameInfo is null");
        Objects.requireNonNull(lambdaProviders, "lambdaProviders is null");
        Objects.requireNonNull(argumentChannels, "argumentChannels is null");
        this.functionSupplier = functionSupplier;
        this.type = type;
        this.frameInfo = frameInfo;
        this.ignoreNulls = ignoreNulls;
        this.lambdaProviders = lambdaProviders;
        this.argumentChannels = ImmutableList.copyOf(argumentChannels);
    }

    public Optional<FrameInfo> getFrameInfo() {
        return this.frameInfo;
    }

    public Type getType() {
        return this.type;
    }

    public WindowFunction createWindowFunction() {
        return new MappedWindowFunction(this.functionSupplier.createWindowFunction(this.ignoreNulls, this.lambdaProviders), this.argumentChannels);
    }
}

