/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import io.airlift.stats.TDigest;
import io.trino.operator.aggregation.ApproximateDoublePercentileAggregations;
import io.trino.operator.aggregation.state.TDigestAndPercentileState;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.BigintType;
import io.trino.util.Failures;

@AggregationFunction(value="approx_percentile")
public final class ApproximateLongPercentileAggregations {
    private ApproximateLongPercentileAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState TDigestAndPercentileState state, @SqlType(value="bigint") long value, @SqlType(value="double") double percentile) {
        ApproximateDoublePercentileAggregations.input(state, ApproximateLongPercentileAggregations.toDoubleExact(value), percentile);
    }

    @InputFunction
    public static void weightedInput(@AggregationState TDigestAndPercentileState state, @SqlType(value="bigint") long value, @SqlType(value="double") double weight, @SqlType(value="double") double percentile) {
        ApproximateDoublePercentileAggregations.weightedInput(state, ApproximateLongPercentileAggregations.toDoubleExact(value), weight, percentile);
    }

    @CombineFunction
    public static void combine(@AggregationState TDigestAndPercentileState state, TDigestAndPercentileState otherState) {
        ApproximateDoublePercentileAggregations.combine(state, otherState);
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState TDigestAndPercentileState state, BlockBuilder out) {
        TDigest digest = state.getDigest();
        double percentile = state.getPercentile();
        if (digest == null || digest.getCount() == 0.0) {
            out.appendNull();
        } else {
            Preconditions.checkState((percentile != -1.0 ? 1 : 0) != 0, (Object)"Percentile is missing");
            Failures.checkCondition(0.0 <= percentile && percentile <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile must be between 0 and 1", new Object[0]);
            BigintType.BIGINT.writeLong(out, Math.round(digest.valueAt(percentile)));
        }
    }

    public static double toDoubleExact(long value) {
        double doubleValue = value;
        Failures.checkCondition((long)doubleValue == value, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "no exact double representation for long: %s", value);
        return doubleValue;
    }
}

