/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.operator.GroupByIdBlock;
import io.trino.operator.MarkDistinctHash;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.operator.aggregation.Accumulator;
import io.trino.operator.aggregation.AccumulatorFactory;
import io.trino.operator.aggregation.GroupedAccumulator;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.JoinCompiler;
import io.trino.type.BlockTypeOperators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public class DistinctAccumulatorFactory
implements AccumulatorFactory {
    private final AccumulatorFactory delegate;
    private final List<Type> argumentTypes;
    private final JoinCompiler joinCompiler;
    private final BlockTypeOperators blockTypeOperators;
    private final Session session;

    public DistinctAccumulatorFactory(AccumulatorFactory delegate, List<Type> argumentTypes, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators, Session session) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    @Override
    public List<Class<?>> getLambdaInterfaces() {
        return this.delegate.getLambdaInterfaces();
    }

    @Override
    public Accumulator createAccumulator(List<Supplier<Object>> lambdaProviders) {
        return new DistinctAccumulator(this.delegate.createAccumulator(lambdaProviders), this.argumentTypes, this.session, this.joinCompiler, this.blockTypeOperators);
    }

    @Override
    public Accumulator createIntermediateAccumulator(List<Supplier<Object>> lambdaProviders) {
        return this.delegate.createIntermediateAccumulator(lambdaProviders);
    }

    @Override
    public GroupedAccumulator createGroupedAccumulator(List<Supplier<Object>> lambdaProviders) {
        return new DistinctGroupedAccumulator(this.delegate.createGroupedAccumulator(lambdaProviders), this.argumentTypes, this.session, this.joinCompiler, this.blockTypeOperators);
    }

    @Override
    public GroupedAccumulator createGroupedIntermediateAccumulator(List<Supplier<Object>> lambdaProviders) {
        return this.delegate.createGroupedIntermediateAccumulator(lambdaProviders);
    }

    private static Page filter(Page page, Block mask) {
        int positions = mask.getPositionCount();
        if (positions > 0 && mask instanceof RunLengthEncodedBlock) {
            if (!mask.isNull(0) && BooleanType.BOOLEAN.getBoolean(mask, 0)) {
                return page;
            }
            return page.getPositions(new int[0], 0, 0);
        }
        boolean mayHaveNull = mask.mayHaveNull();
        int[] ids = new int[positions];
        int next = 0;
        for (int i = 0; i < ids.length; ++i) {
            boolean isNull;
            boolean bl = isNull = mayHaveNull && mask.isNull(i);
            if (isNull || !BooleanType.BOOLEAN.getBoolean(mask, i)) continue;
            ids[next++] = i;
        }
        if (next == ids.length) {
            return page;
        }
        return page.getPositions(ids, 0, next);
    }

    private static class DistinctGroupedAccumulator
    implements GroupedAccumulator {
        private final GroupedAccumulator accumulator;
        private final MarkDistinctHash hash;

        private DistinctGroupedAccumulator(GroupedAccumulator accumulator, List<Type> inputTypes, Session session, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators) {
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
            this.hash = new MarkDistinctHash(session, (List<Type>)ImmutableList.builder().add((Object)BigintType.BIGINT).addAll(inputTypes).build(), IntStream.range(0, inputTypes.size() + 1).toArray(), Optional.empty(), joinCompiler, blockTypeOperators, UpdateMemory.NOOP);
        }

        @Override
        public long getEstimatedSize() {
            return this.hash.getEstimatedSize() + this.accumulator.getEstimatedSize();
        }

        @Override
        public void addInput(GroupByIdBlock groupIdsBlock, Page page, Optional<Block> mask) {
            Page withGroup = page.prependColumn((Block)groupIdsBlock);
            Page filteredWithGroup = mask.map(maskBlock -> DistinctAccumulatorFactory.filter(withGroup, maskBlock)).orElse(withGroup);
            Work<Block> work = this.hash.markDistinctRows(filteredWithGroup);
            Preconditions.checkState((boolean)work.process());
            Block distinctMask = work.getResult();
            GroupByIdBlock groupIds = new GroupByIdBlock(groupIdsBlock.getGroupCount(), filteredWithGroup.getBlock(0));
            int[] columnIndexes = new int[filteredWithGroup.getChannelCount() - 1];
            for (int i = 0; i < columnIndexes.length; ++i) {
                columnIndexes[i] = i + 1;
            }
            Page filtered = filteredWithGroup.getColumns(columnIndexes);
            this.accumulator.addInput(groupIds, filtered, Optional.of(distinctMask));
        }

        @Override
        public void addIntermediate(GroupByIdBlock groupIdsBlock, Block block) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            this.accumulator.evaluateFinal(groupId, output);
        }

        @Override
        public void prepareFinal() {
        }
    }

    private static class DistinctAccumulator
    implements Accumulator {
        private final Accumulator accumulator;
        private final MarkDistinctHash hash;

        private DistinctAccumulator(Accumulator accumulator, List<Type> inputTypes, Session session, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators) {
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
            this.hash = new MarkDistinctHash(session, inputTypes, IntStream.range(0, inputTypes.size()).toArray(), Optional.empty(), joinCompiler, blockTypeOperators, UpdateMemory.NOOP);
        }

        @Override
        public long getEstimatedSize() {
            return this.hash.getEstimatedSize() + this.accumulator.getEstimatedSize();
        }

        @Override
        public Accumulator copy() {
            throw new UnsupportedOperationException("Distinct aggregation function state can not be copied");
        }

        @Override
        public void addInput(Page arguments, Optional<Block> mask) {
            Page filtered = mask.map(maskBlock -> DistinctAccumulatorFactory.filter(arguments, maskBlock)).orElse(arguments);
            if (filtered.getPositionCount() == 0) {
                return;
            }
            Work<Block> work = this.hash.markDistinctRows(filtered);
            Preconditions.checkState((boolean)work.process());
            Block distinctMask = work.getResult();
            this.accumulator.addInput(filtered, Optional.of(distinctMask));
        }

        @Override
        public void addIntermediate(Block block) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateIntermediate(BlockBuilder blockBuilder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void evaluateFinal(BlockBuilder blockBuilder) {
            this.accumulator.evaluateFinal(blockBuilder);
        }
    }
}

