/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.arrayagg;

import com.google.common.base.Verify;
import io.trino.operator.aggregation.BlockBuilderCopier;
import io.trino.operator.aggregation.arrayagg.ArrayAggregationState;
import io.trino.operator.aggregation.arrayagg.ArrayAggregationStateConsumer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.type.Type;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class SingleArrayAggregationState
implements ArrayAggregationState {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleArrayAggregationState.class).instanceSize();
    private BlockBuilder blockBuilder;
    private final Type type;

    public SingleArrayAggregationState(Type type) {
        this.type = Objects.requireNonNull(type, "type is null");
    }

    private SingleArrayAggregationState(BlockBuilder blockBuilder, Type type) {
        this.blockBuilder = blockBuilder;
        this.type = type;
    }

    public long getEstimatedSize() {
        long estimatedSize = INSTANCE_SIZE;
        if (this.blockBuilder != null) {
            estimatedSize += this.blockBuilder.getRetainedSizeInBytes();
        }
        return estimatedSize;
    }

    @Override
    public void add(Block block, int position) {
        if (this.blockBuilder == null) {
            this.blockBuilder = this.type.createBlockBuilder(null, 16);
        }
        this.type.appendTo(block, position, this.blockBuilder);
    }

    @Override
    public void forEach(ArrayAggregationStateConsumer consumer) {
        if (this.blockBuilder == null) {
            return;
        }
        for (int i = 0; i < this.blockBuilder.getPositionCount(); ++i) {
            consumer.accept((Block)this.blockBuilder, i);
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.blockBuilder == null) {
            return true;
        }
        Verify.verify((this.blockBuilder.getPositionCount() != 0 ? 1 : 0) != 0);
        return false;
    }

    @Override
    public void reset() {
        this.blockBuilder = null;
    }

    public AccumulatorState copy() {
        return new SingleArrayAggregationState(BlockBuilderCopier.copyBlockBuilder(this.type, this.blockBuilder), this.type);
    }
}

