/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.OperatorInfo;
import io.trino.operator.OutputFactory;
import io.trino.operator.PartitionFunction;
import io.trino.operator.output.PagePartitioner;
import io.trino.operator.output.PositionsAppenderFactory;
import io.trino.spi.Mergeable;
import io.trino.spi.Page;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;

public class PartitionedOutputOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final Function<Page, Page> pagePreprocessor;
    private final PagePartitioner partitionFunction;
    private final LocalMemoryContext memoryContext;
    private final long partitionsInitialRetainedSize;
    private ListenableFuture<Void> isBlocked = NOT_BLOCKED;
    private boolean finished;

    public PartitionedOutputOperator(OperatorContext operatorContext, List<Type> sourceTypes, Function<Page, Page> pagePreprocessor, PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<NullableValue>> partitionConstants, boolean replicatesAnyRow, OptionalInt nullChannel, OutputBuffer outputBuffer, PagesSerdeFactory serdeFactory, DataSize maxMemory, PositionsAppenderFactory positionsAppenderFactory) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        this.partitionFunction = new PagePartitioner(partitionFunction, partitionChannels, partitionConstants, replicatesAnyRow, nullChannel, outputBuffer, serdeFactory, sourceTypes, maxMemory, operatorContext, positionsAppenderFactory);
        operatorContext.setInfoSupplier(this.partitionFunction.getOperatorInfoSupplier());
        this.memoryContext = operatorContext.newLocalUserMemoryContext(PartitionedOutputOperator.class.getSimpleName());
        this.partitionsInitialRetainedSize = this.partitionFunction.getRetainedSizeInBytes();
        this.memoryContext.setBytes(this.partitionsInitialRetainedSize);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finished = true;
        this.partitionFunction.flush(true);
    }

    @Override
    public boolean isFinished() {
        return this.finished && this.isBlocked().isDone();
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        if (this.isBlocked.isDone()) {
            this.isBlocked = this.partitionFunction.isFull();
            if (this.isBlocked.isDone()) {
                this.isBlocked = NOT_BLOCKED;
            }
        }
        return this.isBlocked;
    }

    @Override
    public boolean needsInput() {
        return !this.finished && this.isBlocked().isDone();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        if (page.getPositionCount() == 0) {
            return;
        }
        page = this.pagePreprocessor.apply(page);
        this.partitionFunction.partitionPage(page);
        long partitionsSizeInBytes = this.partitionFunction.getSizeInBytes();
        this.memoryContext.setBytes(partitionsSizeInBytes + this.partitionsInitialRetainedSize);
    }

    @Override
    public Page getOutput() {
        return null;
    }

    @Override
    public void close() {
        this.memoryContext.close();
    }

    public static class PartitionedOutputInfo
    implements Mergeable<PartitionedOutputInfo>,
    OperatorInfo {
        private final long rowsAdded;
        private final long pagesAdded;
        private final long outputBufferPeakMemoryUsage;

        @JsonCreator
        public PartitionedOutputInfo(@JsonProperty(value="rowsAdded") long rowsAdded, @JsonProperty(value="pagesAdded") long pagesAdded, @JsonProperty(value="outputBufferPeakMemoryUsage") long outputBufferPeakMemoryUsage) {
            this.rowsAdded = rowsAdded;
            this.pagesAdded = pagesAdded;
            this.outputBufferPeakMemoryUsage = outputBufferPeakMemoryUsage;
        }

        @JsonProperty
        public long getRowsAdded() {
            return this.rowsAdded;
        }

        @JsonProperty
        public long getPagesAdded() {
            return this.pagesAdded;
        }

        @JsonProperty
        public long getOutputBufferPeakMemoryUsage() {
            return this.outputBufferPeakMemoryUsage;
        }

        public PartitionedOutputInfo mergeWith(PartitionedOutputInfo other) {
            return new PartitionedOutputInfo(this.rowsAdded + other.rowsAdded, this.pagesAdded + other.pagesAdded, Math.max(this.outputBufferPeakMemoryUsage, other.outputBufferPeakMemoryUsage));
        }

        @Override
        public boolean isFinal() {
            return true;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("rowsAdded", this.rowsAdded).add("pagesAdded", this.pagesAdded).add("outputBufferPeakMemoryUsage", this.outputBufferPeakMemoryUsage).toString();
        }
    }

    public static class PartitionedOutputOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> sourceTypes;
        private final Function<Page, Page> pagePreprocessor;
        private final PartitionFunction partitionFunction;
        private final List<Integer> partitionChannels;
        private final List<Optional<NullableValue>> partitionConstants;
        private final boolean replicatesAnyRow;
        private final OptionalInt nullChannel;
        private final OutputBuffer outputBuffer;
        private final PagesSerdeFactory serdeFactory;
        private final DataSize maxMemory;
        private final PositionsAppenderFactory positionsAppenderFactory;

        public PartitionedOutputOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Type> sourceTypes, Function<Page, Page> pagePreprocessor, PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<NullableValue>> partitionConstants, boolean replicatesAnyRow, OptionalInt nullChannel, OutputBuffer outputBuffer, PagesSerdeFactory serdeFactory, DataSize maxMemory, PositionsAppenderFactory positionsAppenderFactory) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes is null");
            this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
            this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
            this.partitionChannels = Objects.requireNonNull(partitionChannels, "partitionChannels is null");
            this.partitionConstants = Objects.requireNonNull(partitionConstants, "partitionConstants is null");
            this.replicatesAnyRow = replicatesAnyRow;
            this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null");
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.serdeFactory = Objects.requireNonNull(serdeFactory, "serdeFactory is null");
            this.maxMemory = Objects.requireNonNull(maxMemory, "maxMemory is null");
            this.positionsAppenderFactory = Objects.requireNonNull(positionsAppenderFactory, "positionsAppenderFactory is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, PartitionedOutputOperator.class.getSimpleName());
            return new PartitionedOutputOperator(operatorContext, this.sourceTypes, this.pagePreprocessor, this.partitionFunction, this.partitionChannels, this.partitionConstants, this.replicatesAnyRow, this.nullChannel, this.outputBuffer, this.serdeFactory, this.maxMemory, this.positionsAppenderFactory);
        }

        @Override
        public void noMoreOperators() {
        }

        @Override
        public OperatorFactory duplicate() {
            return new PartitionedOutputOperatorFactory(this.operatorId, this.planNodeId, this.sourceTypes, this.pagePreprocessor, this.partitionFunction, this.partitionChannels, this.partitionConstants, this.replicatesAnyRow, this.nullChannel, this.outputBuffer, this.serdeFactory, this.maxMemory, this.positionsAppenderFactory);
        }
    }

    public static class PartitionedOutputFactory
    implements OutputFactory {
        private final PartitionFunction partitionFunction;
        private final List<Integer> partitionChannels;
        private final List<Optional<NullableValue>> partitionConstants;
        private final OutputBuffer outputBuffer;
        private final boolean replicatesAnyRow;
        private final OptionalInt nullChannel;
        private final DataSize maxMemory;
        private final PositionsAppenderFactory positionsAppenderFactory;

        public PartitionedOutputFactory(PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<NullableValue>> partitionConstants, boolean replicatesAnyRow, OptionalInt nullChannel, OutputBuffer outputBuffer, DataSize maxMemory, PositionsAppenderFactory positionsAppenderFactory) {
            this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
            this.partitionChannels = Objects.requireNonNull(partitionChannels, "partitionChannels is null");
            this.partitionConstants = Objects.requireNonNull(partitionConstants, "partitionConstants is null");
            this.replicatesAnyRow = replicatesAnyRow;
            this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null");
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.maxMemory = Objects.requireNonNull(maxMemory, "maxMemory is null");
            this.positionsAppenderFactory = Objects.requireNonNull(positionsAppenderFactory, "positionsAppenderFactory is null");
        }

        @Override
        public OperatorFactory createOutputOperator(int operatorId, PlanNodeId planNodeId, List<Type> types, Function<Page, Page> pagePreprocessor, PagesSerdeFactory serdeFactory) {
            return new PartitionedOutputOperatorFactory(operatorId, planNodeId, types, pagePreprocessor, this.partitionFunction, this.partitionChannels, this.partitionConstants, this.replicatesAnyRow, this.nullChannel, this.outputBuffer, serdeFactory, this.maxMemory, this.positionsAppenderFactory);
        }
    }
}

