/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionNullability;
import io.trino.operator.aggregation.AccumulatorCompiler;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.WindowAccumulator;
import io.trino.operator.window.AggregateWindowFunction;
import io.trino.operator.window.WindowFunctionSupplier;
import io.trino.spi.function.WindowFunction;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class AggregationWindowFunctionSupplier
implements WindowFunctionSupplier {
    private final Constructor<? extends WindowAccumulator> constructor;
    private final boolean hasRemoveInput;
    private final List<Class<?>> lambdaInterfaces;

    public AggregationWindowFunctionSupplier(BoundSignature boundSignature, AggregationMetadata aggregationMetadata, FunctionNullability functionNullability) {
        Objects.requireNonNull(boundSignature, "boundSignature is null");
        Objects.requireNonNull(aggregationMetadata, "aggregationMetadata is null");
        this.constructor = AccumulatorCompiler.generateWindowAccumulatorClass(boundSignature, aggregationMetadata, functionNullability);
        this.hasRemoveInput = aggregationMetadata.getRemoveInputFunction().isPresent();
        this.lambdaInterfaces = aggregationMetadata.getLambdaInterfaces();
    }

    @Override
    public List<Class<?>> getLambdaInterfaces() {
        return this.lambdaInterfaces;
    }

    @Override
    public WindowFunction createWindowFunction(boolean ignoreNulls, List<Supplier<Object>> lambdaProviders) {
        return new AggregateWindowFunction(() -> this.createWindowAccumulator(lambdaProviders), this.hasRemoveInput);
    }

    public WindowAccumulator createWindowAccumulator(List<Supplier<Object>> lambdaProviders) {
        try {
            return this.constructor.newInstance(lambdaProviders);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

