/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.execution.DynamicFilterConfig;
import io.trino.execution.SqlQueryExecution;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.operator.join.JoinUtils;
import io.trino.spi.QueryId;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.DynamicFilters;
import io.trino.sql.planner.DomainCoercer;
import io.trino.sql.planner.ExpressionExtractor;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.util.MorePredicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class DynamicFilterService {
    private final Metadata metadata;
    private final FunctionManager functionManager;
    private final TypeOperators typeOperators;
    private final ExecutorService executor;
    private final Map<QueryId, DynamicFilterContext> dynamicFilterContexts = new ConcurrentHashMap<QueryId, DynamicFilterContext>();

    @Inject
    public DynamicFilterService(Metadata metadata, FunctionManager functionManager, TypeOperators typeOperators, DynamicFilterConfig dynamicFilterConfig) {
        this(metadata, functionManager, typeOperators, Executors.newFixedThreadPool(dynamicFilterConfig.getServiceThreadCount(), Threads.daemonThreadsNamed((String)"DynamicFilterService")));
    }

    @VisibleForTesting
    public DynamicFilterService(Metadata metadata, FunctionManager functionManager, TypeOperators typeOperators, ExecutorService executor) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
    }

    @PreDestroy
    public void stop() {
        this.executor.shutdownNow();
    }

    public void registerQuery(SqlQueryExecution sqlQueryExecution, SubPlan fragmentedPlan) {
        PlanNode queryPlan = sqlQueryExecution.getQueryPlan().getRoot();
        Set<DynamicFilterId> dynamicFilters = DynamicFilterService.getProducedDynamicFilters(queryPlan);
        Set<DynamicFilterId> replicatedDynamicFilters = DynamicFilterService.getReplicatedDynamicFilters(queryPlan);
        Set lazyDynamicFilters = (Set)fragmentedPlan.getAllFragments().stream().flatMap(plan -> DynamicFilterService.getLazyDynamicFilters(plan).stream()).collect(ImmutableSet.toImmutableSet());
        if (!dynamicFilters.isEmpty()) {
            this.registerQuery(sqlQueryExecution.getQueryId(), sqlQueryExecution.getSession(), dynamicFilters, lazyDynamicFilters, replicatedDynamicFilters);
        }
    }

    @VisibleForTesting
    public void registerQuery(QueryId queryId, Session session, Set<DynamicFilterId> dynamicFilters, Set<DynamicFilterId> lazyDynamicFilters, Set<DynamicFilterId> replicatedDynamicFilters) {
        this.dynamicFilterContexts.putIfAbsent(queryId, new DynamicFilterContext(session, dynamicFilters, lazyDynamicFilters, replicatedDynamicFilters, 0));
    }

    public void registerQueryRetry(QueryId queryId, int attemptId) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null) {
            return;
        }
        Preconditions.checkState((attemptId == context.getAttemptId() + 1 ? 1 : 0) != 0, (String)"Query %s retry attempt %s was already registered", (Object)queryId, (int)attemptId);
        this.dynamicFilterContexts.put(queryId, context.createContextForQueryRetry(attemptId));
    }

    public DynamicFiltersStats getDynamicFilteringStats(QueryId queryId, Session session) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null) {
            return DynamicFiltersStats.EMPTY;
        }
        int lazyFilters = context.getLazyDynamicFilters().size();
        int replicatedFilters = context.getReplicatedDynamicFilters().size();
        int totalDynamicFilters = context.getTotalDynamicFilters();
        ConnectorSession connectorSession = session.toConnectorSession();
        List dynamicFilterDomainStats = (List)context.getDynamicFilterSummaries().entrySet().stream().map(entry -> {
            DynamicFilterId dynamicFilterId = (DynamicFilterId)entry.getKey();
            return new DynamicFilterDomainStats(dynamicFilterId, ((Domain)entry.getValue()).toString(connectorSession, 2), context.getDynamicFilterCollectionDuration(dynamicFilterId));
        }).collect(ImmutableList.toImmutableList());
        return new DynamicFiltersStats(dynamicFilterDomainStats, lazyFilters, replicatedFilters, totalDynamicFilters, dynamicFilterDomainStats.size());
    }

    public void removeQuery(QueryId queryId) {
        this.dynamicFilterContexts.remove(queryId);
    }

    public boolean isCollectingTaskNeeded(QueryId queryId, PlanFragment plan) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null) {
            return false;
        }
        return plan.getPartitioning().equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION) && !DynamicFilterService.getLazyDynamicFilters(plan).isEmpty();
    }

    public boolean isStageSchedulingNeededToCollectDynamicFilters(QueryId queryId, PlanFragment plan) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null) {
            return false;
        }
        return !plan.getPartitioning().equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION) && !DynamicFilterService.getLazyDynamicFilters(plan).isEmpty();
    }

    public void unblockStageDynamicFilters(QueryId queryId, int attemptId, PlanFragment plan) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null || attemptId < context.getAttemptId()) {
            return;
        }
        Preconditions.checkState((attemptId == context.getAttemptId() ? 1 : 0) != 0, (String)"Query %s retry attempt %s has not been registered with dynamic filter service", (Object)queryId, (int)attemptId);
        DynamicFilterService.getSourceStageInnerLazyDynamicFilters(plan).forEach(filter -> Objects.requireNonNull(context.getLazyDynamicFilters().get(filter), "Future not found").set(null));
    }

    public DynamicFilter createDynamicFilter(QueryId queryId, List<DynamicFilters.Descriptor> dynamicFilterDescriptors, Map<Symbol, ColumnHandle> columnHandles, TypeProvider typeProvider) {
        Multimap<DynamicFilterId, DynamicFilters.Descriptor> symbolsMap = DynamicFilters.extractSourceSymbols(dynamicFilterDescriptors);
        ImmutableSet dynamicFilters = ImmutableSet.copyOf((Collection)symbolsMap.keySet());
        DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null) {
            return DynamicFilter.EMPTY;
        }
        final List lazyDynamicFilterFutures = (List)dynamicFilters.stream().map(context.getLazyDynamicFilters()::get).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        AtomicReference<CurrentDynamicFilter> currentDynamicFilter = new AtomicReference<CurrentDynamicFilter>(new CurrentDynamicFilter(0, (TupleDomain<ColumnHandle>)TupleDomain.all()));
        final Set columnsCovered = (Set)symbolsMap.values().stream().map(DynamicFilters.Descriptor::getInput).map(Symbol::from).map(probeSymbol -> Objects.requireNonNull((ColumnHandle)columnHandles.get(probeSymbol), () -> "Missing probe column for " + probeSymbol)).collect(ImmutableSet.toImmutableSet());
        return new DynamicFilter((Set)dynamicFilters, context, currentDynamicFilter, symbolsMap, columnHandles, typeProvider){
            final /* synthetic */ Set val$dynamicFilters;
            final /* synthetic */ DynamicFilterContext val$context;
            final /* synthetic */ AtomicReference val$currentDynamicFilter;
            final /* synthetic */ Multimap val$symbolsMap;
            final /* synthetic */ Map val$columnHandles;
            final /* synthetic */ TypeProvider val$typeProvider;
            {
                this.val$dynamicFilters = set2;
                this.val$context = dynamicFilterContext;
                this.val$currentDynamicFilter = atomicReference;
                this.val$symbolsMap = multimap;
                this.val$columnHandles = map;
                this.val$typeProvider = typeProvider;
            }

            public Set<ColumnHandle> getColumnsCovered() {
                return columnsCovered;
            }

            public CompletableFuture<?> isBlocked() {
                List undoneFutures = (List)lazyDynamicFilterFutures.stream().filter(future -> !future.isDone()).collect(ImmutableList.toImmutableList());
                if (undoneFutures.isEmpty()) {
                    return NOT_BLOCKED;
                }
                return MoreFutures.unmodifiableFuture((CompletableFuture)MoreFutures.toCompletableFuture((ListenableFuture)MoreFutures.whenAnyComplete((Iterable)undoneFutures)));
            }

            public boolean isComplete() {
                return this.val$dynamicFilters.stream().allMatch(this.val$context.getDynamicFilterSummaries()::containsKey);
            }

            public boolean isAwaitable() {
                return lazyDynamicFilterFutures.stream().anyMatch(future -> !future.isDone());
            }

            public TupleDomain<ColumnHandle> getCurrentPredicate() {
                Set completedDynamicFilters = (Set)this.val$dynamicFilters.stream().filter(filter -> this.val$context.getDynamicFilterSummaries().containsKey(filter)).collect(ImmutableSet.toImmutableSet());
                CurrentDynamicFilter currentFilter = (CurrentDynamicFilter)this.val$currentDynamicFilter.get();
                if (currentFilter.getCompletedDynamicFiltersCount() >= completedDynamicFilters.size()) {
                    return currentFilter.getDynamicFilter();
                }
                TupleDomain dynamicFilter = TupleDomain.intersect((List)((List)completedDynamicFilters.stream().map(filter -> DynamicFilterService.this.translateSummaryToTupleDomain((DynamicFilterId)filter, this.val$context, (Multimap<DynamicFilterId, DynamicFilters.Descriptor>)this.val$symbolsMap, this.val$columnHandles, this.val$typeProvider)).collect(ImmutableList.toImmutableList())));
                this.val$currentDynamicFilter.set(new CurrentDynamicFilter(completedDynamicFilters.size(), (TupleDomain<ColumnHandle>)dynamicFilter));
                return dynamicFilter;
            }
        };
    }

    public void registerDynamicFilterConsumer(QueryId queryId, int attemptId, Set<DynamicFilterId> dynamicFilterIds, Consumer<Map<DynamicFilterId, Domain>> consumer) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null || attemptId < context.getAttemptId()) {
            return;
        }
        Preconditions.checkState((attemptId == context.getAttemptId() ? 1 : 0) != 0, (String)"Query %s retry attempt %s has not been registered with dynamic filter service", (Object)queryId, (int)attemptId);
        context.addDynamicFilterConsumer(dynamicFilterIds, consumer);
    }

    public void addTaskDynamicFilters(TaskId taskId, Map<DynamicFilterId, Domain> newDynamicFilters) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(taskId.getQueryId());
        int taskAttemptId = taskId.getAttemptId();
        if (context == null || taskAttemptId < context.getAttemptId()) {
            return;
        }
        Preconditions.checkState((taskAttemptId == context.getAttemptId() ? 1 : 0) != 0, (String)"Task %s retry attempt %s has not been registered with dynamic filter service", (Object)taskId, (int)taskAttemptId);
        context.addTaskDynamicFilters(taskId, newDynamicFilters);
        this.executor.submit(() -> this.collectDynamicFilters(taskId.getStageId(), Optional.of(newDynamicFilters.keySet())));
    }

    public void stageCannotScheduleMoreTasks(StageId stageId, int attemptId, int numberOfTasks) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(stageId.getQueryId());
        if (context == null || attemptId < context.getAttemptId()) {
            return;
        }
        Preconditions.checkState((attemptId == context.getAttemptId() ? 1 : 0) != 0, (String)"Stage %s retry attempt %s has not been registered with dynamic filter service", (Object)stageId, (int)attemptId);
        context.stageCannotScheduleMoreTasks(stageId, numberOfTasks);
        this.executor.submit(() -> this.collectDynamicFilters(stageId, Optional.empty()));
    }

    public static Set<DynamicFilterId> getOutboundDynamicFilters(PlanFragment plan) {
        return ImmutableSet.copyOf((Collection)Sets.difference(DynamicFilterService.getConsumedDynamicFilters(plan.getRoot()), DynamicFilterService.getProducedDynamicFilters(plan.getRoot())));
    }

    private void collectDynamicFilters(StageId stageId, Optional<Set<DynamicFilterId>> selectedFilters) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(stageId.getQueryId());
        if (context == null) {
            return;
        }
        OptionalInt stageNumberOfTasks = context.getNumberOfTasks(stageId);
        Map newDynamicFilters = (Map)context.getTaskDynamicFilters(stageId, selectedFilters).entrySet().stream().filter(stageDomains -> {
            if (((List)stageDomains.getValue()).stream().anyMatch(Domain::isAll)) {
                return true;
            }
            if (!((List)stageDomains.getValue()).isEmpty() && context.getReplicatedDynamicFilters().contains(stageDomains.getKey())) {
                Preconditions.checkState((((List)stageDomains.getValue()).size() == 1 ? 1 : 0) != 0, (Object)"Replicated dynamic filter should be collected from single task");
                return true;
            }
            return stageNumberOfTasks.isPresent() && ((List)stageDomains.getValue()).size() == stageNumberOfTasks.getAsInt();
        }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        context.addDynamicFilters(newDynamicFilters);
    }

    @VisibleForTesting
    Optional<Domain> getSummary(QueryId queryId, DynamicFilterId filterId) {
        return Optional.ofNullable(this.dynamicFilterContexts.get(queryId).getDynamicFilterSummaries().get(filterId));
    }

    private TupleDomain<ColumnHandle> translateSummaryToTupleDomain(DynamicFilterId filterId, DynamicFilterContext dynamicFilterContext, Multimap<DynamicFilterId, DynamicFilters.Descriptor> descriptorMultimap, Map<Symbol, ColumnHandle> columnHandles, TypeProvider typeProvider) {
        Collection descriptors = descriptorMultimap.get((Object)filterId);
        Preconditions.checkState((descriptors != null ? 1 : 0) != 0, (String)"No descriptors for dynamic filter %s", (Object)filterId);
        Domain summary = dynamicFilterContext.getDynamicFilterSummaries().get(filterId);
        return TupleDomain.withColumnDomains((Map)((Map)descriptors.stream().collect(ImmutableMap.toImmutableMap(descriptor -> {
            Symbol probeSymbol = Symbol.from(descriptor.getInput());
            return Objects.requireNonNull((ColumnHandle)columnHandles.get(probeSymbol), () -> String.format("Missing probe column for %s", probeSymbol));
        }, descriptor -> {
            Type targetType = typeProvider.get(Symbol.from(descriptor.getInput()));
            Domain updatedSummary = descriptor.applyComparison(summary);
            if (!updatedSummary.getType().equals(targetType)) {
                return DomainCoercer.applySaturatedCasts(this.metadata, this.functionManager, this.typeOperators, dynamicFilterContext.getSession(), updatedSummary, targetType);
            }
            return updatedSummary;
        }))));
    }

    private static Set<DynamicFilterId> getLazyDynamicFilters(PlanFragment plan) {
        Sets.SetView interStageDynamicFilters = Sets.difference(DynamicFilterService.getProducedDynamicFilters(plan.getRoot()), DynamicFilterService.getConsumedDynamicFilters(plan.getRoot()));
        return ImmutableSet.copyOf((Collection)Sets.union((Set)interStageDynamicFilters, DynamicFilterService.getSourceStageInnerLazyDynamicFilters(plan)));
    }

    @VisibleForTesting
    static Set<DynamicFilterId> getSourceStageInnerLazyDynamicFilters(PlanFragment plan) {
        if (!plan.getPartitioning().equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION)) {
            return ImmutableSet.of();
        }
        PlanNode planNode = plan.getRoot();
        Sets.SetView innerStageDynamicFilters = Sets.intersection(DynamicFilterService.getProducedDynamicFilters(planNode), DynamicFilterService.getConsumedDynamicFilters(planNode));
        Set<DynamicFilterId> replicatedDynamicFilters = DynamicFilterService.getReplicatedDynamicFilters(planNode);
        return ImmutableSet.copyOf((Collection)Sets.intersection((Set)innerStageDynamicFilters, replicatedDynamicFilters));
    }

    private static Set<DynamicFilterId> getReplicatedDynamicFilters(PlanNode planNode) {
        return (Set)PlanNodeSearcher.searchFrom(planNode).where(MorePredicates.isInstanceOfAny(JoinNode.class, SemiJoinNode.class)).findAll().stream().filter(JoinUtils::isBuildSideReplicated).flatMap(node -> DynamicFilterService.getDynamicFiltersProducedInPlanNode(node).stream()).collect(ImmutableSet.toImmutableSet());
    }

    private static Set<DynamicFilterId> getProducedDynamicFilters(PlanNode planNode) {
        return (Set)PlanNodeSearcher.searchFrom(planNode).where(MorePredicates.isInstanceOfAny(JoinNode.class, SemiJoinNode.class)).findAll().stream().flatMap(node -> DynamicFilterService.getDynamicFiltersProducedInPlanNode(node).stream()).collect(ImmutableSet.toImmutableSet());
    }

    private static Set<DynamicFilterId> getDynamicFiltersProducedInPlanNode(PlanNode planNode) {
        if (planNode instanceof JoinNode) {
            return ((JoinNode)planNode).getDynamicFilters().keySet();
        }
        if (planNode instanceof SemiJoinNode) {
            return (Set)((SemiJoinNode)planNode).getDynamicFilterId().map(ImmutableSet::of).orElse(ImmutableSet.of());
        }
        throw new IllegalStateException("getDynamicFiltersProducedInPlanNode called with neither JoinNode nor SemiJoinNode");
    }

    private static Set<DynamicFilterId> getConsumedDynamicFilters(PlanNode planNode) {
        return (Set)ExpressionExtractor.extractExpressions(planNode).stream().flatMap(expression -> DynamicFilters.extractDynamicFilters(expression).getDynamicConjuncts().stream()).map(DynamicFilters.Descriptor::getId).collect(ImmutableSet.toImmutableSet());
    }

    private static class CurrentDynamicFilter {
        private final int completedDynamicFiltersCount;
        private final TupleDomain<ColumnHandle> dynamicFilter;

        private CurrentDynamicFilter(int completedDynamicFiltersCount, TupleDomain<ColumnHandle> dynamicFilter) {
            this.completedDynamicFiltersCount = completedDynamicFiltersCount;
            this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
        }

        private int getCompletedDynamicFiltersCount() {
            return this.completedDynamicFiltersCount;
        }

        private TupleDomain<ColumnHandle> getDynamicFilter() {
            return this.dynamicFilter;
        }
    }

    private static class DynamicFilterContext {
        private final Session session;
        private final Map<DynamicFilterId, Domain> dynamicFilterSummaries = new ConcurrentHashMap<DynamicFilterId, Domain>();
        private final Map<DynamicFilterId, Long> dynamicFilterCollectionTime = new ConcurrentHashMap<DynamicFilterId, Long>();
        private final Set<DynamicFilterId> dynamicFilters;
        private final Map<DynamicFilterId, SettableFuture<Void>> lazyDynamicFilters;
        private final Set<DynamicFilterId> replicatedDynamicFilters;
        private final Map<StageId, Set<DynamicFilterId>> stageDynamicFilters = new ConcurrentHashMap<StageId, Set<DynamicFilterId>>();
        private final Map<StageId, Integer> stageNumberOfTasks = new ConcurrentHashMap<StageId, Integer>();
        private final Map<DynamicFilterId, Map<TaskId, Domain>> taskDynamicFilters = new ConcurrentHashMap<DynamicFilterId, Map<TaskId, Domain>>();
        @GuardedBy(value="dynamicFilterConsumers")
        private final Map<DynamicFilterId, List<Consumer<Map<DynamicFilterId, Domain>>>> dynamicFilterConsumers = new HashMap<DynamicFilterId, List<Consumer<Map<DynamicFilterId, Domain>>>>();
        private final int attemptId;
        private final long queryAttemptStartTime = System.nanoTime();

        private DynamicFilterContext(Session session, Set<DynamicFilterId> dynamicFilters, Set<DynamicFilterId> lazyDynamicFilters, Set<DynamicFilterId> replicatedDynamicFilters, int attemptId) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.dynamicFilters = Objects.requireNonNull(dynamicFilters, "dynamicFilters is null");
            Objects.requireNonNull(lazyDynamicFilters, "lazyDynamicFilters is null");
            this.lazyDynamicFilters = (Map)lazyDynamicFilters.stream().collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), filter -> SettableFuture.create()));
            this.replicatedDynamicFilters = Objects.requireNonNull(replicatedDynamicFilters, "replicatedDynamicFilters is null");
            dynamicFilters.forEach(filter -> {
                this.taskDynamicFilters.put((DynamicFilterId)filter, new ConcurrentHashMap());
                this.dynamicFilterConsumers.put((DynamicFilterId)filter, new ArrayList());
            });
            this.attemptId = attemptId;
        }

        DynamicFilterContext createContextForQueryRetry(int attemptId) {
            return new DynamicFilterContext(this.session, this.dynamicFilters, this.lazyDynamicFilters.keySet(), this.replicatedDynamicFilters, attemptId);
        }

        void addDynamicFilterConsumer(Set<DynamicFilterId> dynamicFilterIds, Consumer<Map<DynamicFilterId, Domain>> consumer) {
            ImmutableMap.Builder collectedDomainsBuilder = ImmutableMap.builder();
            dynamicFilterIds.forEach(dynamicFilterId -> {
                Map<DynamicFilterId, List<Consumer<Map<DynamicFilterId, Domain>>>> map = this.dynamicFilterConsumers;
                synchronized (map) {
                    List<Consumer<Map<DynamicFilterId, Domain>>> consumers = this.dynamicFilterConsumers.get(dynamicFilterId);
                    if (consumers != null) {
                        consumers.add(consumer);
                        return;
                    }
                }
                collectedDomainsBuilder.put(dynamicFilterId, (Object)this.dynamicFilterSummaries.get(dynamicFilterId));
            });
            ImmutableMap collectedDomains = collectedDomainsBuilder.buildOrThrow();
            if (!collectedDomains.isEmpty()) {
                consumer.accept((Map<DynamicFilterId, Domain>)collectedDomains);
            }
        }

        public Session getSession() {
            return this.session;
        }

        private int getTotalDynamicFilters() {
            return this.dynamicFilters.size();
        }

        private OptionalInt getNumberOfTasks(StageId stageId) {
            return Optional.ofNullable(this.stageNumberOfTasks.get(stageId)).map(OptionalInt::of).orElse(OptionalInt.empty());
        }

        private Map<DynamicFilterId, List<Domain>> getTaskDynamicFilters(StageId stageId, Optional<Set<DynamicFilterId>> selectedFilters) {
            return (Map)selectedFilters.orElseGet(() -> this.stageDynamicFilters.get(stageId)).stream().collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), filter -> (List)Optional.ofNullable(this.taskDynamicFilters.get(filter)).map(taskDomains -> ImmutableList.copyOf(taskDomains.values())).orElse(ImmutableList.of())));
        }

        private void addDynamicFilters(Map<DynamicFilterId, List<Domain>> newDynamicFilters) {
            HashMultimap completedConsumers = HashMultimap.create();
            newDynamicFilters.forEach((arg_0, arg_1) -> this.lambda$addDynamicFilters$8((SetMultimap)completedConsumers, arg_0, arg_1));
            completedConsumers.asMap().forEach((consumer, dynamicFilterIds) -> consumer.accept((Map)dynamicFilterIds.stream().collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), filterId -> Objects.requireNonNull(this.dynamicFilterSummaries.get(filterId))))));
        }

        private void addTaskDynamicFilters(TaskId taskId, Map<DynamicFilterId, Domain> newDynamicFilters) {
            this.stageDynamicFilters.computeIfAbsent(taskId.getStageId(), ignored -> Sets.newConcurrentHashSet()).addAll(newDynamicFilters.keySet());
            newDynamicFilters.forEach((filter, domain) -> {
                Map<TaskId, Domain> taskDomains = this.taskDynamicFilters.get(filter);
                if (taskDomains == null) {
                    return;
                }
                Domain previousDomain = taskDomains.put(taskId, (Domain)domain);
                Preconditions.checkState((previousDomain == null || domain.equals((Object)previousDomain) ? 1 : 0) != 0, (Object)"Different task domains were set");
            });
        }

        private void stageCannotScheduleMoreTasks(StageId stageId, int numberOfTasks) {
            this.stageNumberOfTasks.put(stageId, numberOfTasks);
        }

        private Map<DynamicFilterId, Domain> getDynamicFilterSummaries() {
            return this.dynamicFilterSummaries;
        }

        private Map<DynamicFilterId, SettableFuture<Void>> getLazyDynamicFilters() {
            return this.lazyDynamicFilters;
        }

        private Set<DynamicFilterId> getReplicatedDynamicFilters() {
            return this.replicatedDynamicFilters;
        }

        private Optional<Duration> getDynamicFilterCollectionDuration(DynamicFilterId filterId) {
            Long filterCollectionTime = this.dynamicFilterCollectionTime.get(filterId);
            if (filterCollectionTime == null) {
                return Optional.empty();
            }
            return Optional.of(Duration.succinctNanos((long)(filterCollectionTime - this.queryAttemptStartTime)));
        }

        private int getAttemptId() {
            return this.attemptId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private /* synthetic */ void lambda$addDynamicFilters$8(SetMultimap completedConsumers, DynamicFilterId filter, List domain) {
            List<Consumer<Map<DynamicFilterId, Domain>>> consumers;
            if (this.taskDynamicFilters.remove(filter) == null) {
                return;
            }
            this.dynamicFilterCollectionTime.put(filter, System.nanoTime());
            this.dynamicFilterSummaries.put(filter, Domain.union((List)domain));
            Optional.ofNullable(this.lazyDynamicFilters.get(filter)).ifPresent(future -> future.set(null));
            Map<DynamicFilterId, List<Consumer<Map<DynamicFilterId, Domain>>>> map = this.dynamicFilterConsumers;
            synchronized (map) {
                consumers = Objects.requireNonNull(this.dynamicFilterConsumers.remove(filter));
            }
            consumers.forEach(consumer -> completedConsumers.put(consumer, (Object)filter));
        }
    }

    public static class DynamicFilterDomainStats {
        private final DynamicFilterId dynamicFilterId;
        private final String simplifiedDomain;
        private final Optional<Duration> collectionDuration;

        @VisibleForTesting
        DynamicFilterDomainStats(DynamicFilterId dynamicFilterId, String simplifiedDomain) {
            this(dynamicFilterId, simplifiedDomain, Optional.empty());
        }

        @JsonCreator
        public DynamicFilterDomainStats(@JsonProperty(value="dynamicFilterId") DynamicFilterId dynamicFilterId, @JsonProperty(value="simplifiedDomain") String simplifiedDomain, @JsonProperty(value="collectionDuration") Optional<Duration> collectionDuration) {
            this.dynamicFilterId = Objects.requireNonNull(dynamicFilterId, "dynamicFilterId is null");
            this.simplifiedDomain = Objects.requireNonNull(simplifiedDomain, "simplifiedDomain is null");
            this.collectionDuration = Objects.requireNonNull(collectionDuration, "collectionDuration is null");
        }

        @JsonProperty
        public DynamicFilterId getDynamicFilterId() {
            return this.dynamicFilterId;
        }

        @JsonProperty
        public String getSimplifiedDomain() {
            return this.simplifiedDomain;
        }

        @JsonProperty
        public Optional<Duration> getCollectionDuration() {
            return this.collectionDuration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicFilterDomainStats stats = (DynamicFilterDomainStats)o;
            return Objects.equals(this.dynamicFilterId, stats.dynamicFilterId) && Objects.equals(this.simplifiedDomain, stats.simplifiedDomain);
        }

        public int hashCode() {
            return Objects.hash(this.dynamicFilterId, this.simplifiedDomain);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("dynamicFilterId", (Object)this.dynamicFilterId).add("simplifiedDomain", (Object)this.simplifiedDomain).add("collectionDuration", this.collectionDuration).toString();
        }
    }

    public static class DynamicFiltersStats {
        public static final DynamicFiltersStats EMPTY = new DynamicFiltersStats((List<DynamicFilterDomainStats>)ImmutableList.of(), 0, 0, 0, 0);
        private final List<DynamicFilterDomainStats> dynamicFilterDomainStats;
        private final int lazyDynamicFilters;
        private final int replicatedDynamicFilters;
        private final int totalDynamicFilters;
        private final int dynamicFiltersCompleted;

        @JsonCreator
        public DynamicFiltersStats(@JsonProperty(value="dynamicFilterDomainStats") List<DynamicFilterDomainStats> dynamicFilterDomainStats, @JsonProperty(value="lazyDynamicFilters") int lazyDynamicFilters, @JsonProperty(value="replicatedDynamicFilters") int replicatedDynamicFilters, @JsonProperty(value="totalDynamicFilters") int totalDynamicFilters, @JsonProperty(value="dynamicFiltersCompleted") int dynamicFiltersCompleted) {
            this.dynamicFilterDomainStats = Objects.requireNonNull(dynamicFilterDomainStats, "dynamicFilterDomainStats is null");
            this.lazyDynamicFilters = lazyDynamicFilters;
            this.replicatedDynamicFilters = replicatedDynamicFilters;
            this.totalDynamicFilters = totalDynamicFilters;
            this.dynamicFiltersCompleted = dynamicFiltersCompleted;
        }

        @JsonProperty
        public List<DynamicFilterDomainStats> getDynamicFilterDomainStats() {
            return this.dynamicFilterDomainStats;
        }

        @JsonProperty
        public int getLazyDynamicFilters() {
            return this.lazyDynamicFilters;
        }

        @JsonProperty
        public int getReplicatedDynamicFilters() {
            return this.replicatedDynamicFilters;
        }

        @JsonProperty
        public int getTotalDynamicFilters() {
            return this.totalDynamicFilters;
        }

        @JsonProperty
        public int getDynamicFiltersCompleted() {
            return this.dynamicFiltersCompleted;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicFiltersStats that = (DynamicFiltersStats)o;
            return this.lazyDynamicFilters == that.lazyDynamicFilters && this.replicatedDynamicFilters == that.replicatedDynamicFilters && this.totalDynamicFilters == that.totalDynamicFilters && this.dynamicFiltersCompleted == that.dynamicFiltersCompleted && Objects.equals(this.dynamicFilterDomainStats, that.dynamicFilterDomainStats);
        }

        public int hashCode() {
            return Objects.hash(this.dynamicFilterDomainStats, this.lazyDynamicFilters, this.replicatedDynamicFilters, this.totalDynamicFilters, this.dynamicFiltersCompleted);
        }
    }
}

