/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.SigningKeyResolver;
import io.trino.server.security.AbstractBearerAuthenticator;
import io.trino.server.security.AuthenticationException;
import io.trino.server.security.UserMapping;
import io.trino.server.security.UserMappingException;
import io.trino.server.security.jwt.ForJwt;
import io.trino.server.security.jwt.JwtAuthenticatorConfig;
import io.trino.server.security.jwt.JwtUtil;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.Identity;
import java.security.Principal;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;

public class JwtAuthenticator
extends AbstractBearerAuthenticator {
    private final JwtParser jwtParser;
    private final String principalField;
    private final UserMapping userMapping;

    @Inject
    public JwtAuthenticator(JwtAuthenticatorConfig config, @ForJwt SigningKeyResolver signingKeyResolver) {
        this.principalField = config.getPrincipalField();
        JwtParserBuilder jwtParser = JwtUtil.newJwtParserBuilder().setSigningKeyResolver(signingKeyResolver);
        if (config.getRequiredIssuer() != null) {
            jwtParser.requireIssuer(config.getRequiredIssuer());
        }
        if (config.getRequiredAudience() != null) {
            jwtParser.requireAudience(config.getRequiredAudience());
        }
        this.jwtParser = jwtParser.build();
        this.userMapping = UserMapping.createUserMapping(config.getUserMappingPattern(), config.getUserMappingFile());
    }

    @Override
    protected Optional<Identity> createIdentity(String token) throws UserMappingException {
        Optional<String> principal = Optional.ofNullable((String)((Claims)this.jwtParser.parseClaimsJws(token).getBody()).get(this.principalField, String.class));
        if (principal.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Identity.forUser((String)this.userMapping.mapUser(principal.get())).withPrincipal((Principal)new BasicPrincipal(principal.get())).build());
    }

    @Override
    protected AuthenticationException needAuthentication(ContainerRequestContext request, String message) {
        return new AuthenticationException(message, "Bearer realm=\"Trino\", token_type=\"JWT\"");
    }
}

