/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.common.collect.ImmutableSet;
import io.trino.server.security.AbstractBearerAuthenticator;
import io.trino.server.security.AuthenticationException;
import io.trino.server.security.UserMapping;
import io.trino.server.security.UserMappingException;
import io.trino.server.security.oauth2.ChallengeFailedException;
import io.trino.server.security.oauth2.OAuth2Config;
import io.trino.server.security.oauth2.OAuth2Service;
import io.trino.server.security.oauth2.OAuth2TokenExchangeResource;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.Identity;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;

public class OAuth2Authenticator
extends AbstractBearerAuthenticator {
    private final OAuth2Service service;
    private final String principalField;
    private final Optional<String> groupsField;
    private final UserMapping userMapping;

    @Inject
    public OAuth2Authenticator(OAuth2Service service, OAuth2Config config) {
        this.service = Objects.requireNonNull(service, "service is null");
        this.principalField = config.getPrincipalField();
        this.groupsField = Objects.requireNonNull(config.getGroupsField(), "groupsField is null");
        this.userMapping = UserMapping.createUserMapping(config.getUserMappingPattern(), config.getUserMappingFile());
    }

    @Override
    protected Optional<Identity> createIdentity(String token) throws UserMappingException {
        try {
            Optional<Map<String, Object>> claims = this.service.convertTokenToClaims(token);
            if (claims.isEmpty()) {
                return Optional.empty();
            }
            String principal = (String)claims.get().get(this.principalField);
            Identity.Builder builder = Identity.forUser((String)this.userMapping.mapUser(principal));
            builder.withPrincipal((Principal)new BasicPrincipal(principal));
            this.groupsField.flatMap(field -> Optional.ofNullable((List)((Map)claims.get()).get(field))).ifPresent(groups -> builder.withGroups((Set)ImmutableSet.copyOf((Collection)groups)));
            return Optional.of(builder.build());
        }
        catch (ChallengeFailedException e) {
            return Optional.empty();
        }
    }

    @Override
    protected AuthenticationException needAuthentication(ContainerRequestContext request, String message) {
        UUID authId = UUID.randomUUID();
        URI initiateUri = request.getUriInfo().getBaseUri().resolve(OAuth2TokenExchangeResource.getInitiateUri(authId));
        URI tokenUri = request.getUriInfo().getBaseUri().resolve(OAuth2TokenExchangeResource.getTokenUri(authId));
        return new AuthenticationException(message, String.format("Bearer x_redirect_server=\"%s\", x_token_server=\"%s\"", initiateUri, tokenUri));
    }
}

