/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.spi.type.VarcharType;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.BinaryLiteral;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.CharLiteral;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.TimeLiteral;
import io.trino.sql.tree.TimestampLiteral;
import io.trino.type.DateTimes;
import io.trino.type.JsonType;
import io.trino.util.DateTimeUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class LiteralInterpreter {
    private LiteralInterpreter() {
    }

    public static Object evaluate(PlannerContext plannerContext, Session session, Map<NodeRef<Expression>, Type> types, Expression node) {
        if (!(node instanceof Literal)) {
            throw new IllegalArgumentException("node must be a Literal");
        }
        return new LiteralVisitor(session, plannerContext, types).process((Node)node, null);
    }

    private static class LiteralVisitor
    extends AstVisitor<Object, Void> {
        private final Session session;
        private final ConnectorSession connectorSession;
        private final PlannerContext plannerContext;
        private final InterpretedFunctionInvoker functionInvoker;
        private final Map<NodeRef<Expression>, Type> types;

        private LiteralVisitor(Session session, PlannerContext plannerContext, Map<NodeRef<Expression>, Type> types) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.connectorSession = session.toConnectorSession();
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.functionInvoker = new InterpretedFunctionInvoker(plannerContext.getFunctionManager());
            this.types = Objects.requireNonNull(types, "types is null");
        }

        protected Object visitLiteral(Literal node, Void context) {
            throw new UnsupportedOperationException("Unhandled literal type: " + node);
        }

        protected Object visitBooleanLiteral(BooleanLiteral node, Void context) {
            return node.getValue();
        }

        protected Long visitLongLiteral(LongLiteral node, Void context) {
            return node.getValue();
        }

        protected Double visitDoubleLiteral(DoubleLiteral node, Void context) {
            return node.getValue();
        }

        protected Object visitDecimalLiteral(DecimalLiteral node, Void context) {
            return Decimals.parse((String)node.getValue()).getObject();
        }

        protected Slice visitStringLiteral(StringLiteral node, Void context) {
            return node.getSlice();
        }

        protected Object visitCharLiteral(CharLiteral node, Void context) {
            return node.getSlice();
        }

        protected Slice visitBinaryLiteral(BinaryLiteral node, Void context) {
            return node.getValue();
        }

        protected Object visitGenericLiteral(GenericLiteral node, Void context) {
            Type type;
            try {
                type = this.plannerContext.getTypeManager().fromSqlType(node.getType());
            }
            catch (TypeNotFoundException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_NOT_FOUND, (Node)node, "Unknown type: %s", node.getType());
            }
            if (JsonType.JSON.equals(type)) {
                ResolvedFunction resolvedFunction = this.plannerContext.getMetadata().resolveFunction(this.session, QualifiedName.of((String)"json_parse"), TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR}));
                return this.functionInvoker.invoke(resolvedFunction, this.connectorSession, (List<Object>)ImmutableList.of((Object)Slices.utf8Slice((String)node.getValue())));
            }
            try {
                ResolvedFunction resolvedFunction = this.plannerContext.getMetadata().getCoercion(this.session, (Type)VarcharType.VARCHAR, type);
                return this.functionInvoker.invoke(resolvedFunction, this.connectorSession, (List<Object>)ImmutableList.of((Object)Slices.utf8Slice((String)node.getValue())));
            }
            catch (IllegalArgumentException e) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)node, "No literal form for type %s", type);
            }
        }

        protected Object visitTimeLiteral(TimeLiteral node, Void session) {
            Type type = this.types.get(NodeRef.of((Node)node));
            if (type instanceof TimeType) {
                return DateTimes.parseTime(node.getValue());
            }
            if (type instanceof TimeWithTimeZoneType) {
                return DateTimes.parseTimeWithTimeZone(((TimeWithTimeZoneType)type).getPrecision(), node.getValue());
            }
            throw new IllegalStateException("Unexpected type: " + type);
        }

        protected Object visitTimestampLiteral(TimestampLiteral node, Void session) {
            Type type = this.types.get(NodeRef.of((Node)node));
            if (type instanceof TimestampType) {
                int precision = ((TimestampType)type).getPrecision();
                return DateTimes.parseTimestamp(precision, node.getValue());
            }
            if (type instanceof TimestampWithTimeZoneType) {
                int precision = ((TimestampWithTimeZoneType)type).getPrecision();
                return DateTimes.parseTimestampWithTimeZone(precision, node.getValue());
            }
            throw new IllegalStateException("Unexpected type: " + type);
        }

        protected Long visitIntervalLiteral(IntervalLiteral node, Void context) {
            if (node.isYearToMonth()) {
                return (long)node.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(node.getValue(), node.getStartField(), node.getEndField());
            }
            return (long)node.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(node.getValue(), node.getStartField(), node.getEndField());
        }

        protected Object visitNullLiteral(NullLiteral node, Void context) {
            return null;
        }
    }
}

