/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class OptimizerConfig {
    private double cpuCostWeight = 75.0;
    private double memoryCostWeight = 10.0;
    private double networkCostWeight = 15.0;
    private DataSize joinMaxBroadcastTableSize = DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private JoinDistributionType joinDistributionType = JoinDistributionType.AUTOMATIC;
    private double joinMultiClauseIndependenceFactor = 0.25;
    private JoinReorderingStrategy joinReorderingStrategy = JoinReorderingStrategy.AUTOMATIC;
    private int maxReorderedJoins = 9;
    private boolean enableStatsCalculator = true;
    private boolean statisticsPrecalculationForPushdownEnabled;
    private boolean collectPlanStatisticsForAllQueries;
    private boolean ignoreStatsCalculatorFailures = true;
    private boolean defaultFilterFactorEnabled;
    private double filterConjunctionIndependenceFactor = 0.75;
    private boolean colocatedJoinsEnabled;
    private boolean distributedIndexJoinsEnabled;
    private boolean spatialJoinsEnabled = true;
    private boolean distributedSort = true;
    private boolean usePreferredWritePartitioning = true;
    private int preferredWritePartitioningMinNumberOfPartitions = 50;
    private Duration iterativeOptimizerTimeout = new Duration(3.0, TimeUnit.MINUTES);
    private boolean optimizeMetadataQueries;
    private boolean optimizeHashGeneration = true;
    private boolean pushTableWriteThroughUnion = true;
    private boolean dictionaryAggregation;
    private boolean useMarkDistinct = true;
    private boolean preferPartialAggregation = true;
    private boolean pushAggregationThroughOuterJoin = true;
    private boolean enableIntermediateAggregations;
    private boolean pushPartialAggregationThoughJoin;
    private boolean optimizeMixedDistinctAggregations;
    private boolean enableForcedExchangeBelowGroupId = true;
    private boolean optimizeTopNRanking = true;
    private boolean skipRedundantSort = true;
    private boolean complexExpressionPushdownEnabled = true;
    private boolean predicatePushdownUseTableProperties = true;
    private boolean ignoreDownstreamPreferences;
    private boolean rewriteFilteringSemiJoinToInnerJoin = true;
    private boolean optimizeDuplicateInsensitiveJoins = true;
    private boolean useLegacyWindowFilterPushdown;
    private boolean useTableScanNodePartitioning = true;
    private double tableScanNodePartitioningMinBucketToTaskRatio = 0.5;
    private boolean mergeProjectWithValues = true;
    private boolean forceSingleNodeOutput = true;
    private boolean adaptivePartialAggregationEnabled = true;
    private long adaptivePartialAggregationMinRows = 100000L;
    private double adaptivePartialAggregationUniqueRowsRatioThreshold = 0.8;

    public double getCpuCostWeight() {
        return this.cpuCostWeight;
    }

    @Config(value="cpu-cost-weight")
    public OptimizerConfig setCpuCostWeight(double cpuCostWeight) {
        this.cpuCostWeight = cpuCostWeight;
        return this;
    }

    public double getMemoryCostWeight() {
        return this.memoryCostWeight;
    }

    @Config(value="memory-cost-weight")
    public OptimizerConfig setMemoryCostWeight(double memoryCostWeight) {
        this.memoryCostWeight = memoryCostWeight;
        return this;
    }

    public double getNetworkCostWeight() {
        return this.networkCostWeight;
    }

    @Config(value="network-cost-weight")
    public OptimizerConfig setNetworkCostWeight(double networkCostWeight) {
        this.networkCostWeight = networkCostWeight;
        return this;
    }

    public JoinDistributionType getJoinDistributionType() {
        return this.joinDistributionType;
    }

    @Config(value="join-distribution-type")
    public OptimizerConfig setJoinDistributionType(JoinDistributionType joinDistributionType) {
        this.joinDistributionType = Objects.requireNonNull(joinDistributionType, "joinDistributionType is null");
        return this;
    }

    @NotNull
    public DataSize getJoinMaxBroadcastTableSize() {
        return this.joinMaxBroadcastTableSize;
    }

    @Config(value="join-max-broadcast-table-size")
    @ConfigDescription(value="Maximum estimated size of a table that can be broadcast when using automatic join type selection")
    public OptimizerConfig setJoinMaxBroadcastTableSize(DataSize joinMaxBroadcastTableSize) {
        this.joinMaxBroadcastTableSize = joinMaxBroadcastTableSize;
        return this;
    }

    @Min(value=0L)
    @Max(value=1L)
    public @Min(value=0L) @Max(value=1L) double getJoinMultiClauseIndependenceFactor() {
        return this.joinMultiClauseIndependenceFactor;
    }

    @Config(value="optimizer.join-multi-clause-independence-factor")
    @ConfigDescription(value="Scales the strength of independence assumption for selectivity estimates of multi-clause joins")
    public OptimizerConfig setJoinMultiClauseIndependenceFactor(double joinMultiClauseIndependenceFactor) {
        this.joinMultiClauseIndependenceFactor = joinMultiClauseIndependenceFactor;
        return this;
    }

    public JoinReorderingStrategy getJoinReorderingStrategy() {
        return this.joinReorderingStrategy;
    }

    @Config(value="optimizer.join-reordering-strategy")
    @ConfigDescription(value="The strategy to use for reordering joins")
    public OptimizerConfig setJoinReorderingStrategy(JoinReorderingStrategy joinReorderingStrategy) {
        this.joinReorderingStrategy = joinReorderingStrategy;
        return this;
    }

    @Min(value=2L)
    public @Min(value=2L) int getMaxReorderedJoins() {
        return this.maxReorderedJoins;
    }

    @Config(value="optimizer.max-reordered-joins")
    @ConfigDescription(value="The maximum number of tables to reorder in cost-based join reordering")
    public OptimizerConfig setMaxReorderedJoins(int maxReorderedJoins) {
        this.maxReorderedJoins = maxReorderedJoins;
        return this;
    }

    public boolean isEnableStatsCalculator() {
        return this.enableStatsCalculator;
    }

    @Config(value="enable-stats-calculator")
    @LegacyConfig(value={"experimental.enable-stats-calculator"})
    public OptimizerConfig setEnableStatsCalculator(boolean enableStatsCalculator) {
        this.enableStatsCalculator = enableStatsCalculator;
        return this;
    }

    public boolean isStatisticsPrecalculationForPushdownEnabled() {
        return this.statisticsPrecalculationForPushdownEnabled;
    }

    @Config(value="statistics-precalculation-for-pushdown.enabled")
    public OptimizerConfig setStatisticsPrecalculationForPushdownEnabled(boolean statisticsPrecalculationForPushdownEnabled) {
        this.statisticsPrecalculationForPushdownEnabled = statisticsPrecalculationForPushdownEnabled;
        return this;
    }

    public boolean isCollectPlanStatisticsForAllQueries() {
        return this.collectPlanStatisticsForAllQueries;
    }

    @Config(value="collect-plan-statistics-for-all-queries")
    @ConfigDescription(value="Collect plan statistics for non-EXPLAIN queries")
    public OptimizerConfig setCollectPlanStatisticsForAllQueries(boolean collectPlanStatisticsForAllQueries) {
        this.collectPlanStatisticsForAllQueries = collectPlanStatisticsForAllQueries;
        return this;
    }

    public boolean isIgnoreStatsCalculatorFailures() {
        return this.ignoreStatsCalculatorFailures;
    }

    @Config(value="optimizer.ignore-stats-calculator-failures")
    @ConfigDescription(value="Ignore statistics calculator failures")
    public OptimizerConfig setIgnoreStatsCalculatorFailures(boolean ignoreStatsCalculatorFailures) {
        this.ignoreStatsCalculatorFailures = ignoreStatsCalculatorFailures;
        return this;
    }

    public boolean isDefaultFilterFactorEnabled() {
        return this.defaultFilterFactorEnabled;
    }

    @Config(value="optimizer.default-filter-factor-enabled")
    public OptimizerConfig setDefaultFilterFactorEnabled(boolean defaultFilterFactorEnabled) {
        this.defaultFilterFactorEnabled = defaultFilterFactorEnabled;
        return this;
    }

    @Min(value=0L)
    @Max(value=1L)
    public @Min(value=0L) @Max(value=1L) double getFilterConjunctionIndependenceFactor() {
        return this.filterConjunctionIndependenceFactor;
    }

    @Config(value="optimizer.filter-conjunction-independence-factor")
    @ConfigDescription(value="Scales the strength of independence assumption for selectivity estimates of the conjunction of multiple filters")
    public OptimizerConfig setFilterConjunctionIndependenceFactor(double filterConjunctionIndependenceFactor) {
        this.filterConjunctionIndependenceFactor = filterConjunctionIndependenceFactor;
        return this;
    }

    public boolean isColocatedJoinsEnabled() {
        return this.colocatedJoinsEnabled;
    }

    @Config(value="colocated-joins-enabled")
    @ConfigDescription(value="Experimental: Use a colocated join when possible")
    public OptimizerConfig setColocatedJoinsEnabled(boolean colocatedJoinsEnabled) {
        this.colocatedJoinsEnabled = colocatedJoinsEnabled;
        return this;
    }

    public boolean isDistributedIndexJoinsEnabled() {
        return this.distributedIndexJoinsEnabled;
    }

    @Config(value="distributed-index-joins-enabled")
    public OptimizerConfig setDistributedIndexJoinsEnabled(boolean distributedIndexJoinsEnabled) {
        this.distributedIndexJoinsEnabled = distributedIndexJoinsEnabled;
        return this;
    }

    public boolean isSpatialJoinsEnabled() {
        return this.spatialJoinsEnabled;
    }

    @Config(value="spatial-joins-enabled")
    @ConfigDescription(value="Use spatial index for spatial joins when possible")
    public OptimizerConfig setSpatialJoinsEnabled(boolean spatialJoinsEnabled) {
        this.spatialJoinsEnabled = spatialJoinsEnabled;
        return this;
    }

    public boolean isDistributedSortEnabled() {
        return this.distributedSort;
    }

    @Config(value="distributed-sort")
    public OptimizerConfig setDistributedSortEnabled(boolean enabled) {
        this.distributedSort = enabled;
        return this;
    }

    public boolean isUsePreferredWritePartitioning() {
        return this.usePreferredWritePartitioning;
    }

    @Config(value="use-preferred-write-partitioning")
    public OptimizerConfig setUsePreferredWritePartitioning(boolean usePreferredWritePartitioning) {
        this.usePreferredWritePartitioning = usePreferredWritePartitioning;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getPreferredWritePartitioningMinNumberOfPartitions() {
        return this.preferredWritePartitioningMinNumberOfPartitions;
    }

    @Config(value="preferred-write-partitioning-min-number-of-partitions")
    @ConfigDescription(value="Use preferred write partitioning when the number of written partitions exceeds the configured threshold")
    public OptimizerConfig setPreferredWritePartitioningMinNumberOfPartitions(int preferredWritePartitioningMinNumberOfPartitions) {
        this.preferredWritePartitioningMinNumberOfPartitions = preferredWritePartitioningMinNumberOfPartitions;
        return this;
    }

    public Duration getIterativeOptimizerTimeout() {
        return this.iterativeOptimizerTimeout;
    }

    @Config(value="iterative-optimizer-timeout")
    @LegacyConfig(value={"experimental.iterative-optimizer-timeout"})
    public OptimizerConfig setIterativeOptimizerTimeout(Duration timeout) {
        this.iterativeOptimizerTimeout = timeout;
        return this;
    }

    public boolean isOptimizeMixedDistinctAggregations() {
        return this.optimizeMixedDistinctAggregations;
    }

    @Config(value="optimizer.optimize-mixed-distinct-aggregations")
    public OptimizerConfig setOptimizeMixedDistinctAggregations(boolean value) {
        this.optimizeMixedDistinctAggregations = value;
        return this;
    }

    public boolean isEnableIntermediateAggregations() {
        return this.enableIntermediateAggregations;
    }

    @Config(value="optimizer.enable-intermediate-aggregations")
    public OptimizerConfig setEnableIntermediateAggregations(boolean enableIntermediateAggregations) {
        this.enableIntermediateAggregations = enableIntermediateAggregations;
        return this;
    }

    public boolean isPushAggregationThroughOuterJoin() {
        return this.pushAggregationThroughOuterJoin;
    }

    @Config(value="optimizer.push-aggregation-through-outer-join")
    @LegacyConfig(value={"optimizer.push-aggregation-through-join"})
    public OptimizerConfig setPushAggregationThroughOuterJoin(boolean pushAggregationThroughOuterJoin) {
        this.pushAggregationThroughOuterJoin = pushAggregationThroughOuterJoin;
        return this;
    }

    public boolean isPushPartialAggregationThoughJoin() {
        return this.pushPartialAggregationThoughJoin;
    }

    @Config(value="optimizer.push-partial-aggregation-through-join")
    public OptimizerConfig setPushPartialAggregationThoughJoin(boolean pushPartialAggregationThoughJoin) {
        this.pushPartialAggregationThoughJoin = pushPartialAggregationThoughJoin;
        return this;
    }

    public boolean isOptimizeMetadataQueries() {
        return this.optimizeMetadataQueries;
    }

    @Config(value="optimizer.optimize-metadata-queries")
    public OptimizerConfig setOptimizeMetadataQueries(boolean optimizeMetadataQueries) {
        this.optimizeMetadataQueries = optimizeMetadataQueries;
        return this;
    }

    public boolean isUseMarkDistinct() {
        return this.useMarkDistinct;
    }

    @Config(value="optimizer.use-mark-distinct")
    public OptimizerConfig setUseMarkDistinct(boolean value) {
        this.useMarkDistinct = value;
        return this;
    }

    public boolean isPreferPartialAggregation() {
        return this.preferPartialAggregation;
    }

    @Config(value="optimizer.prefer-partial-aggregation")
    public OptimizerConfig setPreferPartialAggregation(boolean value) {
        this.preferPartialAggregation = value;
        return this;
    }

    public boolean isEnableForcedExchangeBelowGroupId() {
        return this.enableForcedExchangeBelowGroupId;
    }

    @Config(value="enable-forced-exchange-below-group-id")
    public OptimizerConfig setEnableForcedExchangeBelowGroupId(boolean enableForcedExchangeBelowGroupId) {
        this.enableForcedExchangeBelowGroupId = enableForcedExchangeBelowGroupId;
        return this;
    }

    public boolean isOptimizeTopNRanking() {
        return this.optimizeTopNRanking;
    }

    @Config(value="optimizer.optimize-top-n-ranking")
    @LegacyConfig(value={"optimizer.optimize-top-n-row-number"})
    public OptimizerConfig setOptimizeTopNRanking(boolean optimizeTopNRanking) {
        this.optimizeTopNRanking = optimizeTopNRanking;
        return this;
    }

    public boolean isOptimizeHashGeneration() {
        return this.optimizeHashGeneration;
    }

    @Config(value="optimizer.optimize-hash-generation")
    public OptimizerConfig setOptimizeHashGeneration(boolean optimizeHashGeneration) {
        this.optimizeHashGeneration = optimizeHashGeneration;
        return this;
    }

    public boolean isPushTableWriteThroughUnion() {
        return this.pushTableWriteThroughUnion;
    }

    @Config(value="optimizer.push-table-write-through-union")
    public OptimizerConfig setPushTableWriteThroughUnion(boolean pushTableWriteThroughUnion) {
        this.pushTableWriteThroughUnion = pushTableWriteThroughUnion;
        return this;
    }

    public boolean isDictionaryAggregation() {
        return this.dictionaryAggregation;
    }

    @Config(value="optimizer.dictionary-aggregation")
    public OptimizerConfig setDictionaryAggregation(boolean dictionaryAggregation) {
        this.dictionaryAggregation = dictionaryAggregation;
        return this;
    }

    public boolean isSkipRedundantSort() {
        return this.skipRedundantSort;
    }

    @Config(value="optimizer.skip-redundant-sort")
    public OptimizerConfig setSkipRedundantSort(boolean value) {
        this.skipRedundantSort = value;
        return this;
    }

    public boolean isComplexExpressionPushdownEnabled() {
        return this.complexExpressionPushdownEnabled;
    }

    @Config(value="optimizer.complex-expression-pushdown.enabled")
    public OptimizerConfig setComplexExpressionPushdownEnabled(boolean complexExpressionPushdownEnabled) {
        this.complexExpressionPushdownEnabled = complexExpressionPushdownEnabled;
        return this;
    }

    public boolean isPredicatePushdownUseTableProperties() {
        return this.predicatePushdownUseTableProperties;
    }

    @Config(value="optimizer.predicate-pushdown-use-table-properties")
    public OptimizerConfig setPredicatePushdownUseTableProperties(boolean predicatePushdownUseTableProperties) {
        this.predicatePushdownUseTableProperties = predicatePushdownUseTableProperties;
        return this;
    }

    public boolean isIgnoreDownstreamPreferences() {
        return this.ignoreDownstreamPreferences;
    }

    @Config(value="optimizer.ignore-downstream-preferences")
    public OptimizerConfig setIgnoreDownstreamPreferences(boolean ignoreDownstreamPreferences) {
        this.ignoreDownstreamPreferences = ignoreDownstreamPreferences;
        return this;
    }

    public boolean isRewriteFilteringSemiJoinToInnerJoin() {
        return this.rewriteFilteringSemiJoinToInnerJoin;
    }

    @Config(value="optimizer.rewrite-filtering-semi-join-to-inner-join")
    public OptimizerConfig setRewriteFilteringSemiJoinToInnerJoin(boolean rewriteFilteringSemiJoinToInnerJoin) {
        this.rewriteFilteringSemiJoinToInnerJoin = rewriteFilteringSemiJoinToInnerJoin;
        return this;
    }

    public boolean isOptimizeDuplicateInsensitiveJoins() {
        return this.optimizeDuplicateInsensitiveJoins;
    }

    @Config(value="optimizer.optimize-duplicate-insensitive-joins")
    public OptimizerConfig setOptimizeDuplicateInsensitiveJoins(boolean optimizeDuplicateInsensitiveJoins) {
        this.optimizeDuplicateInsensitiveJoins = optimizeDuplicateInsensitiveJoins;
        return this;
    }

    public boolean isUseLegacyWindowFilterPushdown() {
        return this.useLegacyWindowFilterPushdown;
    }

    @Config(value="optimizer.use-legacy-window-filter-pushdown")
    public OptimizerConfig setUseLegacyWindowFilterPushdown(boolean useLegacyWindowFilterPushdown) {
        this.useLegacyWindowFilterPushdown = useLegacyWindowFilterPushdown;
        return this;
    }

    public boolean isUseTableScanNodePartitioning() {
        return this.useTableScanNodePartitioning;
    }

    @Config(value="optimizer.use-table-scan-node-partitioning")
    @LegacyConfig(value={"optimizer.plan-with-table-node-partitioning"})
    @ConfigDescription(value="Adapt plan to node pre-partitioned tables")
    public OptimizerConfig setUseTableScanNodePartitioning(boolean useTableScanNodePartitioning) {
        this.useTableScanNodePartitioning = useTableScanNodePartitioning;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) double getTableScanNodePartitioningMinBucketToTaskRatio() {
        return this.tableScanNodePartitioningMinBucketToTaskRatio;
    }

    @Config(value="optimizer.table-scan-node-partitioning-min-bucket-to-task-ratio")
    @ConfigDescription(value="Min table scan bucket to task ratio for which plan will be adopted to node pre-partitioned tables")
    public OptimizerConfig setTableScanNodePartitioningMinBucketToTaskRatio(double tableScanNodePartitioningMinBucketToTaskRatio) {
        this.tableScanNodePartitioningMinBucketToTaskRatio = tableScanNodePartitioningMinBucketToTaskRatio;
        return this;
    }

    public boolean isMergeProjectWithValues() {
        return this.mergeProjectWithValues;
    }

    @Config(value="optimizer.merge-project-with-values")
    public OptimizerConfig setMergeProjectWithValues(boolean mergeProjectWithValues) {
        this.mergeProjectWithValues = mergeProjectWithValues;
        return this;
    }

    public boolean isForceSingleNodeOutput() {
        return this.forceSingleNodeOutput;
    }

    @Config(value="optimizer.force-single-node-output")
    public OptimizerConfig setForceSingleNodeOutput(boolean value) {
        this.forceSingleNodeOutput = value;
        return this;
    }

    public boolean isAdaptivePartialAggregationEnabled() {
        return this.adaptivePartialAggregationEnabled;
    }

    @Config(value="adaptive-partial-aggregation.enabled")
    public OptimizerConfig setAdaptivePartialAggregationEnabled(boolean adaptivePartialAggregationEnabled) {
        this.adaptivePartialAggregationEnabled = adaptivePartialAggregationEnabled;
        return this;
    }

    public long getAdaptivePartialAggregationMinRows() {
        return this.adaptivePartialAggregationMinRows;
    }

    @Config(value="adaptive-partial-aggregation.min-rows")
    @ConfigDescription(value="Minimum number of processed rows before partial aggregation might be adaptively turned off")
    public OptimizerConfig setAdaptivePartialAggregationMinRows(long adaptivePartialAggregationMinRows) {
        this.adaptivePartialAggregationMinRows = adaptivePartialAggregationMinRows;
        return this;
    }

    public double getAdaptivePartialAggregationUniqueRowsRatioThreshold() {
        return this.adaptivePartialAggregationUniqueRowsRatioThreshold;
    }

    @Config(value="adaptive-partial-aggregation.unique-rows-ratio-threshold")
    @ConfigDescription(value="Ratio between aggregation output and input rows above which partial aggregation might be adaptively turned off")
    public OptimizerConfig setAdaptivePartialAggregationUniqueRowsRatioThreshold(double adaptivePartialAggregationUniqueRowsRatioThreshold) {
        this.adaptivePartialAggregationUniqueRowsRatioThreshold = adaptivePartialAggregationUniqueRowsRatioThreshold;
        return this;
    }

    public static enum JoinDistributionType {
        BROADCAST,
        PARTITIONED,
        AUTOMATIC;


        public boolean canPartition() {
            return this == PARTITIONED || this == AUTOMATIC;
        }

        public boolean canReplicate() {
            return this == BROADCAST || this == AUTOMATIC;
        }
    }

    public static enum JoinReorderingStrategy {
        NONE,
        ELIMINATE_CROSS_JOINS,
        AUTOMATIC;

    }
}

