/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.trino.connector.CatalogName;
import io.trino.connector.ConnectorAwareNodeManager;
import io.trino.connector.ConnectorContextInstance;
import io.trino.connector.InternalMetadataProvider;
import io.trino.connector.informationschema.InformationSchemaConnector;
import io.trino.connector.system.CoordinatorSystemTablesProvider;
import io.trino.connector.system.StaticSystemTablesProvider;
import io.trino.connector.system.SystemConnector;
import io.trino.connector.system.SystemTablesProvider;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.index.IndexManager;
import io.trino.metadata.AnalyzePropertyManager;
import io.trino.metadata.Catalog;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.ColumnPropertyManager;
import io.trino.metadata.HandleResolver;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.MaterializedViewPropertyManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.ProcedureRegistry;
import io.trino.metadata.SchemaPropertyManager;
import io.trino.metadata.SessionPropertyManager;
import io.trino.metadata.TableProceduresPropertyManager;
import io.trino.metadata.TableProceduresRegistry;
import io.trino.metadata.TablePropertyManager;
import io.trino.security.AccessControlManager;
import io.trino.server.PluginClassLoader;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.PageSorter;
import io.trino.spi.VersionEmbedder;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorIndexProvider;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableProcedureMetadata;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.TypeManager;
import io.trino.split.PageSinkManager;
import io.trino.split.PageSourceManager;
import io.trino.split.RecordPageSourceProvider;
import io.trino.split.SplitManager;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class ConnectorManager {
    private static final Logger log = Logger.get(ConnectorManager.class);
    private final Metadata metadata;
    private final CatalogManager catalogManager;
    private final AccessControlManager accessControlManager;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final IndexManager indexManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final PageSinkManager pageSinkManager;
    private final HandleResolver handleResolver;
    private final InternalNodeManager nodeManager;
    private final PageSorter pageSorter;
    private final PageIndexerFactory pageIndexerFactory;
    private final NodeInfo nodeInfo;
    private final VersionEmbedder versionEmbedder;
    private final TransactionManager transactionManager;
    private final EventListenerManager eventListenerManager;
    private final TypeManager typeManager;
    private final ProcedureRegistry procedureRegistry;
    private final TableProceduresRegistry tableProceduresRegistry;
    private final SessionPropertyManager sessionPropertyManager;
    private final SchemaPropertyManager schemaPropertyManager;
    private final ColumnPropertyManager columnPropertyManager;
    private final TablePropertyManager tablePropertyManager;
    private final MaterializedViewPropertyManager materializedViewPropertyManager;
    private final AnalyzePropertyManager analyzePropertyManager;
    private final TableProceduresPropertyManager tableProceduresPropertyManager;
    private final boolean schedulerIncludeCoordinator;
    @GuardedBy(value="this")
    private final ConcurrentMap<String, InternalConnectorFactory> connectorFactories = new ConcurrentHashMap<String, InternalConnectorFactory>();
    @GuardedBy(value="this")
    private final ConcurrentMap<CatalogName, MaterializedConnector> connectors = new ConcurrentHashMap<CatalogName, MaterializedConnector>();
    private final AtomicBoolean stopped = new AtomicBoolean();

    @Inject
    public ConnectorManager(Metadata metadata, CatalogManager catalogManager, AccessControlManager accessControlManager, SplitManager splitManager, PageSourceManager pageSourceManager, IndexManager indexManager, NodePartitioningManager nodePartitioningManager, PageSinkManager pageSinkManager, HandleResolver handleResolver, InternalNodeManager nodeManager, NodeInfo nodeInfo, VersionEmbedder versionEmbedder, PageSorter pageSorter, PageIndexerFactory pageIndexerFactory, TransactionManager transactionManager, EventListenerManager eventListenerManager, TypeManager typeManager, ProcedureRegistry procedureRegistry, TableProceduresRegistry tableProceduresRegistry, SessionPropertyManager sessionPropertyManager, SchemaPropertyManager schemaPropertyManager, ColumnPropertyManager columnPropertyManager, TablePropertyManager tablePropertyManager, MaterializedViewPropertyManager materializedViewPropertyManager, AnalyzePropertyManager analyzePropertyManager, TableProceduresPropertyManager tableProceduresPropertyManager, NodeSchedulerConfig nodeSchedulerConfig) {
        this.metadata = metadata;
        this.catalogManager = catalogManager;
        this.accessControlManager = accessControlManager;
        this.splitManager = splitManager;
        this.pageSourceManager = pageSourceManager;
        this.indexManager = indexManager;
        this.nodePartitioningManager = nodePartitioningManager;
        this.pageSinkManager = pageSinkManager;
        this.handleResolver = handleResolver;
        this.nodeManager = nodeManager;
        this.pageSorter = pageSorter;
        this.pageIndexerFactory = pageIndexerFactory;
        this.nodeInfo = nodeInfo;
        this.versionEmbedder = versionEmbedder;
        this.transactionManager = transactionManager;
        this.eventListenerManager = eventListenerManager;
        this.typeManager = typeManager;
        this.procedureRegistry = procedureRegistry;
        this.tableProceduresRegistry = tableProceduresRegistry;
        this.sessionPropertyManager = sessionPropertyManager;
        this.schemaPropertyManager = schemaPropertyManager;
        this.columnPropertyManager = columnPropertyManager;
        this.tablePropertyManager = tablePropertyManager;
        this.materializedViewPropertyManager = materializedViewPropertyManager;
        this.analyzePropertyManager = analyzePropertyManager;
        this.tableProceduresPropertyManager = tableProceduresPropertyManager;
        this.schedulerIncludeCoordinator = nodeSchedulerConfig.isIncludeCoordinator();
    }

    @PreDestroy
    public synchronized void stop() {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        for (MaterializedConnector connector : this.connectors.values()) {
            connector.shutdown();
        }
    }

    public synchronized void addConnectorFactory(ConnectorFactory connectorFactory, Function<CatalogName, ClassLoader> duplicatePluginClassLoaderFactory) {
        Objects.requireNonNull(connectorFactory, "connectorFactory is null");
        Objects.requireNonNull(duplicatePluginClassLoaderFactory, "duplicatePluginClassLoaderFactory is null");
        Preconditions.checkState((!this.stopped.get() ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
        InternalConnectorFactory existingConnectorFactory = this.connectorFactories.putIfAbsent(connectorFactory.getName(), new InternalConnectorFactory(connectorFactory, duplicatePluginClassLoaderFactory));
        Preconditions.checkArgument((existingConnectorFactory == null ? 1 : 0) != 0, (String)"Connector '%s' is already registered", (Object)connectorFactory.getName());
    }

    public synchronized CatalogName createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        Objects.requireNonNull(connectorName, "connectorName is null");
        InternalConnectorFactory connectorFactory = (InternalConnectorFactory)this.connectorFactories.get(connectorName);
        Preconditions.checkArgument((connectorFactory != null ? 1 : 0) != 0, (String)"No factory for connector '%s'.  Available factories: %s", (Object)connectorName, this.connectorFactories.keySet());
        return this.createCatalog(catalogName, connectorName, connectorFactory, properties);
    }

    private synchronized CatalogName createCatalog(String catalogName, String connectorName, InternalConnectorFactory connectorFactory, Map<String, String> properties) {
        Preconditions.checkState((!this.stopped.get() ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(properties, "properties is null");
        Objects.requireNonNull(connectorFactory, "connectorFactory is null");
        Preconditions.checkArgument((boolean)this.catalogManager.getCatalog(catalogName).isEmpty(), (String)"Catalog '%s' already exists", (Object)catalogName);
        CatalogName catalog = new CatalogName(catalogName);
        Preconditions.checkState((!this.connectors.containsKey(catalog) ? 1 : 0) != 0, (String)"Catalog '%s' already exists", (Object)catalog);
        this.createCatalog(catalog, connectorName, connectorFactory, properties);
        return catalog;
    }

    private synchronized void createCatalog(CatalogName catalogName, String connectorName, InternalConnectorFactory factory, Map<String, String> properties) {
        CatalogClassLoaderSupplier duplicatePluginClassLoaderFactory = new CatalogClassLoaderSupplier(catalogName, factory.getDuplicatePluginClassLoaderFactory(), this.handleResolver);
        MaterializedConnector connector = new MaterializedConnector(catalogName, this.createConnector(catalogName, factory.getConnectorFactory(), duplicatePluginClassLoaderFactory, properties), duplicatePluginClassLoaderFactory::destroy);
        MaterializedConnector informationSchemaConnector = new MaterializedConnector(CatalogName.createInformationSchemaCatalogName(catalogName), new InformationSchemaConnector(catalogName.getCatalogName(), this.nodeManager, this.metadata, this.accessControlManager), () -> {});
        CatalogName systemId = CatalogName.createSystemTablesCatalogName(catalogName);
        SystemTablesProvider systemTablesProvider = this.nodeManager.getCurrentNode().isCoordinator() ? new CoordinatorSystemTablesProvider(this.transactionManager, this.metadata, catalogName.getCatalogName(), new StaticSystemTablesProvider(connector.getSystemTables())) : new StaticSystemTablesProvider(connector.getSystemTables());
        MaterializedConnector systemConnector = new MaterializedConnector(systemId, new SystemConnector(this.nodeManager, systemTablesProvider, transactionId -> this.transactionManager.getConnectorTransaction((TransactionId)transactionId, catalogName)), () -> {});
        Catalog.SecurityManagement securityManagement = connector.getAccessControl().isPresent() ? Catalog.SecurityManagement.CONNECTOR : Catalog.SecurityManagement.SYSTEM;
        Catalog catalog = new Catalog(catalogName.getCatalogName(), connector.getCatalogName(), connectorName, connector.getConnector(), securityManagement, informationSchemaConnector.getCatalogName(), informationSchemaConnector.getConnector(), systemConnector.getCatalogName(), systemConnector.getConnector());
        try {
            this.addConnectorInternal(connector);
            this.addConnectorInternal(informationSchemaConnector);
            this.addConnectorInternal(systemConnector);
            this.catalogManager.registerCatalog(catalog);
        }
        catch (Throwable e) {
            this.catalogManager.removeCatalog(catalog.getCatalogName());
            this.removeConnectorInternal(systemConnector.getCatalogName());
            this.removeConnectorInternal(informationSchemaConnector.getCatalogName());
            this.removeConnectorInternal(connector.getCatalogName());
            throw e;
        }
        connector.getEventListeners().forEach(this.eventListenerManager::addEventListener);
    }

    private synchronized void addConnectorInternal(MaterializedConnector connector) {
        Preconditions.checkState((!this.stopped.get() ? 1 : 0) != 0, (Object)"ConnectorManager is stopped");
        CatalogName catalogName = connector.getCatalogName();
        Preconditions.checkState((!this.connectors.containsKey(catalogName) ? 1 : 0) != 0, (String)"Catalog '%s' already exists", (Object)catalogName);
        this.connectors.put(catalogName, connector);
        connector.getSplitManager().ifPresent(connectorSplitManager -> this.splitManager.addConnectorSplitManager(catalogName, (ConnectorSplitManager)connectorSplitManager));
        connector.getPageSourceProvider().ifPresent(pageSourceProvider -> this.pageSourceManager.addConnectorPageSourceProvider(catalogName, (ConnectorPageSourceProvider)pageSourceProvider));
        connector.getPageSinkProvider().ifPresent(pageSinkProvider -> this.pageSinkManager.addConnectorPageSinkProvider(catalogName, (ConnectorPageSinkProvider)pageSinkProvider));
        connector.getIndexProvider().ifPresent(indexProvider -> this.indexManager.addIndexProvider(catalogName, (ConnectorIndexProvider)indexProvider));
        connector.getPartitioningProvider().ifPresent(partitioningProvider -> this.nodePartitioningManager.addPartitioningProvider(catalogName, (ConnectorNodePartitioningProvider)partitioningProvider));
        this.procedureRegistry.addProcedures(catalogName, connector.getProcedures());
        Set<TableProcedureMetadata> tableProcedures = connector.getTableProcedures();
        this.tableProceduresRegistry.addTableProcedures(catalogName, tableProcedures);
        connector.getAccessControl().ifPresent(accessControl -> this.accessControlManager.addCatalogAccessControl(catalogName, (ConnectorAccessControl)accessControl));
        this.tablePropertyManager.addProperties(catalogName, (List)connector.getTableProperties());
        this.materializedViewPropertyManager.addProperties(catalogName, (List)connector.getMaterializedViewProperties());
        this.columnPropertyManager.addProperties(catalogName, (List)connector.getColumnProperties());
        this.schemaPropertyManager.addProperties(catalogName, (List)connector.getSchemaProperties());
        this.analyzePropertyManager.addProperties(catalogName, (List)connector.getAnalyzeProperties());
        for (TableProcedureMetadata tableProcedure : tableProcedures) {
            this.tableProceduresPropertyManager.addProperties(catalogName, tableProcedure.getName(), tableProcedure.getProperties());
        }
        this.sessionPropertyManager.addConnectorSessionProperties(catalogName, connector.getSessionProperties());
    }

    public synchronized void dropConnection(String catalogName) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.catalogManager.removeCatalog(catalogName).ifPresent(catalog -> {
            this.removeConnectorInternal((CatalogName)catalog);
            this.removeConnectorInternal(CatalogName.createInformationSchemaCatalogName(catalog));
            this.removeConnectorInternal(CatalogName.createSystemTablesCatalogName(catalog));
        });
    }

    private synchronized void removeConnectorInternal(CatalogName catalogName) {
        this.splitManager.removeConnectorSplitManager(catalogName);
        this.pageSourceManager.removeConnectorPageSourceProvider(catalogName);
        this.pageSinkManager.removeConnectorPageSinkProvider(catalogName);
        this.indexManager.removeIndexProvider(catalogName);
        this.nodePartitioningManager.removePartitioningProvider(catalogName);
        this.procedureRegistry.removeProcedures(catalogName);
        this.tableProceduresRegistry.removeProcedures(catalogName);
        this.accessControlManager.removeCatalogAccessControl(catalogName);
        this.tablePropertyManager.removeProperties(catalogName);
        this.materializedViewPropertyManager.removeProperties(catalogName);
        this.columnPropertyManager.removeProperties(catalogName);
        this.schemaPropertyManager.removeProperties(catalogName);
        this.analyzePropertyManager.removeProperties(catalogName);
        this.tableProceduresPropertyManager.removeProperties(catalogName);
        this.sessionPropertyManager.removeConnectorSessionProperties(catalogName);
        MaterializedConnector materializedConnector = (MaterializedConnector)this.connectors.remove(catalogName);
        if (materializedConnector != null) {
            materializedConnector.shutdown();
        }
    }

    private Connector createConnector(CatalogName catalogName, ConnectorFactory connectorFactory, Supplier<ClassLoader> duplicatePluginClassLoaderFactory, Map<String, String> properties) {
        ConnectorContextInstance context = new ConnectorContextInstance(new ConnectorAwareNodeManager(this.nodeManager, this.nodeInfo.getEnvironment(), catalogName, this.schedulerIncludeCoordinator), this.versionEmbedder, this.typeManager, new InternalMetadataProvider(this.metadata, this.typeManager), this.pageSorter, this.pageIndexerFactory, duplicatePluginClassLoaderFactory);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(connectorFactory.getClass().getClassLoader());){
            Connector connector = connectorFactory.create(catalogName.getCatalogName(), properties, (ConnectorContext)context);
            return connector;
        }
    }

    private static class MaterializedConnector {
        private final CatalogName catalogName;
        private final Connector connector;
        private final Runnable afterShutdown;
        private final Set<SystemTable> systemTables;
        private final Set<Procedure> procedures;
        private final Set<TableProcedureMetadata> tableProcedures;
        private final Optional<ConnectorSplitManager> splitManager;
        private final Optional<ConnectorPageSourceProvider> pageSourceProvider;
        private final Optional<ConnectorPageSinkProvider> pageSinkProvider;
        private final Optional<ConnectorIndexProvider> indexProvider;
        private final Optional<ConnectorNodePartitioningProvider> partitioningProvider;
        private final Optional<ConnectorAccessControl> accessControl;
        private final List<EventListener> eventListeners;
        private final List<PropertyMetadata<?>> sessionProperties;
        private final List<PropertyMetadata<?>> tableProperties;
        private final List<PropertyMetadata<?>> materializedViewProperties;
        private final List<PropertyMetadata<?>> schemaProperties;
        private final List<PropertyMetadata<?>> columnProperties;
        private final List<PropertyMetadata<?>> analyzeProperties;

        public MaterializedConnector(CatalogName catalogName, Connector connector, Runnable afterShutdown) {
            this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
            this.connector = Objects.requireNonNull(connector, "connector is null");
            this.afterShutdown = Objects.requireNonNull(afterShutdown, "afterShutdown is null");
            Set systemTables = connector.getSystemTables();
            Objects.requireNonNull(systemTables, String.format("Connector '%s' returned a null system tables set", catalogName));
            this.systemTables = ImmutableSet.copyOf((Collection)systemTables);
            Set procedures = connector.getProcedures();
            Objects.requireNonNull(procedures, String.format("Connector '%s' returned a null procedures set", catalogName));
            this.procedures = ImmutableSet.copyOf((Collection)procedures);
            Set tableProcedures = connector.getTableProcedures();
            Objects.requireNonNull(procedures, String.format("Connector '%s' returned a null table procedures set", catalogName));
            this.tableProcedures = ImmutableSet.copyOf((Collection)tableProcedures);
            ConnectorSplitManager splitManager = null;
            try {
                splitManager = connector.getSplitManager();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.splitManager = Optional.ofNullable(splitManager);
            ConnectorPageSourceProvider connectorPageSourceProvider = null;
            try {
                connectorPageSourceProvider = connector.getPageSourceProvider();
                Objects.requireNonNull(connectorPageSourceProvider, String.format("Connector '%s' returned a null page source provider", catalogName));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                ConnectorRecordSetProvider connectorRecordSetProvider = connector.getRecordSetProvider();
                Objects.requireNonNull(connectorRecordSetProvider, String.format("Connector '%s' returned a null record set provider", catalogName));
                Verify.verify((connectorPageSourceProvider == null ? 1 : 0) != 0, (String)"Connector '%s' returned both page source and record set providers", (Object)catalogName);
                connectorPageSourceProvider = new RecordPageSourceProvider(connectorRecordSetProvider);
            }
            catch (UnsupportedOperationException connectorRecordSetProvider) {
                // empty catch block
            }
            this.pageSourceProvider = Optional.ofNullable(connectorPageSourceProvider);
            ConnectorPageSinkProvider connectorPageSinkProvider = null;
            try {
                connectorPageSinkProvider = connector.getPageSinkProvider();
                Objects.requireNonNull(connectorPageSinkProvider, String.format("Connector '%s' returned a null page sink provider", catalogName));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.pageSinkProvider = Optional.ofNullable(connectorPageSinkProvider);
            ConnectorIndexProvider indexProvider = null;
            try {
                indexProvider = connector.getIndexProvider();
                Objects.requireNonNull(indexProvider, String.format("Connector '%s' returned a null index provider", catalogName));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.indexProvider = Optional.ofNullable(indexProvider);
            ConnectorNodePartitioningProvider partitioningProvider = null;
            try {
                partitioningProvider = connector.getNodePartitioningProvider();
                Objects.requireNonNull(partitioningProvider, String.format("Connector '%s' returned a null partitioning provider", catalogName));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.partitioningProvider = Optional.ofNullable(partitioningProvider);
            ConnectorAccessControl accessControl = null;
            try {
                accessControl = connector.getAccessControl();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.accessControl = Optional.ofNullable(accessControl);
            Iterable eventListeners = connector.getEventListeners();
            Objects.requireNonNull(eventListeners, String.format("Connector '%s' returned a null event listeners iterable", eventListeners));
            this.eventListeners = ImmutableList.copyOf((Iterable)eventListeners);
            List sessionProperties = connector.getSessionProperties();
            Objects.requireNonNull(sessionProperties, String.format("Connector '%s' returned a null system properties set", catalogName));
            this.sessionProperties = ImmutableList.copyOf((Collection)sessionProperties);
            List tableProperties = connector.getTableProperties();
            Objects.requireNonNull(tableProperties, String.format("Connector '%s' returned a null table properties set", catalogName));
            this.tableProperties = ImmutableList.copyOf((Collection)tableProperties);
            List materializedViewProperties = connector.getMaterializedViewProperties();
            Objects.requireNonNull(materializedViewProperties, String.format("Connector '%s' returned a null materialized view properties set", catalogName));
            this.materializedViewProperties = ImmutableList.copyOf((Collection)materializedViewProperties);
            List schemaProperties = connector.getSchemaProperties();
            Objects.requireNonNull(schemaProperties, String.format("Connector '%s' returned a null schema properties set", catalogName));
            this.schemaProperties = ImmutableList.copyOf((Collection)schemaProperties);
            List columnProperties = connector.getColumnProperties();
            Objects.requireNonNull(columnProperties, String.format("Connector '%s' returned a null column properties set", catalogName));
            this.columnProperties = ImmutableList.copyOf((Collection)columnProperties);
            List analyzeProperties = connector.getAnalyzeProperties();
            Objects.requireNonNull(analyzeProperties, String.format("Connector '%s' returned a null analyze properties set", catalogName));
            this.analyzeProperties = ImmutableList.copyOf((Collection)analyzeProperties);
        }

        public CatalogName getCatalogName() {
            return this.catalogName;
        }

        public Connector getConnector() {
            return this.connector;
        }

        public Set<SystemTable> getSystemTables() {
            return this.systemTables;
        }

        public Set<Procedure> getProcedures() {
            return this.procedures;
        }

        public Set<TableProcedureMetadata> getTableProcedures() {
            return this.tableProcedures;
        }

        public Optional<ConnectorSplitManager> getSplitManager() {
            return this.splitManager;
        }

        public Optional<ConnectorPageSourceProvider> getPageSourceProvider() {
            return this.pageSourceProvider;
        }

        public Optional<ConnectorPageSinkProvider> getPageSinkProvider() {
            return this.pageSinkProvider;
        }

        public Optional<ConnectorIndexProvider> getIndexProvider() {
            return this.indexProvider;
        }

        public Optional<ConnectorNodePartitioningProvider> getPartitioningProvider() {
            return this.partitioningProvider;
        }

        public Optional<ConnectorAccessControl> getAccessControl() {
            return this.accessControl;
        }

        public List<EventListener> getEventListeners() {
            return this.eventListeners;
        }

        public List<PropertyMetadata<?>> getSessionProperties() {
            return this.sessionProperties;
        }

        public List<PropertyMetadata<?>> getTableProperties() {
            return this.tableProperties;
        }

        public List<PropertyMetadata<?>> getMaterializedViewProperties() {
            return this.materializedViewProperties;
        }

        public List<PropertyMetadata<?>> getColumnProperties() {
            return this.columnProperties;
        }

        public List<PropertyMetadata<?>> getSchemaProperties() {
            return this.schemaProperties;
        }

        public List<PropertyMetadata<?>> getAnalyzeProperties() {
            return this.analyzeProperties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.connector.getClass().getClassLoader());){
                this.connector.shutdown();
            }
            catch (Throwable t) {
                log.error(t, "Error shutting down connector: %s", new Object[]{this.catalogName});
            }
            finally {
                this.afterShutdown.run();
            }
        }
    }

    private static class CatalogClassLoaderSupplier
    implements Supplier<ClassLoader> {
        private final CatalogName catalogName;
        private final Function<CatalogName, ClassLoader> duplicatePluginClassLoaderFactory;
        private final HandleResolver handleResolver;
        @GuardedBy(value="this")
        private boolean destroyed;
        @GuardedBy(value="this")
        private ClassLoader classLoader;

        public CatalogClassLoaderSupplier(CatalogName catalogName, Function<CatalogName, ClassLoader> duplicatePluginClassLoaderFactory, HandleResolver handleResolver) {
            this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
            this.duplicatePluginClassLoaderFactory = Objects.requireNonNull(duplicatePluginClassLoaderFactory, "duplicatePluginClassLoaderFactory is null");
            this.handleResolver = Objects.requireNonNull(handleResolver, "handleResolver is null");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClassLoader get() {
            ClassLoader classLoader = this.duplicatePluginClassLoaderFactory.apply(this.catalogName);
            CatalogClassLoaderSupplier catalogClassLoaderSupplier = this;
            synchronized (catalogClassLoaderSupplier) {
                Preconditions.checkState((this.classLoader == null ? 1 : 0) != 0, (Object)("class loader is already a duplicated for catalog " + this.catalogName));
                Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"catalog has been shutdown");
                this.classLoader = classLoader;
            }
            if (classLoader instanceof PluginClassLoader) {
                this.handleResolver.registerClassLoader((PluginClassLoader)classLoader);
            }
            return classLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            ClassLoader classLoader;
            CatalogClassLoaderSupplier catalogClassLoaderSupplier = this;
            synchronized (catalogClassLoaderSupplier) {
                Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"catalog has been shutdown");
                classLoader = this.classLoader;
                this.destroyed = true;
            }
            if (classLoader instanceof PluginClassLoader) {
                this.handleResolver.unregisterClassLoader((PluginClassLoader)classLoader);
            }
        }
    }

    private static class InternalConnectorFactory {
        private final ConnectorFactory connectorFactory;
        private final Function<CatalogName, ClassLoader> duplicatePluginClassLoaderFactory;

        public InternalConnectorFactory(ConnectorFactory connectorFactory, Function<CatalogName, ClassLoader> duplicatePluginClassLoaderFactory) {
            this.connectorFactory = connectorFactory;
            this.duplicatePluginClassLoaderFactory = duplicatePluginClassLoaderFactory;
        }

        public ConnectorFactory getConnectorFactory() {
            return this.connectorFactory;
        }

        public Function<CatalogName, ClassLoader> getDuplicatePluginClassLoaderFactory() {
            return this.duplicatePluginClassLoaderFactory;
        }

        public String toString() {
            return this.connectorFactory.getName();
        }
    }
}

