/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.collect.ImmutableSet;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.procedure.Procedure;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class GlobalSystemConnectorFactory
implements ConnectorFactory {
    private final Set<SystemTable> tables;
    private final Set<Procedure> procedures;

    @Inject
    public GlobalSystemConnectorFactory(Set<SystemTable> tables, Set<Procedure> procedures) {
        this.tables = ImmutableSet.copyOf((Collection)Objects.requireNonNull(tables, "tables is null"));
        this.procedures = ImmutableSet.copyOf((Collection)Objects.requireNonNull(procedures, "procedures is null"));
    }

    public String getName() {
        return "system";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        return new GlobalSystemConnector(this.tables, this.procedures);
    }
}

