/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.security.Privilege;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Deny;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GrantOnType;
import io.trino.sql.tree.Node;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class DenyTask
implements DataDefinitionTask<Deny> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public DenyTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "DENY";
    }

    @Override
    public ListenableFuture<Void> execute(Deny statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        if (statement.getType().filter(arg_0 -> GrantOnType.SCHEMA.equals(arg_0)).isPresent()) {
            DenyTask.executeDenyOnSchema(stateMachine.getSession(), statement, this.metadata, this.accessControl);
        } else {
            DenyTask.executeDenyOnTable(stateMachine.getSession(), statement, this.metadata, this.accessControl);
        }
        return Futures.immediateVoidFuture();
    }

    private static void executeDenyOnSchema(Session session, Deny statement, Metadata metadata, AccessControl accessControl) {
        CatalogSchemaName schemaName = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getName()));
        if (!metadata.schemaExists(session, schemaName)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, (Node)statement, "Schema '%s' does not exist", schemaName);
        }
        Set<Privilege> privileges = DenyTask.parseStatementPrivileges(statement);
        for (Privilege privilege : privileges) {
            accessControl.checkCanDenySchemaPrivilege(session.toSecurityContext(), privilege, schemaName, MetadataUtil.createPrincipal(statement.getGrantee()));
        }
        metadata.denySchemaPrivileges(session, schemaName, privileges, MetadataUtil.createPrincipal(statement.getGrantee()));
    }

    private static void executeDenyOnTable(Session session, Deny statement, Metadata metadata, AccessControl accessControl) {
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        RedirectionAwareTableHandle redirection = metadata.getRedirectionAwareTableHandle(session, tableName);
        Optional<TableHandle> tableHandle = redirection.getTableHandle();
        if (tableHandle.isEmpty()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", tableName);
        }
        if (redirection.getRedirectedTableName().isPresent()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Table %s is redirected to %s and DENY is not supported with table redirections", tableName, redirection.getRedirectedTableName().get());
        }
        Set<Privilege> privileges = DenyTask.parseStatementPrivileges(statement);
        for (Privilege privilege : privileges) {
            accessControl.checkCanDenyTablePrivilege(session.toSecurityContext(), privilege, tableName, MetadataUtil.createPrincipal(statement.getGrantee()));
        }
        metadata.denyTablePrivileges(session, tableName, privileges, MetadataUtil.createPrincipal(statement.getGrantee()));
    }

    private static Set<Privilege> parseStatementPrivileges(Deny statement) {
        Set<Object> privileges = statement.getPrivileges().isPresent() ? (Set)((List)statement.getPrivileges().get()).stream().map(privilege -> DenyTask.parsePrivilege(statement, privilege)).collect(ImmutableSet.toImmutableSet()) : EnumSet.allOf(Privilege.class);
        return privileges;
    }

    private static Privilege parsePrivilege(Deny statement, String privilegeString) {
        for (Privilege privilege : Privilege.values()) {
            if (!privilege.name().equalsIgnoreCase(privilegeString)) continue;
            return privilege;
        }
        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PRIVILEGE, (Node)statement, "Unknown privilege: '%s'", privilegeString);
    }
}

