/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.RenameTable;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class RenameTableTask
implements DataDefinitionTask<RenameTable> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public RenameTableTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "RENAME TABLE";
    }

    @Override
    public ListenableFuture<Void> execute(RenameTable statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedObjectName tableName;
        Session session = stateMachine.getSession();
        if (this.metadata.isMaterializedView(session, tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getSource()))) {
            if (!statement.isExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist, but a materialized view with that name exists. Did you mean ALTER MATERIALIZED VIEW %s RENAME ...?", tableName, tableName);
            }
            return Futures.immediateVoidFuture();
        }
        if (this.metadata.isView(session, tableName)) {
            if (!statement.isExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist, but a view with that name exists. Did you mean ALTER VIEW %s RENAME ...?", tableName, tableName);
            }
            return Futures.immediateVoidFuture();
        }
        RedirectionAwareTableHandle redirectionAwareTableHandle = this.metadata.getRedirectionAwareTableHandle(session, tableName);
        if (redirectionAwareTableHandle.getTableHandle().isEmpty()) {
            if (!statement.isExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", tableName);
            }
            return Futures.immediateVoidFuture();
        }
        TableHandle tableHandle = redirectionAwareTableHandle.getTableHandle().get();
        QualifiedObjectName source = redirectionAwareTableHandle.getRedirectedTableName().orElse(tableName);
        QualifiedObjectName target = RenameTableTask.createTargetQualifiedObjectName(source, statement.getTarget());
        if (this.metadata.getCatalogHandle(session, target.getCatalogName()).isEmpty()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_FOUND, (Node)statement, "Target catalog '%s' does not exist", target.getCatalogName());
        }
        if (this.metadata.getTableHandle(session, target).isPresent()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Target table '%s' already exists", target);
        }
        if (!tableHandle.getCatalogName().getCatalogName().equals(target.getCatalogName())) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Table rename across catalogs is not supported", new Object[0]);
        }
        this.accessControl.checkCanRenameTable(session.toSecurityContext(), source, target);
        this.metadata.renameTable(session, tableHandle, target);
        return Futures.immediateVoidFuture();
    }

    private static QualifiedObjectName createTargetQualifiedObjectName(QualifiedObjectName source, QualifiedName target) {
        Objects.requireNonNull(target, "target is null");
        if (target.getParts().size() > 3) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, String.format("Too many dots in table name: %s", target));
        }
        List parts = Lists.reverse((List)target.getParts());
        String objectName = (String)parts.get(0);
        String schemaName = parts.size() > 1 ? (String)parts.get(1) : source.getSchemaName();
        String catalogName = parts.size() > 2 ? (String)parts.get(2) : source.getCatalogName();
        return new QualifiedObjectName(catalogName, schemaName, objectName);
    }
}

