/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.BasicStageStats;
import io.trino.execution.StageState;
import io.trino.operator.BlockedReason;
import io.trino.operator.OperatorStats;
import io.trino.spi.eventlistener.StageGcStatistics;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@Immutable
public class StageStats {
    private final DateTime schedulingComplete;
    private final Distribution.DistributionSnapshot getSplitDistribution;
    private final int totalTasks;
    private final int runningTasks;
    private final int completedTasks;
    private final int failedTasks;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int runningDrivers;
    private final int blockedDrivers;
    private final int completedDrivers;
    private final double cumulativeUserMemory;
    private final double failedCumulativeUserMemory;
    private final DataSize userMemoryReservation;
    private final DataSize revocableMemoryReservation;
    private final DataSize totalMemoryReservation;
    private final DataSize peakUserMemoryReservation;
    private final DataSize peakRevocableMemoryReservation;
    private final Duration totalScheduledTime;
    private final Duration failedScheduledTime;
    private final Duration totalCpuTime;
    private final Duration failedCpuTime;
    private final Duration totalBlockedTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final DataSize physicalInputDataSize;
    private final DataSize failedPhysicalInputDataSize;
    private final long physicalInputPositions;
    private final long failedPhysicalInputPositions;
    private final Duration physicalInputReadTime;
    private final Duration failedPhysicalInputReadTime;
    private final DataSize internalNetworkInputDataSize;
    private final DataSize failedInternalNetworkInputDataSize;
    private final long internalNetworkInputPositions;
    private final long failedInternalNetworkInputPositions;
    private final DataSize rawInputDataSize;
    private final DataSize failedRawInputDataSize;
    private final long rawInputPositions;
    private final long failedRawInputPositions;
    private final DataSize processedInputDataSize;
    private final DataSize failedProcessedInputDataSize;
    private final long processedInputPositions;
    private final long failedProcessedInputPositions;
    private final Duration inputBlockedTime;
    private final Duration failedInputBlockedTime;
    private final DataSize bufferedDataSize;
    private final DataSize outputDataSize;
    private final DataSize failedOutputDataSize;
    private final long outputPositions;
    private final long failedOutputPositions;
    private final Duration outputBlockedTime;
    private final Duration failedOutputBlockedTime;
    private final DataSize physicalWrittenDataSize;
    private final DataSize failedPhysicalWrittenDataSize;
    private final StageGcStatistics gcInfo;
    private final List<OperatorStats> operatorSummaries;

    @JsonCreator
    public StageStats(@JsonProperty(value="schedulingComplete") DateTime schedulingComplete, @JsonProperty(value="getSplitDistribution") Distribution.DistributionSnapshot getSplitDistribution, @JsonProperty(value="totalTasks") int totalTasks, @JsonProperty(value="runningTasks") int runningTasks, @JsonProperty(value="completedTasks") int completedTasks, @JsonProperty(value="failedTasks") int failedTasks, @JsonProperty(value="totalDrivers") int totalDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="blockedDrivers") int blockedDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="cumulativeUserMemory") double cumulativeUserMemory, @JsonProperty(value="failedCumulativeUserMemory") double failedCumulativeUserMemory, @JsonProperty(value="userMemoryReservation") DataSize userMemoryReservation, @JsonProperty(value="revocableMemoryReservation") DataSize revocableMemoryReservation, @JsonProperty(value="totalMemoryReservation") DataSize totalMemoryReservation, @JsonProperty(value="peakUserMemoryReservation") DataSize peakUserMemoryReservation, @JsonProperty(value="peakRevocableMemoryReservation") DataSize peakRevocableMemoryReservation, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="failedScheduledTime") Duration failedScheduledTime, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="failedCpuTime") Duration failedCpuTime, @JsonProperty(value="totalBlockedTime") Duration totalBlockedTime, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="physicalInputDataSize") DataSize physicalInputDataSize, @JsonProperty(value="failedPhysicalInputDataSize") DataSize failedPhysicalInputDataSize, @JsonProperty(value="physicalInputPositions") long physicalInputPositions, @JsonProperty(value="failedPhysicalInputPositions") long failedPhysicalInputPositions, @JsonProperty(value="physicalInputReadTime") Duration physicalInputReadTime, @JsonProperty(value="failedPhysicalInputReadTime") Duration failedPhysicalInputReadTime, @JsonProperty(value="internalNetworkInputDataSize") DataSize internalNetworkInputDataSize, @JsonProperty(value="failedInternalNetworkInputDataSize") DataSize failedInternalNetworkInputDataSize, @JsonProperty(value="internalNetworkInputPositions") long internalNetworkInputPositions, @JsonProperty(value="failedInternalNetworkInputPositions") long failedInternalNetworkInputPositions, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="failedRawInputDataSize") DataSize failedRawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="failedRawInputPositions") long failedRawInputPositions, @JsonProperty(value="processedInputDataSize") DataSize processedInputDataSize, @JsonProperty(value="failedProcessedInputDataSize") DataSize failedProcessedInputDataSize, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="failedProcessedInputPositions") long failedProcessedInputPositions, @JsonProperty(value="inputBlockedTime") Duration inputBlockedTime, @JsonProperty(value="failedInputBlockedTime") Duration failedInputBlockedTime, @JsonProperty(value="bufferedDataSize") DataSize bufferedDataSize, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="failedOutputDataSize") DataSize failedOutputDataSize, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="failedOutputPositions") long failedOutputPositions, @JsonProperty(value="outputBlockedTime") Duration outputBlockedTime, @JsonProperty(value="failedOutputBlockedTime") Duration failedOutputBlockedTime, @JsonProperty(value="physicalWrittenDataSize") DataSize physicalWrittenDataSize, @JsonProperty(value="failedPhysicalWrittenDataSize") DataSize failedPhysicalWrittenDataSize, @JsonProperty(value="gcInfo") StageGcStatistics gcInfo, @JsonProperty(value="operatorSummaries") List<OperatorStats> operatorSummaries) {
        this.schedulingComplete = schedulingComplete;
        this.getSplitDistribution = Objects.requireNonNull(getSplitDistribution, "getSplitDistribution is null");
        Preconditions.checkArgument((totalTasks >= 0 ? 1 : 0) != 0, (Object)"totalTasks is negative");
        this.totalTasks = totalTasks;
        Preconditions.checkArgument((runningTasks >= 0 ? 1 : 0) != 0, (Object)"runningTasks is negative");
        this.runningTasks = runningTasks;
        Preconditions.checkArgument((completedTasks >= 0 ? 1 : 0) != 0, (Object)"completedTasks is negative");
        this.completedTasks = completedTasks;
        Preconditions.checkArgument((failedTasks >= 0 ? 1 : 0) != 0, (Object)"failedTasks is negative");
        this.failedTasks = failedTasks;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is negative");
        this.totalDrivers = totalDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is negative");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is negative");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((blockedDrivers >= 0 ? 1 : 0) != 0, (Object)"blockedDrivers is negative");
        this.blockedDrivers = blockedDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is negative");
        this.completedDrivers = completedDrivers;
        Preconditions.checkArgument((cumulativeUserMemory >= 0.0 ? 1 : 0) != 0, (Object)"cumulativeUserMemory is negative");
        this.cumulativeUserMemory = cumulativeUserMemory;
        this.failedCumulativeUserMemory = failedCumulativeUserMemory;
        this.userMemoryReservation = Objects.requireNonNull(userMemoryReservation, "userMemoryReservation is null");
        this.revocableMemoryReservation = Objects.requireNonNull(revocableMemoryReservation, "revocableMemoryReservation is null");
        this.totalMemoryReservation = Objects.requireNonNull(totalMemoryReservation, "totalMemoryReservation is null");
        this.peakUserMemoryReservation = Objects.requireNonNull(peakUserMemoryReservation, "peakUserMemoryReservation is null");
        this.peakRevocableMemoryReservation = Objects.requireNonNull(peakRevocableMemoryReservation, "peakRevocableMemoryReservation is null");
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.failedScheduledTime = Objects.requireNonNull(failedScheduledTime, "failedScheduledTime is null");
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.failedCpuTime = Objects.requireNonNull(failedCpuTime, "failedCpuTime is null");
        this.totalBlockedTime = Objects.requireNonNull(totalBlockedTime, "totalBlockedTime is null");
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.physicalInputDataSize = Objects.requireNonNull(physicalInputDataSize, "physicalInputDataSize is null");
        this.failedPhysicalInputDataSize = Objects.requireNonNull(failedPhysicalInputDataSize, "failedPhysicalInputDataSize is null");
        Preconditions.checkArgument((physicalInputPositions >= 0L ? 1 : 0) != 0, (Object)"physicalInputPositions is negative");
        this.physicalInputPositions = physicalInputPositions;
        Preconditions.checkArgument((failedPhysicalInputPositions >= 0L ? 1 : 0) != 0, (Object)"failedPhysicalInputPositions is negative");
        this.failedPhysicalInputPositions = failedPhysicalInputPositions;
        this.physicalInputReadTime = Objects.requireNonNull(physicalInputReadTime, "physicalInputReadTime is null");
        this.failedPhysicalInputReadTime = Objects.requireNonNull(failedPhysicalInputReadTime, "failedPhysicalInputReadTime is null");
        this.internalNetworkInputDataSize = Objects.requireNonNull(internalNetworkInputDataSize, "internalNetworkInputDataSize is null");
        this.failedInternalNetworkInputDataSize = Objects.requireNonNull(failedInternalNetworkInputDataSize, "failedInternalNetworkInputDataSize is null");
        Preconditions.checkArgument((internalNetworkInputPositions >= 0L ? 1 : 0) != 0, (Object)"internalNetworkInputPositions is negative");
        this.internalNetworkInputPositions = internalNetworkInputPositions;
        Preconditions.checkArgument((failedInternalNetworkInputPositions >= 0L ? 1 : 0) != 0, (Object)"failedInternalNetworkInputPositions is negative");
        this.failedInternalNetworkInputPositions = failedInternalNetworkInputPositions;
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        this.failedRawInputDataSize = Objects.requireNonNull(failedRawInputDataSize, "failedRawInputDataSize is null");
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        Preconditions.checkArgument((failedRawInputPositions >= 0L ? 1 : 0) != 0, (Object)"failedRawInputPositions is negative");
        this.failedRawInputPositions = failedRawInputPositions;
        this.processedInputDataSize = Objects.requireNonNull(processedInputDataSize, "processedInputDataSize is null");
        this.failedProcessedInputDataSize = Objects.requireNonNull(failedProcessedInputDataSize, "failedProcessedInputDataSize is null");
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        Preconditions.checkArgument((failedProcessedInputPositions >= 0L ? 1 : 0) != 0, (Object)"failedProcessedInputPositions is negative");
        this.failedProcessedInputPositions = failedProcessedInputPositions;
        this.inputBlockedTime = Objects.requireNonNull(inputBlockedTime, "inputBlockedTime is null");
        this.failedInputBlockedTime = Objects.requireNonNull(failedInputBlockedTime, "failedInputBlockedTime is null");
        this.bufferedDataSize = Objects.requireNonNull(bufferedDataSize, "bufferedDataSize is null");
        this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        this.failedOutputDataSize = Objects.requireNonNull(failedOutputDataSize, "failedOutputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        Preconditions.checkArgument((failedOutputPositions >= 0L ? 1 : 0) != 0, (Object)"failedOutputPositions is negative");
        this.failedOutputPositions = failedOutputPositions;
        this.outputBlockedTime = Objects.requireNonNull(outputBlockedTime, "outputBlockedTime is null");
        this.failedOutputBlockedTime = Objects.requireNonNull(failedOutputBlockedTime, "failedOutputBlockedTime is null");
        this.physicalWrittenDataSize = Objects.requireNonNull(physicalWrittenDataSize, "physicalWrittenDataSize is null");
        this.failedPhysicalWrittenDataSize = Objects.requireNonNull(failedPhysicalWrittenDataSize, "failedPhysicalWrittenDataSize is null");
        this.gcInfo = Objects.requireNonNull(gcInfo, "gcInfo is null");
        this.operatorSummaries = ImmutableList.copyOf((Collection)Objects.requireNonNull(operatorSummaries, "operatorSummaries is null"));
    }

    @JsonProperty
    public DateTime getSchedulingComplete() {
        return this.schedulingComplete;
    }

    @JsonProperty
    public Distribution.DistributionSnapshot getGetSplitDistribution() {
        return this.getSplitDistribution;
    }

    @JsonProperty
    public int getTotalTasks() {
        return this.totalTasks;
    }

    @JsonProperty
    public int getRunningTasks() {
        return this.runningTasks;
    }

    @JsonProperty
    public int getCompletedTasks() {
        return this.completedTasks;
    }

    @JsonProperty
    public int getFailedTasks() {
        return this.failedTasks;
    }

    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    public int getBlockedDrivers() {
        return this.blockedDrivers;
    }

    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    public double getCumulativeUserMemory() {
        return this.cumulativeUserMemory;
    }

    @JsonProperty
    public double getFailedCumulativeUserMemory() {
        return this.failedCumulativeUserMemory;
    }

    @JsonProperty
    public DataSize getUserMemoryReservation() {
        return this.userMemoryReservation;
    }

    @JsonProperty
    public DataSize getRevocableMemoryReservation() {
        return this.revocableMemoryReservation;
    }

    @JsonProperty
    public DataSize getTotalMemoryReservation() {
        return this.totalMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakUserMemoryReservation() {
        return this.peakUserMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakRevocableMemoryReservation() {
        return this.peakRevocableMemoryReservation;
    }

    @JsonProperty
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @JsonProperty
    public Duration getFailedScheduledTime() {
        return this.failedScheduledTime;
    }

    @JsonProperty
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @JsonProperty
    public Duration getFailedCpuTime() {
        return this.failedCpuTime;
    }

    @JsonProperty
    public Duration getTotalBlockedTime() {
        return this.totalBlockedTime;
    }

    @JsonProperty
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    public DataSize getPhysicalInputDataSize() {
        return this.physicalInputDataSize;
    }

    @JsonProperty
    public DataSize getFailedPhysicalInputDataSize() {
        return this.failedPhysicalInputDataSize;
    }

    @JsonProperty
    public long getPhysicalInputPositions() {
        return this.physicalInputPositions;
    }

    @JsonProperty
    public long getFailedPhysicalInputPositions() {
        return this.failedPhysicalInputPositions;
    }

    @JsonProperty
    public Duration getPhysicalInputReadTime() {
        return this.physicalInputReadTime;
    }

    @JsonProperty
    public Duration getFailedPhysicalInputReadTime() {
        return this.failedPhysicalInputReadTime;
    }

    @JsonProperty
    public DataSize getInternalNetworkInputDataSize() {
        return this.internalNetworkInputDataSize;
    }

    @JsonProperty
    public DataSize getFailedInternalNetworkInputDataSize() {
        return this.failedInternalNetworkInputDataSize;
    }

    @JsonProperty
    public long getInternalNetworkInputPositions() {
        return this.internalNetworkInputPositions;
    }

    @JsonProperty
    public long getFailedInternalNetworkInputPositions() {
        return this.failedInternalNetworkInputPositions;
    }

    @JsonProperty
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @JsonProperty
    public DataSize getFailedRawInputDataSize() {
        return this.failedRawInputDataSize;
    }

    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    public long getFailedRawInputPositions() {
        return this.failedRawInputPositions;
    }

    @JsonProperty
    public DataSize getProcessedInputDataSize() {
        return this.processedInputDataSize;
    }

    @JsonProperty
    public DataSize getFailedProcessedInputDataSize() {
        return this.failedProcessedInputDataSize;
    }

    @JsonProperty
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    public long getFailedProcessedInputPositions() {
        return this.failedProcessedInputPositions;
    }

    @JsonProperty
    public Duration getInputBlockedTime() {
        return this.inputBlockedTime;
    }

    @JsonProperty
    public Duration getFailedInputBlockedTime() {
        return this.failedInputBlockedTime;
    }

    @JsonProperty
    public DataSize getBufferedDataSize() {
        return this.bufferedDataSize;
    }

    @JsonProperty
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    public DataSize getFailedOutputDataSize() {
        return this.failedOutputDataSize;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    public long getFailedOutputPositions() {
        return this.failedOutputPositions;
    }

    @JsonProperty
    public Duration getOutputBlockedTime() {
        return this.outputBlockedTime;
    }

    @JsonProperty
    public Duration getFailedOutputBlockedTime() {
        return this.failedOutputBlockedTime;
    }

    @JsonProperty
    public DataSize getPhysicalWrittenDataSize() {
        return this.physicalWrittenDataSize;
    }

    @JsonProperty
    public DataSize getFailedPhysicalWrittenDataSize() {
        return this.failedPhysicalWrittenDataSize;
    }

    @JsonProperty
    public StageGcStatistics getGcInfo() {
        return this.gcInfo;
    }

    @JsonProperty
    public List<OperatorStats> getOperatorSummaries() {
        return this.operatorSummaries;
    }

    public BasicStageStats toBasicStageStats(StageState stageState) {
        boolean isScheduled = stageState == StageState.RUNNING || stageState == StageState.PENDING || stageState.isDone();
        OptionalDouble progressPercentage = OptionalDouble.empty();
        if (isScheduled && this.totalDrivers != 0) {
            progressPercentage = OptionalDouble.of(Math.min(100.0, (double)this.completedDrivers * 100.0 / (double)this.totalDrivers));
        }
        return new BasicStageStats(isScheduled, this.totalDrivers, this.queuedDrivers, this.runningDrivers, this.completedDrivers, this.physicalInputDataSize, this.physicalInputPositions, this.physicalInputReadTime, this.internalNetworkInputDataSize, this.internalNetworkInputPositions, this.rawInputDataSize, this.rawInputPositions, (long)this.cumulativeUserMemory, (long)this.failedCumulativeUserMemory, this.userMemoryReservation, this.totalMemoryReservation, this.totalCpuTime, this.failedCpuTime, this.totalScheduledTime, this.failedScheduledTime, this.fullyBlocked, this.blockedReasons, progressPercentage);
    }
}

