/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.scheduler.FallbackToFullNodePartitionMemoryEstimator;
import io.trino.execution.scheduler.NodeAllocator;
import io.trino.execution.scheduler.NodeAllocatorService;
import io.trino.execution.scheduler.NodeRequirements;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.memory.ClusterMemoryManager;
import io.trino.memory.MemoryInfo;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.NodeState;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.assertj.core.util.VisibleForTesting;

@ThreadSafe
public class FullNodeCapableNodeAllocatorService
implements NodeAllocatorService {
    private static final Logger log = Logger.get(FullNodeCapableNodeAllocatorService.class);
    @VisibleForTesting
    static final int PROCESS_PENDING_ACQUIRES_DELAY_SECONDS = 5;
    private final InternalNodeManager nodeManager;
    private final Supplier<Map<String, Optional<MemoryInfo>>> workerMemoryInfoSupplier;
    private final int maxAbsoluteFullNodesPerQuery;
    private final double maxFractionFullNodesPerQuery;
    private final List<PendingAcquire> sharedPendingAcquires = new LinkedList<PendingAcquire>();
    private final Map<InternalNode, PendingAcquire> fullNodePendingAcquires = new HashMap<InternalNode, PendingAcquire>();
    private final Deque<PendingAcquire> detachedFullNodePendingAcquires = new ArrayDeque<PendingAcquire>();
    private final ConcurrentMap<InternalNode, Long> sharedAllocatedMemory = new ConcurrentHashMap<InternalNode, Long>();
    private final Set<InternalNode> allocatedFullNodes = new HashSet<InternalNode>();
    private final Multimap<QueryId, InternalNode> fullNodesByQueryId = HashMultimap.create();
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(2, Threads.daemonThreadsNamed((String)"bin-packing-node-allocator"));
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final Semaphore processSemaphore = new Semaphore(0);
    private final ConcurrentMap<String, Long> nodePoolSizes = new ConcurrentHashMap<String, Long>();
    private final AtomicLong maxNodePoolSize = new AtomicLong(FallbackToFullNodePartitionMemoryEstimator.FULL_NODE_MEMORY.toBytes());
    private final boolean scheduleOnCoordinator;

    @Inject
    public FullNodeCapableNodeAllocatorService(InternalNodeManager nodeManager, ClusterMemoryManager clusterMemoryManager, NodeSchedulerConfig config) {
        this(nodeManager, Objects.requireNonNull(clusterMemoryManager, "clusterMemoryManager is null")::getWorkerMemoryInfo, config.getMaxAbsoluteFullNodesPerQuery(), config.getMaxFractionFullNodesPerQuery(), config.isIncludeCoordinator());
    }

    @VisibleForTesting
    FullNodeCapableNodeAllocatorService(InternalNodeManager nodeManager, Supplier<Map<String, Optional<MemoryInfo>>> workerMemoryInfoSupplier, int maxAbsoluteFullNodesPerQuery, double maxFractionFullNodesPerQuery, boolean scheduleOnCoordinator) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.workerMemoryInfoSupplier = Objects.requireNonNull(workerMemoryInfoSupplier, "workerMemoryInfoSupplier is null");
        this.maxAbsoluteFullNodesPerQuery = maxAbsoluteFullNodesPerQuery;
        this.maxFractionFullNodesPerQuery = maxFractionFullNodesPerQuery;
        this.scheduleOnCoordinator = scheduleOnCoordinator;
    }

    private void refreshNodePoolSizes() {
        Map<String, Optional<MemoryInfo>> workerMemoryInfo = this.workerMemoryInfoSupplier.get();
        for (String key : this.nodePoolSizes.keySet()) {
            if (workerMemoryInfo.containsKey(key)) continue;
            this.nodePoolSizes.remove(key);
        }
        long tmpMaxNodePoolSize = 0L;
        for (Map.Entry<String, Optional<MemoryInfo>> entry : workerMemoryInfo.entrySet()) {
            Optional<MemoryInfo> memoryInfo = entry.getValue();
            if (memoryInfo.isEmpty()) continue;
            long nodePoolSize = memoryInfo.get().getPool().getMaxBytes();
            this.nodePoolSizes.put(entry.getKey(), nodePoolSize);
            tmpMaxNodePoolSize = Math.max(tmpMaxNodePoolSize, nodePoolSize);
        }
        if (tmpMaxNodePoolSize == 0L) {
            tmpMaxNodePoolSize = FallbackToFullNodePartitionMemoryEstimator.FULL_NODE_MEMORY.toBytes();
        }
        this.maxNodePoolSize.set(tmpMaxNodePoolSize);
    }

    private Optional<Long> getNodePoolSize(InternalNode internalNode) {
        return Optional.ofNullable((Long)this.nodePoolSizes.get(internalNode.getNodeIdentifier()));
    }

    @PostConstruct
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.executor.schedule(() -> {
                while (!this.stopped.get()) {
                    try {
                        this.processSemaphore.tryAcquire(5L, TimeUnit.SECONDS);
                        this.processSemaphore.drainPermits();
                        this.processPendingAcquires();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        log.warn((Throwable)e, "Error updating nodes");
                    }
                }
            }, 0L, TimeUnit.SECONDS);
        }
        this.refreshNodePoolSizes();
        this.executor.scheduleWithFixedDelay(this::refreshNodePoolSizes, 1L, 1L, TimeUnit.SECONDS);
    }

    @VisibleForTesting
    void wakeupProcessPendingAcquires() {
        this.processSemaphore.release();
    }

    @VisibleForTesting
    void processPendingAcquires() {
        this.processFullNodePendingAcquires();
        this.processSharedPendingAcquires();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSharedPendingAcquires() {
        IdentityHashMap<PendingAcquire, InternalNode> assignedNodes = new IdentityHashMap<PendingAcquire, InternalNode>();
        IdentityHashMap<PendingAcquire, RuntimeException> failures = new IdentityHashMap<PendingAcquire, RuntimeException>();
        FullNodeCapableNodeAllocatorService fullNodeCapableNodeAllocatorService = this;
        synchronized (fullNodeCapableNodeAllocatorService) {
            Iterator<PendingAcquire> iterator = this.sharedPendingAcquires.iterator();
            while (iterator.hasNext()) {
                PendingAcquire pendingAcquire2 = iterator.next();
                if (pendingAcquire2.getFuture().isCancelled()) {
                    iterator.remove();
                    continue;
                }
                if (pendingAcquire2.getNodeRequirements().getMemory().toBytes() > this.maxNodePoolSize.get()) {
                    iterator.remove();
                    this.detachedFullNodePendingAcquires.add(pendingAcquire2);
                    continue;
                }
                try {
                    Candidates candidates = this.selectCandidates(pendingAcquire2.getNodeRequirements());
                    if (candidates.isEmpty()) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
                    }
                    Optional<InternalNode> node2 = this.tryAcquireSharedNode(candidates, pendingAcquire2.getMemoryLease());
                    if (!node2.isPresent()) continue;
                    iterator.remove();
                    assignedNodes.put(pendingAcquire2, node2.get());
                }
                catch (RuntimeException e) {
                    iterator.remove();
                    failures.put(pendingAcquire2, e);
                }
            }
        }
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Cannot complete node futures under lock");
        assignedNodes.forEach((pendingAcquire, node) -> {
            SettableFuture<InternalNode> future = pendingAcquire.getFuture();
            future.set(node);
            if (future.isCancelled()) {
                this.releaseSharedNode((InternalNode)node, pendingAcquire.getMemoryLease());
            }
        });
        failures.forEach((pendingAcquire, failure) -> {
            SettableFuture<InternalNode> future = pendingAcquire.getFuture();
            future.setException((Throwable)failure);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFullNodePendingAcquires() {
        IdentityHashMap<PendingAcquire, InternalNode> assignedNodes = new IdentityHashMap<PendingAcquire, InternalNode>();
        IdentityHashMap<PendingAcquire, RuntimeException> failures = new IdentityHashMap<PendingAcquire, RuntimeException>();
        FullNodeCapableNodeAllocatorService fullNodeCapableNodeAllocatorService = this;
        synchronized (fullNodeCapableNodeAllocatorService) {
            Iterator<PendingAcquire> detachedIterator = this.detachedFullNodePendingAcquires.iterator();
            while (detachedIterator.hasNext()) {
                PendingAcquire pendingAcquire2 = detachedIterator.next();
                try {
                    if (pendingAcquire2.getFuture().isCancelled()) {
                        detachedIterator.remove();
                        continue;
                    }
                    Candidates currentCandidates = this.selectCandidates(pendingAcquire2.getNodeRequirements());
                    if (currentCandidates.isEmpty()) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
                    }
                    Optional<InternalNode> target = this.findTargetPendingFullNode(pendingAcquire2.getQueryId(), currentCandidates);
                    if (target.isEmpty()) continue;
                    this.fullNodePendingAcquires.put(target.get(), pendingAcquire2);
                    this.fullNodesByQueryId.put((Object)pendingAcquire2.getQueryId(), (Object)target.get());
                    detachedIterator.remove();
                }
                catch (RuntimeException e) {
                    failures.put(pendingAcquire2, e);
                    detachedIterator.remove();
                }
            }
            ImmutableSet nodes = ImmutableSet.copyOf(this.fullNodePendingAcquires.keySet());
            for (InternalNode reservedNode : nodes) {
                PendingAcquire pendingAcquire3 = this.fullNodePendingAcquires.get(reservedNode);
                if (pendingAcquire3.getFuture().isCancelled()) {
                    this.fullNodePendingAcquires.remove(reservedNode);
                    Verify.verify((boolean)this.fullNodesByQueryId.remove((Object)pendingAcquire3.getQueryId(), (Object)reservedNode));
                    continue;
                }
                try {
                    Candidates currentCandidates = this.selectCandidates(pendingAcquire3.getNodeRequirements());
                    if (currentCandidates.isEmpty()) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
                    }
                    if (this.sharedAllocatedMemory.getOrDefault(reservedNode, 0L) > 0L || this.allocatedFullNodes.contains(reservedNode)) {
                        Optional<InternalNode> opportunisticNode = currentCandidates.getCandidates().stream().filter(node -> !this.fullNodePendingAcquires.containsKey(node)).filter(node -> !this.allocatedFullNodes.contains(node)).filter(node -> this.sharedAllocatedMemory.getOrDefault(node, 0L) == 0L).findFirst();
                        if (!opportunisticNode.isPresent()) continue;
                        this.fullNodePendingAcquires.remove(reservedNode);
                        Verify.verify((boolean)this.fullNodesByQueryId.remove((Object)pendingAcquire3.getQueryId(), (Object)reservedNode));
                        this.allocatedFullNodes.add(opportunisticNode.get());
                        Verify.verify((boolean)this.fullNodesByQueryId.put((Object)pendingAcquire3.getQueryId(), (Object)opportunisticNode.get()));
                        assignedNodes.put(pendingAcquire3, opportunisticNode.get());
                        continue;
                    }
                    if (!currentCandidates.getCandidates().contains(reservedNode)) {
                        this.detachedFullNodePendingAcquires.add(pendingAcquire3);
                        this.fullNodePendingAcquires.remove(reservedNode);
                        Verify.verify((boolean)this.fullNodesByQueryId.remove((Object)pendingAcquire3.getQueryId(), (Object)reservedNode));
                        this.wakeupProcessPendingAcquires();
                        continue;
                    }
                    this.allocatedFullNodes.add(reservedNode);
                    this.fullNodePendingAcquires.remove(reservedNode);
                    assignedNodes.put(pendingAcquire3, reservedNode);
                }
                catch (RuntimeException e) {
                    failures.put(pendingAcquire3, e);
                    this.fullNodePendingAcquires.remove(reservedNode);
                    this.fullNodesByQueryId.remove((Object)pendingAcquire3.getQueryId(), (Object)reservedNode);
                }
            }
        }
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Cannot complete node futures under lock");
        assignedNodes.forEach((pendingAcquire, node) -> {
            SettableFuture<InternalNode> future = pendingAcquire.getFuture();
            future.set(node);
            if (future.isCancelled()) {
                this.releaseFullNode((InternalNode)node, pendingAcquire.getQueryId());
            }
        });
        failures.forEach((pendingAcquire, failure) -> {
            SettableFuture<InternalNode> future = pendingAcquire.getFuture();
            future.setException((Throwable)failure);
        });
    }

    @PreDestroy
    public void stop() {
        this.stopped.set(true);
        this.executor.shutdownNow();
    }

    public synchronized Optional<InternalNode> tryAcquire(NodeRequirements requirements, Candidates candidates, QueryId queryId) {
        if (this.isFullNode(requirements)) {
            return this.tryAcquireFullNode(candidates, queryId);
        }
        return this.tryAcquireSharedNode(candidates, requirements.getMemory().toBytes());
    }

    @VisibleForTesting
    synchronized Set<InternalNode> getPendingFullNodes() {
        return ImmutableSet.copyOf(this.fullNodePendingAcquires.keySet());
    }

    private synchronized Optional<InternalNode> tryAcquireFullNode(Candidates candidates, QueryId queryId) {
        Collection queryFullNodes = this.fullNodesByQueryId.get((Object)queryId);
        if (this.fullNodesCountExceeded(queryFullNodes.size(), candidates.getAllNodesCount())) {
            return Optional.empty();
        }
        Optional<InternalNode> selectedNode = candidates.getCandidates().stream().filter(node -> this.getNodePoolSize((InternalNode)node).isPresent()).filter(node -> this.sharedAllocatedMemory.getOrDefault(node, 0L) == 0L).filter(node -> !this.allocatedFullNodes.contains(node)).filter(node -> !this.fullNodePendingAcquires.containsKey(node)).findFirst();
        selectedNode.ifPresent(node -> {
            this.allocatedFullNodes.add((InternalNode)node);
            this.fullNodesByQueryId.put((Object)queryId, node);
        });
        return selectedNode;
    }

    private boolean fullNodesCountExceeded(int currentCount, int candidatesCount) {
        long threshold = Integer.min(this.maxAbsoluteFullNodesPerQuery, (int)((double)candidatesCount * this.maxFractionFullNodesPerQuery));
        return (long)currentCount >= threshold;
    }

    private synchronized Optional<InternalNode> tryAcquireSharedNode(Candidates candidates, long memoryLease) {
        Optional<InternalNode> selectedNode = candidates.getCandidates().stream().filter(node -> this.getNodePoolSize((InternalNode)node).map(poolSize -> poolSize - this.sharedAllocatedMemory.getOrDefault(node, 0L) >= memoryLease).orElse(false)).filter(node -> !this.allocatedFullNodes.contains(node)).filter(node -> !this.fullNodePendingAcquires.containsKey(node)).min(Comparator.comparing(node -> this.sharedAllocatedMemory.getOrDefault(node, 0L)));
        selectedNode.ifPresent(node -> this.sharedAllocatedMemory.merge((InternalNode)node, memoryLease, Long::sum));
        return selectedNode;
    }

    private synchronized PendingAcquire registerPendingAcquire(NodeRequirements requirements, Candidates candidates, QueryId queryId) {
        PendingAcquire pendingAcquire = new PendingAcquire(requirements, queryId);
        if (this.isFullNode(requirements)) {
            Optional<InternalNode> targetNode = this.findTargetPendingFullNode(queryId, candidates);
            if (targetNode.isEmpty()) {
                this.detachedFullNodePendingAcquires.add(pendingAcquire);
            } else {
                Verify.verify((!this.fullNodePendingAcquires.containsKey(targetNode.get()) ? 1 : 0) != 0);
                Verify.verify((!this.fullNodesByQueryId.get((Object)queryId).contains(targetNode.get()) ? 1 : 0) != 0);
                this.fullNodePendingAcquires.put(targetNode.get(), pendingAcquire);
                this.fullNodesByQueryId.put((Object)queryId, (Object)targetNode.get());
            }
        } else {
            this.sharedPendingAcquires.add(pendingAcquire);
        }
        return pendingAcquire;
    }

    private Optional<InternalNode> findTargetPendingFullNode(QueryId queryId, Candidates candidates) {
        Collection queryFullNodes = this.fullNodesByQueryId.get((Object)queryId);
        if (this.fullNodesCountExceeded(queryFullNodes.size(), candidates.getAllNodesCount())) {
            return Optional.empty();
        }
        return candidates.getCandidates().stream().filter(Predicate.not(queryFullNodes::contains)).filter(Predicate.not(this.fullNodePendingAcquires::containsKey)).min(Comparator.comparing(node -> this.sharedAllocatedMemory.getOrDefault(node, 0L)));
    }

    private synchronized void releaseFullNode(InternalNode node, QueryId queryId) {
        Verify.verify((boolean)this.allocatedFullNodes.remove(node), (String)"no %s node in allocatedFullNodes", (Object)node);
        Verify.verify((boolean)this.fullNodesByQueryId.remove((Object)queryId, (Object)node), (String)"no %s/%s pair in fullNodesByQueryId", (Object)queryId, (Object)node);
        this.wakeupProcessPendingAcquires();
    }

    private synchronized void releaseSharedNode(InternalNode node, long memoryLease) {
        this.sharedAllocatedMemory.compute(node, (key, value) -> {
            Verify.verify((value != null && value >= memoryLease ? 1 : 0) != 0, (String)"invalid memory allocation record %s for node %s", (Object)value, (Object)key);
            long newValue = value - memoryLease;
            if (newValue > 0L) {
                return newValue;
            }
            return null;
        });
        this.wakeupProcessPendingAcquires();
    }

    @Override
    public NodeAllocator getNodeAllocator(Session session) {
        return new FullNodeCapableNodeAllocator(session);
    }

    private Candidates selectCandidates(NodeRequirements requirements) {
        Set<InternalNode> allNodes = this.getAllNodes(requirements.getCatalogName());
        return new Candidates(allNodes.size(), (List)allNodes.stream().filter(node -> {
            if (requirements.getAddresses().contains(node.getHostAndPort())) {
                return true;
            }
            if (requirements.getAddresses().isEmpty()) {
                return this.scheduleOnCoordinator || !node.isCoordinator();
            }
            return false;
        }).collect(ImmutableList.toImmutableList()));
    }

    private Set<InternalNode> getAllNodes(Optional<CatalogName> catalogName) {
        Set<InternalNode> activeNodes = catalogName.isPresent() ? this.nodeManager.getActiveConnectorNodes(catalogName.get()) : this.nodeManager.getNodes(NodeState.ACTIVE);
        return activeNodes;
    }

    private boolean isFullNode(NodeRequirements requirements) {
        return requirements.getMemory().toBytes() >= this.maxNodePoolSize.get();
    }

    private class FullNodeCapableNodeLease
    implements NodeAllocator.NodeLease {
        private final ListenableFuture<InternalNode> node;
        private final AtomicBoolean released = new AtomicBoolean();
        private final long memoryLease;
        private final boolean fullNode;
        private final QueryId queryId;

        private FullNodeCapableNodeLease(ListenableFuture<InternalNode> node, long memoryLease, boolean fullNode, QueryId queryId) {
            this.node = Objects.requireNonNull(node, "node is null");
            this.memoryLease = memoryLease;
            this.fullNode = fullNode;
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        }

        @Override
        public ListenableFuture<InternalNode> getNode() {
            return this.node;
        }

        @Override
        public void release() {
            if (this.released.compareAndSet(false, true)) {
                this.node.cancel(true);
                if (this.node.isDone() && !this.node.isCancelled()) {
                    if (this.fullNode) {
                        FullNodeCapableNodeAllocatorService.this.releaseFullNode((InternalNode)MoreFutures.getFutureValue(this.node), this.queryId);
                    } else {
                        FullNodeCapableNodeAllocatorService.this.releaseSharedNode((InternalNode)MoreFutures.getFutureValue(this.node), this.memoryLease);
                    }
                }
            } else {
                throw new IllegalStateException("Node " + this.node + " already released");
            }
        }
    }

    private static class PendingAcquire {
        private final NodeRequirements nodeRequirements;
        private final SettableFuture<InternalNode> future;
        private final QueryId queryId;

        private PendingAcquire(NodeRequirements nodeRequirements, QueryId queryId) {
            this.nodeRequirements = Objects.requireNonNull(nodeRequirements, "nodeRequirements is null");
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.future = SettableFuture.create();
        }

        public NodeRequirements getNodeRequirements() {
            return this.nodeRequirements;
        }

        public QueryId getQueryId() {
            return this.queryId;
        }

        public SettableFuture<InternalNode> getFuture() {
            return this.future;
        }

        public long getMemoryLease() {
            return this.nodeRequirements.getMemory().toBytes();
        }
    }

    private class FullNodeCapableNodeAllocator
    implements NodeAllocator {
        @GuardedBy(value="this")
        private final Session session;

        public FullNodeCapableNodeAllocator(Session session) {
            this.session = Objects.requireNonNull(session, "session is null");
        }

        @Override
        public NodeAllocator.NodeLease acquire(NodeRequirements requirements) {
            Candidates candidates = FullNodeCapableNodeAllocatorService.this.selectCandidates(requirements);
            if (candidates.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
            }
            QueryId queryId = this.session.getQueryId();
            Optional<InternalNode> selectedNode = FullNodeCapableNodeAllocatorService.this.tryAcquire(requirements, candidates, queryId);
            if (selectedNode.isPresent()) {
                return new FullNodeCapableNodeLease((ListenableFuture<InternalNode>)Futures.immediateFuture((Object)selectedNode.get()), requirements.getMemory().toBytes(), FullNodeCapableNodeAllocatorService.this.isFullNode(requirements), queryId);
            }
            PendingAcquire pendingAcquire = FullNodeCapableNodeAllocatorService.this.registerPendingAcquire(requirements, candidates, queryId);
            return new FullNodeCapableNodeLease((ListenableFuture<InternalNode>)pendingAcquire.getFuture(), requirements.getMemory().toBytes(), FullNodeCapableNodeAllocatorService.this.isFullNode(requirements), queryId);
        }

        @Override
        public void close() {
        }
    }

    private static class Candidates {
        private final int allNodesCount;
        private final List<InternalNode> candidates;

        public Candidates(int allNodesCount, List<InternalNode> candidates) {
            this.allNodesCount = allNodesCount;
            this.candidates = candidates;
        }

        public int getAllNodesCount() {
            return this.allNodesCount;
        }

        public List<InternalNode> getCandidates() {
            return this.candidates;
        }

        public boolean isEmpty() {
            return this.candidates.isEmpty();
        }
    }
}

