/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import java.util.Locale;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"node-scheduler.location-aware-scheduling-enabled", "node-scheduler.multiple-tasks-per-node-enabled"})
public class NodeSchedulerConfig {
    private int minCandidates = 10;
    private boolean includeCoordinator = true;
    private int maxSplitsPerNode = 100;
    private int maxPendingSplitsPerTask = 10;
    private NodeSchedulerPolicy nodeSchedulerPolicy = NodeSchedulerPolicy.UNIFORM;
    private boolean optimizedLocalScheduling = true;
    private SplitsBalancingPolicy splitsBalancingPolicy = SplitsBalancingPolicy.STAGE;
    private int maxUnacknowledgedSplitsPerTask = 500;
    private int maxAbsoluteFullNodesPerQuery = Integer.MAX_VALUE;
    private double maxFractionFullNodesPerQuery = 0.5;
    private NodeAllocatorType nodeAllocatorType = NodeAllocatorType.BIN_PACKING;

    @NotNull
    public NodeSchedulerPolicy getNodeSchedulerPolicy() {
        return this.nodeSchedulerPolicy;
    }

    @LegacyConfig(value={"node-scheduler.network-topology"})
    @Config(value="node-scheduler.policy")
    public NodeSchedulerConfig setNodeSchedulerPolicy(String nodeSchedulerPolicy) {
        this.nodeSchedulerPolicy = NodeSchedulerConfig.toNodeSchedulerPolicy(nodeSchedulerPolicy);
        return this;
    }

    private static NodeSchedulerPolicy toNodeSchedulerPolicy(String nodeSchedulerPolicy) {
        switch (nodeSchedulerPolicy.toLowerCase(Locale.ENGLISH)) {
            case "legacy": 
            case "uniform": {
                return NodeSchedulerPolicy.UNIFORM;
            }
            case "flat": 
            case "topology": {
                return NodeSchedulerPolicy.TOPOLOGY;
            }
        }
        throw new IllegalArgumentException("Unknown node scheduler policy: " + nodeSchedulerPolicy);
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinCandidates() {
        return this.minCandidates;
    }

    @Config(value="node-scheduler.min-candidates")
    public NodeSchedulerConfig setMinCandidates(int candidates) {
        this.minCandidates = candidates;
        return this;
    }

    public boolean isIncludeCoordinator() {
        return this.includeCoordinator;
    }

    @Config(value="node-scheduler.include-coordinator")
    public NodeSchedulerConfig setIncludeCoordinator(boolean includeCoordinator) {
        this.includeCoordinator = includeCoordinator;
        return this;
    }

    @Config(value="node-scheduler.max-pending-splits-per-task")
    @LegacyConfig(value={"node-scheduler.max-pending-splits-per-node-per-task", "node-scheduler.max-pending-splits-per-node-per-stage"})
    public NodeSchedulerConfig setMaxPendingSplitsPerTask(int maxPendingSplitsPerTask) {
        this.maxPendingSplitsPerTask = maxPendingSplitsPerTask;
        return this;
    }

    public int getMaxPendingSplitsPerTask() {
        return this.maxPendingSplitsPerTask;
    }

    public int getMaxSplitsPerNode() {
        return this.maxSplitsPerNode;
    }

    @Config(value="node-scheduler.max-splits-per-node")
    public NodeSchedulerConfig setMaxSplitsPerNode(int maxSplitsPerNode) {
        this.maxSplitsPerNode = maxSplitsPerNode;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxUnacknowledgedSplitsPerTask() {
        return this.maxUnacknowledgedSplitsPerTask;
    }

    @Config(value="node-scheduler.max-unacknowledged-splits-per-task")
    @ConfigDescription(value="Maximum number of leaf splits not yet delivered to a given task")
    public NodeSchedulerConfig setMaxUnacknowledgedSplitsPerTask(int maxUnacknowledgedSplitsPerTask) {
        this.maxUnacknowledgedSplitsPerTask = maxUnacknowledgedSplitsPerTask;
        return this;
    }

    @NotNull
    public SplitsBalancingPolicy getSplitsBalancingPolicy() {
        return this.splitsBalancingPolicy;
    }

    @Config(value="node-scheduler.splits-balancing-policy")
    @ConfigDescription(value="Strategy for balancing new splits on worker nodes")
    public NodeSchedulerConfig setSplitsBalancingPolicy(SplitsBalancingPolicy splitsBalancingPolicy) {
        this.splitsBalancingPolicy = splitsBalancingPolicy;
        return this;
    }

    public boolean getOptimizedLocalScheduling() {
        return this.optimizedLocalScheduling;
    }

    @Config(value="node-scheduler.optimized-local-scheduling")
    public NodeSchedulerConfig setOptimizedLocalScheduling(boolean optimizedLocalScheduling) {
        this.optimizedLocalScheduling = optimizedLocalScheduling;
        return this;
    }

    @Config(value="node-scheduler.max-absolute-full-nodes-per-query")
    public NodeSchedulerConfig setMaxAbsoluteFullNodesPerQuery(int maxAbsoluteFullNodesPerQuery) {
        this.maxAbsoluteFullNodesPerQuery = maxAbsoluteFullNodesPerQuery;
        return this;
    }

    public int getMaxAbsoluteFullNodesPerQuery() {
        return this.maxAbsoluteFullNodesPerQuery;
    }

    @Config(value="node-scheduler.max-fraction-full-nodes-per-query")
    public NodeSchedulerConfig setMaxFractionFullNodesPerQuery(double maxFractionFullNodesPerQuery) {
        this.maxFractionFullNodesPerQuery = maxFractionFullNodesPerQuery;
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="1.0") double getMaxFractionFullNodesPerQuery() {
        return this.maxFractionFullNodesPerQuery;
    }

    @NotNull
    public NodeAllocatorType getNodeAllocatorType() {
        return this.nodeAllocatorType;
    }

    @Config(value="node-scheduler.allocator-type")
    public NodeSchedulerConfig setNodeAllocatorType(String nodeAllocatorType) {
        this.nodeAllocatorType = NodeSchedulerConfig.toNodeAllocatorType(nodeAllocatorType);
        return this;
    }

    private static NodeAllocatorType toNodeAllocatorType(String nodeAllocatorType) {
        switch (nodeAllocatorType.toLowerCase(Locale.ENGLISH)) {
            case "fixed_count": {
                return NodeAllocatorType.FIXED_COUNT;
            }
            case "full_node_capable": {
                return NodeAllocatorType.FULL_NODE_CAPABLE;
            }
            case "bin_packing": {
                return NodeAllocatorType.BIN_PACKING;
            }
        }
        throw new IllegalArgumentException("Unknown node allocator type: " + nodeAllocatorType);
    }

    public static enum NodeAllocatorType {
        FIXED_COUNT,
        FULL_NODE_CAPABLE,
        BIN_PACKING;

    }

    public static enum SplitsBalancingPolicy {
        NODE,
        STAGE;

    }

    public static enum NodeSchedulerPolicy {
        UNIFORM,
        TOPOLOGY;

    }
}

