/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.base.MoreObjects;
import io.trino.memory.KillTarget;
import io.trino.memory.MemoryInfo;
import io.trino.operator.RetryPolicy;
import io.trino.spi.QueryId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public interface LowMemoryKiller {
    public Optional<KillTarget> chooseQueryToKill(List<QueryMemoryInfo> var1, List<MemoryInfo> var2);

    public static class QueryMemoryInfo {
        private final QueryId queryId;
        private final long memoryReservation;
        private final RetryPolicy retryPolicy;

        public QueryMemoryInfo(QueryId queryId, long memoryReservation, RetryPolicy retryPolicy) {
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.memoryReservation = memoryReservation;
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "retryPolicy is null");
        }

        public QueryId getQueryId() {
            return this.queryId;
        }

        public long getMemoryReservation() {
            return this.memoryReservation;
        }

        public RetryPolicy getRetryPolicy() {
            return this.retryPolicy;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("memoryReservation", this.memoryReservation).add("retryPolicy", (Object)this.retryPolicy).toString();
        }
    }
}

