/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.trino.execution.TaskId;
import io.trino.memory.KillTarget;
import io.trino.memory.LowMemoryKiller;
import io.trino.memory.MemoryInfo;
import io.trino.operator.RetryPolicy;
import io.trino.spi.QueryId;
import io.trino.spi.memory.MemoryPoolInfo;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class TotalReservationOnBlockedNodesLowMemoryKiller
implements LowMemoryKiller {
    @Override
    public Optional<KillTarget> chooseQueryToKill(List<LowMemoryKiller.QueryMemoryInfo> runningQueries, List<MemoryInfo> nodes) {
        Optional<KillTarget> killTarget = this.chooseTasksToKill(runningQueries, nodes);
        if (killTarget.isEmpty()) {
            killTarget = this.chooseWholeQueryToKill(runningQueries, nodes);
        }
        return killTarget;
    }

    private Optional<KillTarget> chooseTasksToKill(List<LowMemoryKiller.QueryMemoryInfo> runningQueries, List<MemoryInfo> nodes) {
        Set queriesWithTaskRetryPolicy = (Set)runningQueries.stream().filter(query -> query.getRetryPolicy() == RetryPolicy.TASK).map(LowMemoryKiller.QueryMemoryInfo::getQueryId).collect(ImmutableSet.toImmutableSet());
        if (queriesWithTaskRetryPolicy.isEmpty()) {
            return Optional.empty();
        }
        ImmutableSet.Builder tasksToKillBuilder = ImmutableSet.builder();
        for (MemoryInfo node : nodes) {
            MemoryPoolInfo memoryPool = node.getPool();
            if (memoryPool == null || memoryPool.getFreeBytes() + memoryPool.getReservedRevocableBytes() > 0L) continue;
            memoryPool.getTaskMemoryReservations().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<TaskId, Long>(TaskId.valueOf((String)entry.getKey()), (Long)entry.getValue())).filter(entry -> queriesWithTaskRetryPolicy.contains(((TaskId)entry.getKey()).getQueryId())).max(Map.Entry.comparingByValue()).map(AbstractMap.SimpleEntry::getKey).ifPresent(arg_0 -> ((ImmutableSet.Builder)tasksToKillBuilder).add(arg_0));
        }
        ImmutableSet tasksToKill = tasksToKillBuilder.build();
        if (tasksToKill.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(KillTarget.selectedTasks((Set<TaskId>)tasksToKill));
    }

    private Optional<KillTarget> chooseWholeQueryToKill(List<LowMemoryKiller.QueryMemoryInfo> runningQueries, List<MemoryInfo> nodes) {
        ImmutableMap queriesById = Maps.uniqueIndex(runningQueries, LowMemoryKiller.QueryMemoryInfo::getQueryId);
        HashMap memoryReservationOnBlockedNodes = new HashMap();
        for (MemoryInfo node : nodes) {
            MemoryPoolInfo memoryPool = node.getPool();
            if (memoryPool == null || memoryPool.getFreeBytes() + memoryPool.getReservedRevocableBytes() > 0L) continue;
            Map queryMemoryReservations = memoryPool.getQueryMemoryReservations();
            queryMemoryReservations.forEach((arg_0, arg_1) -> TotalReservationOnBlockedNodesLowMemoryKiller.lambda$chooseWholeQueryToKill$4((Map)queriesById, memoryReservationOnBlockedNodes, arg_0, arg_1));
        }
        return memoryReservationOnBlockedNodes.entrySet().stream().max(Comparator.comparingLong(Map.Entry::getValue)).map(Map.Entry::getKey).map(KillTarget::wholeQuery);
    }

    private static /* synthetic */ void lambda$chooseWholeQueryToKill$4(Map queriesById, Map memoryReservationOnBlockedNodes, QueryId queryId, Long memoryReservation) {
        LowMemoryKiller.QueryMemoryInfo queryMemoryInfo = (LowMemoryKiller.QueryMemoryInfo)queriesById.get(queryId);
        if (queryMemoryInfo != null && queryMemoryInfo.getRetryPolicy() == RetryPolicy.TASK) {
            return;
        }
        memoryReservationOnBlockedNodes.compute(queryId, (id, oldValue) -> oldValue == null ? memoryReservation : oldValue + memoryReservation);
    }
}

