/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.trino.Session;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.Metadata;
import io.trino.metadata.Signature;
import io.trino.metadata.SignatureBinder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.QualifiedName;
import io.trino.type.UnknownType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class FunctionResolver {
    private final Metadata metadata;
    private final TypeManager typeManager;

    public FunctionResolver(Metadata metadata, TypeManager typeManager) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    FunctionBinding resolveCoercion(Session session, Collection<FunctionMetadata> allCandidates, Signature signature) {
        List exactCandidates = allCandidates.stream().filter(function -> FunctionResolver.possibleExactCastMatch(signature, function.getSignature())).collect(Collectors.toList());
        for (FunctionMetadata candidate : exactCandidates) {
            if (!this.canBindSignature(session, candidate.getSignature(), signature)) continue;
            return this.toFunctionBinding(candidate, signature);
        }
        List genericCandidates = allCandidates.stream().filter(function -> !function.getSignature().getTypeVariableConstraints().isEmpty()).collect(Collectors.toList());
        for (FunctionMetadata candidate : genericCandidates) {
            if (!this.canBindSignature(session, candidate.getSignature(), signature)) continue;
            return this.toFunctionBinding(candidate, signature);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("%s not found", signature));
    }

    private boolean canBindSignature(Session session, Signature declaredSignature, Signature actualSignature) {
        return new SignatureBinder(session, this.metadata, this.typeManager, declaredSignature, false).canBind(TypeSignatureProvider.fromTypeSignatures(actualSignature.getArgumentTypes()), actualSignature.getReturnType());
    }

    private FunctionBinding toFunctionBinding(FunctionMetadata functionMetadata, Signature signature) {
        BoundSignature boundSignature = new BoundSignature(signature.getName(), this.typeManager.getType(signature.getReturnType()), (List)signature.getArgumentTypes().stream().map(arg_0 -> ((TypeManager)this.typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList()));
        return SignatureBinder.bindFunction(functionMetadata.getFunctionId(), functionMetadata.getSignature(), boundSignature);
    }

    private static boolean possibleExactCastMatch(Signature signature, Signature declaredSignature) {
        if (!declaredSignature.getTypeVariableConstraints().isEmpty()) {
            return false;
        }
        if (!declaredSignature.getReturnType().getBase().equalsIgnoreCase(signature.getReturnType().getBase())) {
            return false;
        }
        return declaredSignature.getArgumentTypes().get(0).getBase().equalsIgnoreCase(signature.getArgumentTypes().get(0).getBase());
    }

    FunctionBinding resolveFunction(Session session, Collection<FunctionMetadata> allCandidates, QualifiedName name, List<TypeSignatureProvider> parameterTypes) {
        if (allCandidates.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function '%s' not registered", name));
        }
        List exactCandidates = (List)allCandidates.stream().filter(function -> function.getSignature().getTypeVariableConstraints().isEmpty()).collect(ImmutableList.toImmutableList());
        Optional<FunctionBinding> match = this.matchFunctionExact(session, exactCandidates, parameterTypes);
        if (match.isPresent()) {
            return match.get();
        }
        List genericCandidates = (List)allCandidates.stream().filter(function -> !function.getSignature().getTypeVariableConstraints().isEmpty()).collect(ImmutableList.toImmutableList());
        match = this.matchFunctionExact(session, genericCandidates, parameterTypes);
        if (match.isPresent()) {
            return match.get();
        }
        match = this.matchFunctionWithCoercion(session, allCandidates, parameterTypes);
        if (match.isPresent()) {
            return match.get();
        }
        ArrayList<String> expectedParameters = new ArrayList<String>();
        for (FunctionMetadata function2 : allCandidates) {
            String arguments = Joiner.on((String)", ").join(function2.getSignature().getArgumentTypes());
            String constraints = Joiner.on((String)", ").join(function2.getSignature().getTypeVariableConstraints());
            expectedParameters.add(String.format("%s(%s) %s", name, arguments, constraints).stripTrailing());
        }
        String parameters = Joiner.on((String)", ").join(parameterTypes);
        String expected = Joiner.on((String)", ").join(expectedParameters);
        String message = String.format("Unexpected parameters (%s) for function %s. Expected: %s", parameters, name, expected);
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, message);
    }

    private Optional<FunctionBinding> matchFunctionExact(Session session, List<FunctionMetadata> candidates, List<TypeSignatureProvider> actualParameters) {
        return this.matchFunction(session, candidates, actualParameters, false);
    }

    private Optional<FunctionBinding> matchFunctionWithCoercion(Session session, Collection<FunctionMetadata> candidates, List<TypeSignatureProvider> actualParameters) {
        return this.matchFunction(session, candidates, actualParameters, true);
    }

    private Optional<FunctionBinding> matchFunction(Session session, Collection<FunctionMetadata> candidates, List<TypeSignatureProvider> parameters, boolean coercionAllowed) {
        List<ApplicableFunction> applicableFunctions = this.identifyApplicableFunctions(session, candidates, parameters, coercionAllowed);
        if (applicableFunctions.isEmpty()) {
            return Optional.empty();
        }
        if (coercionAllowed) {
            Preconditions.checkState((!(applicableFunctions = this.selectMostSpecificFunctions(session, applicableFunctions, parameters)).isEmpty() ? 1 : 0) != 0, (Object)"at least single function must be left");
        }
        if (applicableFunctions.size() == 1) {
            ApplicableFunction applicableFunction = (ApplicableFunction)Iterables.getOnlyElement(applicableFunctions);
            return Optional.of(this.toFunctionBinding(applicableFunction.getFunction(), applicableFunction.getBoundSignature()));
        }
        StringBuilder errorMessageBuilder = new StringBuilder();
        errorMessageBuilder.append("Could not choose a best candidate operator. Explicit type casts must be added.\n");
        errorMessageBuilder.append("Candidates are:\n");
        for (ApplicableFunction function : applicableFunctions) {
            errorMessageBuilder.append("\t * ");
            errorMessageBuilder.append(function.getBoundSignature());
            errorMessageBuilder.append("\n");
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_CALL, errorMessageBuilder.toString());
    }

    private List<ApplicableFunction> identifyApplicableFunctions(Session session, Collection<FunctionMetadata> candidates, List<TypeSignatureProvider> actualParameters, boolean allowCoercion) {
        ImmutableList.Builder applicableFunctions = ImmutableList.builder();
        for (FunctionMetadata function : candidates) {
            new SignatureBinder(session, this.metadata, this.typeManager, function.getSignature(), allowCoercion).bind(actualParameters).ifPresent(signature -> applicableFunctions.add((Object)new ApplicableFunction(function, (Signature)signature)));
        }
        return applicableFunctions.build();
    }

    private List<ApplicableFunction> selectMostSpecificFunctions(Session session, List<ApplicableFunction> applicableFunctions, List<TypeSignatureProvider> parameters) {
        Preconditions.checkArgument((!applicableFunctions.isEmpty() ? 1 : 0) != 0);
        List<ApplicableFunction> mostSpecificFunctions = this.selectMostSpecificFunctions(session, applicableFunctions);
        if (mostSpecificFunctions.size() <= 1) {
            return mostSpecificFunctions;
        }
        Optional<List<Type>> optionalParameterTypes = this.toTypes(parameters);
        if (optionalParameterTypes.isEmpty()) {
            return mostSpecificFunctions;
        }
        List<Type> parameterTypes = optionalParameterTypes.get();
        if (!FunctionResolver.someParameterIsUnknown(parameterTypes)) {
            return mostSpecificFunctions;
        }
        List<ApplicableFunction> unknownOnlyCastFunctions = this.getUnknownOnlyCastFunctions(applicableFunctions, parameterTypes);
        if (!unknownOnlyCastFunctions.isEmpty() && (mostSpecificFunctions = unknownOnlyCastFunctions).size() == 1) {
            return mostSpecificFunctions;
        }
        if (this.returnTypeIsTheSame(mostSpecificFunctions) && FunctionResolver.allReturnNullOnGivenInputTypes(mostSpecificFunctions, parameterTypes)) {
            ApplicableFunction selectedFunction = (ApplicableFunction)Ordering.usingToString().reverse().sortedCopy(mostSpecificFunctions).get(0);
            return ImmutableList.of((Object)selectedFunction);
        }
        return mostSpecificFunctions;
    }

    private List<ApplicableFunction> selectMostSpecificFunctions(Session session, List<ApplicableFunction> candidates) {
        ArrayList<ApplicableFunction> representatives = new ArrayList<ApplicableFunction>();
        for (ApplicableFunction current : candidates) {
            boolean found = false;
            for (int i = 0; i < representatives.size(); ++i) {
                ApplicableFunction representative = (ApplicableFunction)representatives.get(i);
                if (this.isMoreSpecificThan(session, current, representative)) {
                    representatives.set(i, current);
                }
                if (!this.isMoreSpecificThan(session, current, representative) && !this.isMoreSpecificThan(session, representative, current)) continue;
                found = true;
                break;
            }
            if (found) continue;
            representatives.add(current);
        }
        return representatives;
    }

    private static boolean someParameterIsUnknown(List<Type> parameters) {
        return parameters.stream().anyMatch(type -> type.equals((Object)UnknownType.UNKNOWN));
    }

    private List<ApplicableFunction> getUnknownOnlyCastFunctions(List<ApplicableFunction> applicableFunction, List<Type> actualParameters) {
        return (List)applicableFunction.stream().filter(function -> this.onlyCastsUnknown((ApplicableFunction)function, actualParameters)).collect(ImmutableList.toImmutableList());
    }

    private boolean onlyCastsUnknown(ApplicableFunction applicableFunction, List<Type> actualParameters) {
        List boundTypes = (List)applicableFunction.getBoundSignature().getArgumentTypes().stream().map(arg_0 -> ((TypeManager)this.typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList());
        Preconditions.checkState((actualParameters.size() == boundTypes.size() ? 1 : 0) != 0, (Object)"type lists are of different lengths");
        for (int i = 0; i < actualParameters.size(); ++i) {
            if (((Type)boundTypes.get(i)).equals(actualParameters.get(i)) || actualParameters.get(i) == UnknownType.UNKNOWN) continue;
            return false;
        }
        return true;
    }

    private boolean returnTypeIsTheSame(List<ApplicableFunction> applicableFunctions) {
        Set returnTypes = applicableFunctions.stream().map(function -> this.typeManager.getType(function.getBoundSignature().getReturnType())).collect(Collectors.toSet());
        return returnTypes.size() == 1;
    }

    private static boolean allReturnNullOnGivenInputTypes(List<ApplicableFunction> applicableFunctions, List<Type> parameters) {
        return applicableFunctions.stream().allMatch(x -> FunctionResolver.returnsNullOnGivenInputTypes(x, parameters));
    }

    private static boolean returnsNullOnGivenInputTypes(ApplicableFunction applicableFunction, List<Type> parameterTypes) {
        FunctionMetadata function = applicableFunction.getFunction();
        if (function.getKind() != FunctionKind.SCALAR) {
            return true;
        }
        FunctionNullability functionNullability = function.getFunctionNullability();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            if (!parameterTypes.get(i).equals((Object)UnknownType.UNKNOWN) || functionNullability.isArgumentNullable(i)) continue;
            return true;
        }
        return false;
    }

    private Optional<List<Type>> toTypes(List<TypeSignatureProvider> typeSignatureProviders) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (TypeSignatureProvider typeSignatureProvider : typeSignatureProviders) {
            if (typeSignatureProvider.hasDependency()) {
                return Optional.empty();
            }
            resultBuilder.add((Object)this.typeManager.getType(typeSignatureProvider.getTypeSignature()));
        }
        return Optional.of(resultBuilder.build());
    }

    private boolean isMoreSpecificThan(Session session, ApplicableFunction left, ApplicableFunction right) {
        List<TypeSignatureProvider> resolvedTypes = TypeSignatureProvider.fromTypeSignatures(left.getBoundSignature().getArgumentTypes());
        return new SignatureBinder(session, this.metadata, this.typeManager, right.getDeclaredSignature(), true).canBind(resolvedTypes);
    }

    private static class ApplicableFunction {
        private final FunctionMetadata function;
        private final Signature boundSignature;

        private ApplicableFunction(FunctionMetadata function, Signature boundSignature) {
            this.function = function;
            this.boundSignature = boundSignature;
        }

        public FunctionMetadata getFunction() {
            return this.function;
        }

        public Signature getDeclaredSignature() {
            return this.function.getSignature();
        }

        public Signature getBoundSignature() {
            return this.boundSignature;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("declaredSignature", (Object)this.function.getSignature()).add("boundSignature", (Object)this.boundSignature).toString();
        }
    }
}

