/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.trino.collect.cache.CacheUtils;
import io.trino.collect.cache.NonEvictableCache;
import io.trino.collect.cache.SafeCaches;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionId;
import io.trino.metadata.FunctionInvoker;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.SqlFunction;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.operator.scalar.annotations.ScalarFromAnnotationsParser;
import io.trino.operator.window.SqlWindowFunction;
import io.trino.operator.window.WindowAnnotationsParser;
import io.trino.operator.window.WindowFunctionSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.WindowFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class InternalFunctionBundle
implements FunctionBundle {
    private final NonEvictableCache<FunctionKey, ScalarFunctionImplementation> specializedScalarCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS));
    private final NonEvictableCache<FunctionKey, AggregationMetadata> specializedAggregationCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS));
    private final NonEvictableCache<FunctionKey, WindowFunctionSupplier> specializedWindowCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS));
    private final Map<FunctionId, SqlFunction> functions;

    public InternalFunctionBundle(SqlFunction ... functions) {
        this((List<? extends SqlFunction>)ImmutableList.copyOf((Object[])functions));
    }

    public InternalFunctionBundle(List<? extends SqlFunction> functions) {
        this.functions = (Map)functions.stream().collect(ImmutableMap.toImmutableMap(function -> function.getFunctionMetadata().getFunctionId(), Function.identity()));
    }

    @Override
    public Collection<FunctionMetadata> getFunctions() {
        return (Collection)this.functions.values().stream().map(SqlFunction::getFunctionMetadata).collect(ImmutableList.toImmutableList());
    }

    @Override
    public AggregationFunctionMetadata getAggregationFunctionMetadata(FunctionId functionId) {
        SqlFunction function = this.getSqlFunction(functionId);
        Preconditions.checkArgument((boolean)(function instanceof SqlAggregationFunction), (String)"%s is not an aggregation function", (Object)function.getFunctionMetadata().getSignature());
        SqlAggregationFunction aggregationFunction = (SqlAggregationFunction)function;
        return aggregationFunction.getAggregationMetadata();
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies(FunctionId functionId, BoundSignature boundSignature) {
        return this.getSqlFunction(functionId).getFunctionDependencies(boundSignature);
    }

    @Override
    public FunctionInvoker getScalarFunctionInvoker(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies, InvocationConvention invocationConvention) {
        ScalarFunctionImplementation scalarFunctionImplementation;
        try {
            scalarFunctionImplementation = (ScalarFunctionImplementation)CacheUtils.uncheckedCacheGet(this.specializedScalarCache, (Object)new FunctionKey(functionId, boundSignature), () -> this.specializeScalarFunction(functionId, boundSignature, functionDependencies));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new RuntimeException(e.getCause());
        }
        return scalarFunctionImplementation.getScalarFunctionInvoker(invocationConvention);
    }

    private ScalarFunctionImplementation specializeScalarFunction(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        SqlScalarFunction function = (SqlScalarFunction)this.getSqlFunction(functionId);
        return function.specialize(boundSignature, functionDependencies);
    }

    @Override
    public AggregationMetadata getAggregateFunctionImplementation(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        try {
            return (AggregationMetadata)CacheUtils.uncheckedCacheGet(this.specializedAggregationCache, (Object)new FunctionKey(functionId, boundSignature), () -> this.specializedAggregation(functionId, boundSignature, functionDependencies));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private AggregationMetadata specializedAggregation(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        SqlAggregationFunction aggregationFunction = (SqlAggregationFunction)this.functions.get(functionId);
        return aggregationFunction.specialize(boundSignature, functionDependencies);
    }

    @Override
    public WindowFunctionSupplier getWindowFunctionImplementation(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        try {
            return (WindowFunctionSupplier)CacheUtils.uncheckedCacheGet(this.specializedWindowCache, (Object)new FunctionKey(functionId, boundSignature), () -> this.specializeWindow(functionId, boundSignature, functionDependencies));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private WindowFunctionSupplier specializeWindow(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        SqlWindowFunction function = (SqlWindowFunction)this.functions.get(functionId);
        return function.specialize(boundSignature, functionDependencies);
    }

    private SqlFunction getSqlFunction(FunctionId functionId) {
        SqlFunction function = this.functions.get(functionId);
        Preconditions.checkArgument((function != null ? 1 : 0) != 0, (Object)("Unknown function implementation: " + functionId));
        return function;
    }

    public static InternalFunctionBundle extractFunctions(Class<?> functionClass) {
        return InternalFunctionBundle.builder().functions(functionClass).build();
    }

    public static InternalFunctionBundle extractFunctions(Collection<Class<?>> functionClasses) {
        InternalFunctionBundleBuilder builder = InternalFunctionBundle.builder();
        functionClasses.forEach(builder::functions);
        return builder.build();
    }

    public static InternalFunctionBundleBuilder builder() {
        return new InternalFunctionBundleBuilder();
    }

    private static class FunctionKey {
        private final FunctionId functionId;
        private final BoundSignature boundSignature;

        public FunctionKey(FunctionId functionId, BoundSignature boundSignature) {
            this.functionId = Objects.requireNonNull(functionId, "functionId is null");
            this.boundSignature = Objects.requireNonNull(boundSignature, "boundSignature is null");
        }

        public FunctionId getFunctionId() {
            return this.functionId;
        }

        public BoundSignature getBoundSignature() {
            return this.boundSignature;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionKey that = (FunctionKey)o;
            return this.functionId.equals(that.functionId) && this.boundSignature.equals(that.boundSignature);
        }

        public int hashCode() {
            return Objects.hash(this.functionId, this.boundSignature);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("functionId", (Object)this.functionId).add("boundSignature", (Object)this.boundSignature).toString();
        }
    }

    public static class InternalFunctionBundleBuilder {
        private final List<SqlFunction> functions = new ArrayList<SqlFunction>();

        private InternalFunctionBundleBuilder() {
        }

        public InternalFunctionBundleBuilder window(Class<? extends WindowFunction> clazz) {
            this.functions.addAll(WindowAnnotationsParser.parseFunctionDefinition(clazz));
            return this;
        }

        public InternalFunctionBundleBuilder aggregates(Class<?> aggregationDefinition) {
            this.functions.addAll(SqlAggregationFunction.createFunctionsByAnnotations(aggregationDefinition));
            return this;
        }

        public InternalFunctionBundleBuilder scalar(Class<?> clazz) {
            this.functions.addAll(ScalarFromAnnotationsParser.parseFunctionDefinition(clazz));
            return this;
        }

        public InternalFunctionBundleBuilder scalars(Class<?> clazz) {
            this.functions.addAll(ScalarFromAnnotationsParser.parseFunctionDefinitions(clazz));
            return this;
        }

        public InternalFunctionBundleBuilder functions(Class<?> clazz) {
            if (WindowFunction.class.isAssignableFrom(clazz)) {
                Class<?> windowClazz = clazz;
                this.window(windowClazz);
                return this;
            }
            if (clazz.isAnnotationPresent(AggregationFunction.class)) {
                this.aggregates(clazz);
                return this;
            }
            if (clazz.isAnnotationPresent(ScalarFunction.class) || clazz.isAnnotationPresent(ScalarOperator.class)) {
                this.scalar(clazz);
                return this;
            }
            this.scalars(clazz);
            return this;
        }

        public InternalFunctionBundleBuilder functions(SqlFunction ... sqlFunctions) {
            for (SqlFunction sqlFunction : sqlFunctions) {
                this.function(sqlFunction);
            }
            return this;
        }

        public InternalFunctionBundleBuilder function(SqlFunction sqlFunction) {
            Objects.requireNonNull(sqlFunction, "sqlFunction is null");
            this.functions.add(sqlFunction);
            return this;
        }

        public InternalFunctionBundle build() {
            return new InternalFunctionBundle(this.functions);
        }
    }
}

