/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slice;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.client.NodeVersion;
import io.trino.collect.cache.CacheUtils;
import io.trino.collect.cache.NonEvictableCache;
import io.trino.collect.cache.SafeCaches;
import io.trino.connector.CatalogName;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.AnalyzeTableHandle;
import io.trino.metadata.BlockEncodingManager;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.Catalog;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.CatalogMetadata;
import io.trino.metadata.DisabledSystemSecurityMetadata;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionId;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.FunctionResolver;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.InsertTableHandle;
import io.trino.metadata.InternalBlockEncodingSerde;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.LiteralFunction;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.Metadata;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.OutputTableHandle;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.ResolvedIndex;
import io.trino.metadata.Signature;
import io.trino.metadata.SignatureBinder;
import io.trino.metadata.SystemFunctionBundle;
import io.trino.metadata.SystemSecurityMetadata;
import io.trino.metadata.TableExecuteHandle;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableLayout;
import io.trino.metadata.TableMetadata;
import io.trino.metadata.TableProperties;
import io.trino.metadata.TableSchema;
import io.trino.metadata.TableVersion;
import io.trino.metadata.ViewColumn;
import io.trino.metadata.ViewDefinition;
import io.trino.metadata.ViewInfo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.BeginTableExecuteResult;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorResolvedIndex;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.JoinApplicationResult;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.SampleApplicationResult;
import io.trino.spi.connector.SampleType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SortItem;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.connector.TopNApplicationResult;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.function.OperatorType;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.ConnectorExpressions;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.tree.QualifiedName;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import io.trino.type.BlockTypeOperators;
import io.trino.type.InternalTypeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

public final class MetadataManager
implements Metadata {
    @VisibleForTesting
    public static final int MAX_TABLE_REDIRECTIONS = 10;
    private final GlobalFunctionCatalog functions;
    private final FunctionResolver functionResolver;
    private final SystemSecurityMetadata systemSecurityMetadata;
    private final TransactionManager transactionManager;
    private final TypeManager typeManager;
    private final ConcurrentMap<QueryId, QueryCatalogs> catalogsByQueryId = new ConcurrentHashMap<QueryId, QueryCatalogs>();
    private final ResolvedFunction.ResolvedFunctionDecoder functionDecoder;
    private final NonEvictableCache<OperatorCacheKey, ResolvedFunction> operatorCache;
    private final NonEvictableCache<CoercionCacheKey, ResolvedFunction> coercionCache;

    @Inject
    public MetadataManager(FeaturesConfig featuresConfig, SystemSecurityMetadata systemSecurityMetadata, TransactionManager transactionManager, GlobalFunctionCatalog globalFunctionCatalog, TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.functions = Objects.requireNonNull(globalFunctionCatalog, "globalFunctionCatalog is null");
        this.functionResolver = new FunctionResolver(this, typeManager);
        this.systemSecurityMetadata = Objects.requireNonNull(systemSecurityMetadata, "systemSecurityMetadata is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.functionDecoder = new ResolvedFunction.ResolvedFunctionDecoder(arg_0 -> ((TypeManager)typeManager).getType(arg_0));
        this.operatorCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L));
        this.coercionCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L));
    }

    @Override
    public Set<ConnectorCapabilities> getConnectorCapabilities(Session session, CatalogName catalogName) {
        return this.getCatalogMetadata(session, catalogName).getConnectorCapabilities();
    }

    @Override
    public boolean catalogExists(Session session, String catalogName) {
        return this.getOptionalCatalogMetadata(session, catalogName).isPresent();
    }

    @Override
    public boolean schemaExists(Session session, CatalogSchemaName schema) {
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, schema.getCatalogName());
        if (catalog.isEmpty()) {
            return false;
        }
        CatalogMetadata catalogMetadata = catalog.get();
        ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getCatalogName());
        return catalogMetadata.listConnectorIds().stream().map(catalogName -> catalogMetadata.getMetadataFor(session, (CatalogName)catalogName)).anyMatch(metadata -> metadata.schemaExists(connectorSession, schema.getSchemaName()));
    }

    @Override
    public List<String> listSchemaNames(Session session, String catalogName) {
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, catalogName);
        ImmutableSet.Builder schemaNames = ImmutableSet.builder();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getCatalogName());
            for (CatalogName connectorId : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, connectorId);
                metadata.listSchemaNames(connectorSession).stream().map(schema -> schema.toLowerCase(Locale.ENGLISH)).forEach(arg_0 -> ((ImmutableSet.Builder)schemaNames).add(arg_0));
            }
        }
        return ImmutableList.copyOf((Collection)schemaNames.build());
    }

    @Override
    public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName table) {
        return this.getTableHandle(session, table, Optional.empty(), Optional.empty());
    }

    @Override
    public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName table, Optional<TableVersion> startVersion, Optional<TableVersion> endVersion) {
        Objects.requireNonNull(table, "table is null");
        if (table.getCatalogName().isEmpty() || table.getSchemaName().isEmpty() || table.getObjectName().isEmpty()) {
            return Optional.empty();
        }
        return this.getOptionalCatalogMetadata(session, table.getCatalogName()).flatMap(catalogMetadata -> {
            CatalogName catalogName = catalogMetadata.getConnectorId(session, table);
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
            ConnectorSession connectorSession = session.toConnectorSession(catalogName);
            if (startVersion.isPresent() || endVersion.isPresent()) {
                ConnectorTableHandle versionedTableHandle = metadata.getTableHandle(connectorSession, table.asSchemaTableName(), this.toConnectorVersion(startVersion), this.toConnectorVersion(endVersion));
                return Optional.ofNullable(versionedTableHandle).map(connectorTableHandle -> new TableHandle(catalogName, (ConnectorTableHandle)connectorTableHandle, catalogMetadata.getTransactionHandleFor(catalogName)));
            }
            return Optional.ofNullable(metadata.getTableHandle(connectorSession, table.asSchemaTableName())).map(connectorTableHandle -> new TableHandle(catalogName, (ConnectorTableHandle)connectorTableHandle, catalogMetadata.getTransactionHandleFor(catalogName)));
        });
    }

    @Override
    public Optional<TableHandle> getTableHandleForStatisticsCollection(Session session, QualifiedObjectName table, Map<String, Object> analyzeProperties) {
        CatalogName catalogName;
        CatalogMetadata catalogMetadata;
        ConnectorMetadata metadata;
        ConnectorTableHandle tableHandle;
        Objects.requireNonNull(table, "table is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, table.getCatalogName());
        if (catalog.isPresent() && (tableHandle = (metadata = (catalogMetadata = catalog.get()).getMetadataFor(session, catalogName = catalogMetadata.getConnectorId(session, table))).getTableHandleForStatisticsCollection(session.toConnectorSession(catalogName), table.asSchemaTableName(), analyzeProperties)) != null) {
            return Optional.of(new TableHandle(catalogName, tableHandle, catalogMetadata.getTransactionHandleFor(catalogName)));
        }
        return Optional.empty();
    }

    @Override
    public Optional<TableExecuteHandle> getTableHandleForExecute(Session session, TableHandle tableHandle, String procedure, Map<String, Object> executeProperties) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Objects.requireNonNull(procedure, "procedure is null");
        Objects.requireNonNull(executeProperties, "executeProperties is null");
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
        Optional executeHandle = metadata.getTableHandleForExecute(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), procedure, executeProperties, SystemSessionProperties.getRetryPolicy(session).getRetryMode());
        return executeHandle.map(handle -> new TableExecuteHandle(catalogName, tableHandle.getTransaction(), (ConnectorTableExecuteHandle)handle));
    }

    @Override
    public Optional<TableLayout> getLayoutForTableExecute(Session session, TableExecuteHandle tableExecuteHandle) {
        CatalogName catalogName = tableExecuteHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        return metadata.getLayoutForTableExecute(session.toConnectorSession(catalogName), tableExecuteHandle.getConnectorHandle()).map(layout -> new TableLayout(catalogName, catalogMetadata.getTransactionHandleFor(catalogName), (ConnectorTableLayout)layout));
    }

    @Override
    public BeginTableExecuteResult<TableExecuteHandle, TableHandle> beginTableExecute(Session session, TableExecuteHandle tableExecuteHandle, TableHandle sourceHandle) {
        CatalogName catalogName = tableExecuteHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        BeginTableExecuteResult connectorBeginResult = metadata.beginTableExecute(session.toConnectorSession(), tableExecuteHandle.getConnectorHandle(), sourceHandle.getConnectorHandle());
        return new BeginTableExecuteResult((Object)tableExecuteHandle.withConnectorHandle((ConnectorTableExecuteHandle)connectorBeginResult.getTableExecuteHandle()), (Object)sourceHandle.withConnectorHandle((ConnectorTableHandle)connectorBeginResult.getSourceHandle()));
    }

    @Override
    public void finishTableExecute(Session session, TableExecuteHandle tableExecuteHandle, Collection<Slice> fragments, List<Object> tableExecuteState) {
        CatalogName catalogName = tableExecuteHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        metadata.finishTableExecute(session.toConnectorSession(catalogName), tableExecuteHandle.getConnectorHandle(), fragments, tableExecuteState);
    }

    @Override
    public void executeTableExecute(Session session, TableExecuteHandle tableExecuteHandle) {
        CatalogName catalogName = tableExecuteHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        metadata.executeTableExecute(session.toConnectorSession(catalogName), tableExecuteHandle.getConnectorHandle());
    }

    @Override
    public Optional<SystemTable> getSystemTable(Session session, QualifiedObjectName tableName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, tableName.getCatalogName());
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            CatalogName catalogName = catalogMetadata.getCatalogName();
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
            return metadata.getSystemTable(session.toConnectorSession(catalogName), tableName.asSchemaTableName());
        }
        return Optional.empty();
    }

    @Override
    public TableProperties getTableProperties(Session session, TableHandle handle) {
        CatalogName catalogName = handle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return new TableProperties(catalogName, handle.getTransaction(), metadata.getTableProperties(connectorSession, handle.getConnectorHandle()));
    }

    @Override
    public TableHandle makeCompatiblePartitioning(Session session, TableHandle tableHandle, PartitioningHandle partitioningHandle) {
        Preconditions.checkArgument((boolean)partitioningHandle.getConnectorId().isPresent(), (Object)"Expect partitioning handle from connector, got system partitioning handle");
        CatalogName catalogName = partitioningHandle.getConnectorId().get();
        Preconditions.checkArgument((boolean)catalogName.equals(tableHandle.getCatalogName()), (Object)"ConnectorId of tableHandle and partitioningHandle does not match");
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
        ConnectorTransactionHandle transaction = catalogMetadata.getTransactionHandleFor(catalogName);
        ConnectorTableHandle newTableHandle = metadata.makeCompatiblePartitioning(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), partitioningHandle.getConnectorHandle());
        return new TableHandle(catalogName, newTableHandle, transaction);
    }

    @Override
    public Optional<PartitioningHandle> getCommonPartitioning(Session session, PartitioningHandle left, PartitioningHandle right) {
        Optional<CatalogName> leftConnectorId = left.getConnectorId();
        Optional<CatalogName> rightConnectorId = right.getConnectorId();
        if (leftConnectorId.isEmpty() || rightConnectorId.isEmpty() || !leftConnectorId.equals(rightConnectorId)) {
            return Optional.empty();
        }
        if (!left.getTransactionHandle().equals(right.getTransactionHandle())) {
            return Optional.empty();
        }
        CatalogName catalogName = leftConnectorId.get();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
        Optional commonHandle = metadata.getCommonPartitioningHandle(session.toConnectorSession(catalogName), left.getConnectorHandle(), right.getConnectorHandle());
        return commonHandle.map(handle -> new PartitioningHandle(Optional.of(catalogName), left.getTransactionHandle(), (ConnectorPartitioningHandle)handle));
    }

    @Override
    public Optional<Object> getInfo(Session session, TableHandle handle) {
        CatalogName catalogName = handle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return metadata.getInfo(handle.getConnectorHandle());
    }

    @Override
    public TableSchema getTableSchema(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        ConnectorTableSchema tableSchema = metadata.getTableSchema(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
        return new TableSchema(catalogName, tableSchema);
    }

    @Override
    public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
        return new TableMetadata(catalogName, tableMetadata);
    }

    @Override
    public TableStatistics getTableStatistics(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        TableStatistics tableStatistics = metadata.getTableStatistics(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
        Verify.verifyNotNull((Object)tableStatistics, (String)"%s returned null tableStatistics for %s", (Object[])new Object[]{metadata, tableHandle});
        return tableStatistics;
    }

    @Override
    public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        Map handles = metadata.getColumnHandles(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry mapEntry : handles.entrySet()) {
            map.put((Object)((String)mapEntry.getKey()).toLowerCase(Locale.ENGLISH), (Object)((ColumnHandle)mapEntry.getValue()));
        }
        return map.buildOrThrow();
    }

    @Override
    public ColumnMetadata getColumnMetadata(Session session, TableHandle tableHandle, ColumnHandle columnHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return metadata.getColumnMetadata(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), columnHandle);
    }

    @Override
    public List<QualifiedObjectName> listTables(Session session, QualifiedTablePrefix prefix) {
        Optional<Boolean> exists;
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<QualifiedObjectName> objectName = prefix.asQualifiedObjectName();
        if (objectName.isPresent() && (exists = this.isExistingRelationForListing(session, objectName.get())).isPresent()) {
            return exists.get() != false ? ImmutableList.of((Object)objectName.get()) : ImmutableList.of();
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashSet tables = new LinkedHashSet();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            for (CatalogName catalogName : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                metadata.listTables(connectorSession, prefix.getSchemaName()).stream().map(QualifiedObjectName.convertFromSchemaTableName(prefix.getCatalogName())).filter(prefix::matches).forEach(tables::add);
            }
        }
        return ImmutableList.copyOf(tables);
    }

    private Optional<Boolean> isExistingRelationForListing(Session session, QualifiedObjectName name) {
        if (this.isMaterializedView(session, name)) {
            return Optional.of(true);
        }
        if (this.isView(session, name)) {
            return Optional.of(true);
        }
        try {
            return Optional.of(this.getRedirectionAwareTableHandle(session, name).getTableHandle().isPresent());
        }
        catch (TrinoException e) {
            if (e.getErrorCode().equals((Object)StandardErrorCode.TABLE_REDIRECTION_ERROR.toErrorCode())) {
                return Optional.of(true);
            }
            return Optional.empty();
        }
    }

    @Override
    public List<TableColumnsMetadata> listTableColumns(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        HashMap<SchemaTableName, Optional<ImmutableList>> tableColumns = new HashMap<SchemaTableName, Optional<ImmutableList>>();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
            for (CatalogName catalogName : catalogMetadata.listConnectorIds()) {
                ImmutableList.Builder columns;
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                metadata.streamTableColumns(connectorSession, tablePrefix).forEach(columnsMetadata -> tableColumns.put(columnsMetadata.getTable(), columnsMetadata.getColumns()));
                for (Map.Entry<QualifiedObjectName, ViewInfo> entry2 : this.getViews(session, prefix).entrySet()) {
                    columns = ImmutableList.builder();
                    for (ViewColumn column : entry2.getValue().getColumns()) {
                        try {
                            columns.add((Object)new ColumnMetadata(column.getName(), this.typeManager.getType(column.getType())));
                        }
                        catch (TypeNotFoundException e) {
                            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, String.format("Unknown type '%s' for column '%s' in view: %s", column.getType(), column.getName(), entry2.getKey()));
                        }
                    }
                    tableColumns.put(entry2.getKey().asSchemaTableName(), Optional.of(columns.build()));
                }
                for (Map.Entry<QualifiedObjectName, ViewInfo> entry2 : this.getMaterializedViews(session, prefix).entrySet()) {
                    columns = ImmutableList.builder();
                    for (ViewColumn column : entry2.getValue().getColumns()) {
                        try {
                            columns.add((Object)new ColumnMetadata(column.getName(), this.typeManager.getType(column.getType())));
                        }
                        catch (TypeNotFoundException e) {
                            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, String.format("Unknown type '%s' for column '%s' in materialized view: %s", column.getType(), column.getName(), entry2.getKey()));
                        }
                    }
                    tableColumns.put(entry2.getKey().asSchemaTableName(), Optional.of(columns.build()));
                }
            }
        }
        return (List)tableColumns.entrySet().stream().map(entry -> new TableColumnsMetadata((SchemaTableName)entry.getKey(), (Optional)entry.getValue())).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void createSchema(Session session, CatalogSchemaName schema, Map<String, Object> properties, TrinoPrincipal principal) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schema.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.createSchema(session.toConnectorSession(catalogName), schema.getSchemaName(), properties, principal);
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.schemaCreated(session, schema);
        }
    }

    @Override
    public void dropSchema(Session session, CatalogSchemaName schema) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schema.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.dropSchema(session.toConnectorSession(catalogName), schema.getSchemaName());
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.schemaDropped(session, schema);
        }
    }

    @Override
    public void renameSchema(Session session, CatalogSchemaName source, String target) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, source.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.renameSchema(session.toConnectorSession(catalogName), source.getSchemaName(), target);
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.schemaRenamed(session, source, new CatalogSchemaName(source.getCatalogName(), target));
        }
    }

    @Override
    public void setSchemaAuthorization(Session session, CatalogSchemaName source, TrinoPrincipal principal) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, source.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.setSchemaOwner(session, source, principal);
        } else {
            metadata.setSchemaAuthorization(session.toConnectorSession(catalogName), source.getSchemaName(), principal);
        }
    }

    @Override
    public void createTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        CatalogName catalog = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.createTable(session.toConnectorSession(catalog), tableMetadata, ignoreExisting);
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.tableCreated(session, new CatalogSchemaTableName(catalogName, tableMetadata.getTable()));
        }
    }

    @Override
    public void renameTable(Session session, TableHandle tableHandle, QualifiedObjectName newTableName) {
        String catalogName = newTableName.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        CatalogName catalog = catalogMetadata.getCatalogName();
        if (!tableHandle.getCatalogName().equals(catalog)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, "Cannot rename tables across catalogs");
        }
        Optional<CatalogSchemaTableName> sourceTableName = MetadataManager.getTableNameIfSystemSecurity(session, catalogMetadata, tableHandle);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.renameTable(session.toConnectorSession(catalog), tableHandle.getConnectorHandle(), newTableName.asSchemaTableName());
        sourceTableName.ifPresent(name -> this.systemSecurityMetadata.tableRenamed(session, (CatalogSchemaTableName)name, newTableName.asCatalogSchemaTableName()));
    }

    @Override
    public void setTableProperties(Session session, TableHandle tableHandle, Map<String, Optional<Object>> properties) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.setTableProperties(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), properties);
    }

    @Override
    public void setTableComment(Session session, TableHandle tableHandle, Optional<String> comment) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.setTableComment(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), comment);
    }

    @Override
    public void setColumnComment(Session session, TableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.setColumnComment(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), column, comment);
    }

    @Override
    public void renameColumn(Session session, TableHandle tableHandle, ColumnHandle source, String target) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.renameColumn(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), source, target.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void addColumn(Session session, TableHandle tableHandle, ColumnMetadata column) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.addColumn(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), column);
    }

    @Override
    public void dropColumn(Session session, TableHandle tableHandle, ColumnHandle column) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.dropColumn(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), column);
    }

    @Override
    public void setTableAuthorization(Session session, CatalogSchemaTableName table, TrinoPrincipal principal) {
        CatalogName catalogName = new CatalogName(table.getCatalogName());
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.setTableOwner(session, table, principal);
        } else {
            metadata.setTableAuthorization(session.toConnectorSession(catalogName), table.getSchemaTableName(), principal);
        }
    }

    @Override
    public void dropTable(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        Optional<CatalogSchemaTableName> tableName = MetadataManager.getTableNameIfSystemSecurity(session, catalogMetadata, tableHandle);
        metadata.dropTable(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
        tableName.ifPresent(name -> this.systemSecurityMetadata.tableDropped(session, (CatalogSchemaTableName)name));
    }

    @Override
    public void truncateTable(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.truncateTable(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
    }

    @Override
    public Optional<TableLayout> getInsertLayout(Session session, TableHandle table) {
        CatalogName catalogName = table.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        return metadata.getInsertLayout(session.toConnectorSession(catalogName), table.getConnectorHandle()).map(layout -> new TableLayout(catalogName, catalogMetadata.getTransactionHandleFor(catalogName), (ConnectorTableLayout)layout));
    }

    @Override
    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        CatalogName catalog = catalogMetadata.getCatalogName();
        return metadata.getStatisticsCollectionMetadataForWrite(session.toConnectorSession(catalog), tableMetadata);
    }

    @Override
    public TableStatisticsMetadata getStatisticsCollectionMetadata(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        CatalogName catalog = catalogMetadata.getCatalogName();
        return metadata.getStatisticsCollectionMetadata(session.toConnectorSession(catalog), tableMetadata);
    }

    @Override
    public AnalyzeTableHandle beginStatisticsCollection(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalogName);
        ConnectorTableHandle connectorTableHandle = metadata.beginStatisticsCollection(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
        return new AnalyzeTableHandle(catalogName, transactionHandle, connectorTableHandle);
    }

    @Override
    public void finishStatisticsCollection(Session session, AnalyzeTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        catalogMetadata.getMetadata(session).finishStatisticsCollection(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), computedStatistics);
    }

    @Override
    public Optional<TableLayout> getNewTableLayout(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        CatalogName catalog = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalog);
        ConnectorSession connectorSession = session.toConnectorSession(catalog);
        return metadata.getNewTableLayout(connectorSession, tableMetadata).map(layout -> new TableLayout(catalog, transactionHandle, (ConnectorTableLayout)layout));
    }

    @Override
    public void cleanupQuery(Session session) {
        QueryCatalogs queryCatalogs = (QueryCatalogs)this.catalogsByQueryId.remove(session.getQueryId());
        if (queryCatalogs != null) {
            queryCatalogs.finish();
        }
    }

    @Override
    public OutputTableHandle beginCreateTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, Optional<TableLayout> layout) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        CatalogName catalog = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalog);
        ConnectorSession connectorSession = session.toConnectorSession(catalog);
        ConnectorOutputTableHandle handle = metadata.beginCreateTable(connectorSession, tableMetadata, layout.map(TableLayout::getLayout), SystemSessionProperties.getRetryPolicy(session).getRetryMode());
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.tableCreated(session, new CatalogSchemaTableName(catalogName, tableMetadata.getTable()));
        }
        return new OutputTableHandle(catalog, transactionHandle, handle);
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishCreateTable(Session session, OutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return metadata.finishCreateTable(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), fragments, computedStatistics);
    }

    @Override
    public InsertTableHandle beginInsert(Session session, TableHandle tableHandle, List<ColumnHandle> columns) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalogName);
        ConnectorInsertTableHandle handle = metadata.beginInsert(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), columns, SystemSessionProperties.getRetryPolicy(session).getRetryMode());
        return new InsertTableHandle(tableHandle.getCatalogName(), transactionHandle, handle);
    }

    @Override
    public boolean supportsMissingColumnsOnInsert(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        return catalogMetadata.getMetadata(session).supportsMissingColumnsOnInsert();
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishInsert(Session session, InsertTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return metadata.finishInsert(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), fragments, computedStatistics);
    }

    @Override
    public boolean delegateMaterializedViewRefreshToConnector(Session session, QualifiedObjectName viewName) {
        CatalogName catalogName = new CatalogName(viewName.getCatalogName());
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return metadata.delegateMaterializedViewRefreshToConnector(session.toConnectorSession(catalogName), viewName.asSchemaTableName());
    }

    @Override
    public ListenableFuture<Void> refreshMaterializedView(Session session, QualifiedObjectName viewName) {
        CatalogName catalogName = new CatalogName(viewName.getCatalogName());
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return MetadataManager.asVoid(MoreFutures.toListenableFuture((CompletableFuture)metadata.refreshMaterializedView(session.toConnectorSession(catalogName), viewName.asSchemaTableName())));
    }

    private static <T> ListenableFuture<Void> asVoid(ListenableFuture<T> future) {
        return Futures.transform(future, v -> null, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public InsertTableHandle beginRefreshMaterializedView(Session session, TableHandle tableHandle, List<TableHandle> sourceTableHandles) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalogName);
        List sourceConnectorHandles = sourceTableHandles.stream().map(TableHandle::getConnectorHandle).collect(Collectors.toList());
        sourceConnectorHandles.add(tableHandle.getConnectorHandle());
        if (sourceConnectorHandles.stream().map(Object::getClass).distinct().count() > 1L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cross connector materialized views are not supported");
        }
        ConnectorInsertTableHandle handle = metadata.beginRefreshMaterializedView(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), sourceConnectorHandles, SystemSessionProperties.getRetryPolicy(session).getRetryMode());
        return new InsertTableHandle(tableHandle.getCatalogName(), transactionHandle, handle);
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishRefreshMaterializedView(Session session, TableHandle tableHandle, InsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics, List<TableHandle> sourceTableHandles) {
        CatalogName catalogName = insertHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        List sourceConnectorHandles = (List)sourceTableHandles.stream().map(TableHandle::getConnectorHandle).collect(ImmutableList.toImmutableList());
        return metadata.finishRefreshMaterializedView(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), insertHandle.getConnectorHandle(), fragments, computedStatistics, sourceConnectorHandles);
    }

    @Override
    public ColumnHandle getDeleteRowIdColumnHandle(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return metadata.getDeleteRowIdColumnHandle(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
    }

    @Override
    public ColumnHandle getUpdateRowIdColumnHandle(Session session, TableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return metadata.getUpdateRowIdColumnHandle(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), updatedColumns);
    }

    @Override
    public Optional<TableHandle> applyDelete(Session session, TableHandle table) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyDelete(connectorSession, table.getConnectorHandle()).map(newHandle -> new TableHandle(catalogName, (ConnectorTableHandle)newHandle, table.getTransaction()));
    }

    @Override
    public OptionalLong executeDelete(Session session, TableHandle table) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.executeDelete(connectorSession, table.getConnectorHandle());
    }

    @Override
    public TableHandle beginDelete(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        ConnectorTableHandle newHandle = metadata.beginDelete(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), SystemSessionProperties.getRetryPolicy(session).getRetryMode());
        return new TableHandle(tableHandle.getCatalogName(), newHandle, tableHandle.getTransaction());
    }

    @Override
    public void finishDelete(Session session, TableHandle tableHandle, Collection<Slice> fragments) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        metadata.finishDelete(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public TableHandle beginUpdate(Session session, TableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        ConnectorTableHandle newHandle = metadata.beginUpdate(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), updatedColumns, SystemSessionProperties.getRetryPolicy(session).getRetryMode());
        return new TableHandle(tableHandle.getCatalogName(), newHandle, tableHandle.getTransaction());
    }

    @Override
    public void finishUpdate(Session session, TableHandle tableHandle, Collection<Slice> fragments) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        metadata.finishUpdate(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public Optional<CatalogName> getCatalogHandle(Session session, String catalogName) {
        return this.transactionManager.getOptionalCatalogMetadata(session.getRequiredTransactionId(), catalogName).map(CatalogMetadata::getCatalogName);
    }

    @Override
    public Map<String, Catalog> getCatalogs(Session session) {
        return this.transactionManager.getCatalogs(session.getRequiredTransactionId());
    }

    @Override
    public List<QualifiedObjectName> listViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<QualifiedObjectName> objectName = prefix.asQualifiedObjectName();
        if (objectName.isPresent()) {
            return (List)this.getView(session, objectName.get()).map(handle -> ImmutableList.of((Object)((QualifiedObjectName)objectName.get()))).orElseGet(ImmutableList::of);
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashSet views = new LinkedHashSet();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            for (CatalogName catalogName : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                metadata.listViews(connectorSession, prefix.getSchemaName()).stream().map(QualifiedObjectName.convertFromSchemaTableName(prefix.getCatalogName())).filter(prefix::matches).forEach(views::add);
            }
        }
        return ImmutableList.copyOf(views);
    }

    @Override
    public Map<QualifiedObjectName, ViewInfo> getViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashMap<QualifiedObjectName, ViewInfo> views = new LinkedHashMap<QualifiedObjectName, ViewInfo>();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
            for (CatalogName catalogName : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                Map viewMap = tablePrefix.getTable().isPresent() ? (Map)metadata.getView(connectorSession, tablePrefix.toSchemaTableName()).map(view -> ImmutableMap.of((Object)tablePrefix.toSchemaTableName(), (Object)view)).orElse(ImmutableMap.of()) : metadata.getViews(connectorSession, tablePrefix.getSchema());
                for (Map.Entry entry : viewMap.entrySet()) {
                    QualifiedObjectName viewName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                    views.put(viewName, new ViewInfo((ConnectorViewDefinition)entry.getValue()));
                }
            }
        }
        return ImmutableMap.copyOf(views);
    }

    @Override
    public Map<String, Object> getSchemaProperties(Session session, CatalogSchemaName schemaName) {
        if (!this.schemaExists(session, schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, String.format("Schema '%s' does not exist", schemaName));
        }
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, new CatalogName(schemaName.getCatalogName()));
        CatalogName catalogName = catalogMetadata.getConnectorIdForSchema(schemaName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.getSchemaProperties(connectorSession, schemaName);
    }

    @Override
    public Optional<TrinoPrincipal> getSchemaOwner(Session session, CatalogSchemaName schemaName) {
        if (!this.schemaExists(session, schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, String.format("Schema '%s' does not exist", schemaName));
        }
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, new CatalogName(schemaName.getCatalogName()));
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            return this.systemSecurityMetadata.getSchemaOwner(session, schemaName);
        }
        CatalogName catalogName = catalogMetadata.getConnectorIdForSchema(schemaName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.getSchemaOwner(connectorSession, schemaName);
    }

    @Override
    public boolean isView(Session session, QualifiedObjectName viewName) {
        return this.getViewInternal(session, viewName).isPresent();
    }

    @Override
    public Optional<ViewDefinition> getView(Session session, QualifiedObjectName viewName) {
        Optional<ConnectorViewDefinition> connectorView = this.getViewInternal(session, viewName);
        if (connectorView.isEmpty() || connectorView.get().isRunAsInvoker() || this.isCatalogManagedSecurity(session, viewName.getCatalogName())) {
            return connectorView.map(view -> new ViewDefinition(viewName, (ConnectorViewDefinition)view));
        }
        Identity runAsIdentity = this.systemSecurityMetadata.getViewRunAsIdentity(session, viewName.asCatalogSchemaTableName()).or(() -> ((ConnectorViewDefinition)connectorView.get()).getOwner().map(Identity::ofUser)).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Catalog does not support run-as DEFINER views: " + viewName));
        return Optional.of(new ViewDefinition(viewName, connectorView.get(), runAsIdentity));
    }

    private Optional<ConnectorViewDefinition> getViewInternal(Session session, QualifiedObjectName viewName) {
        if (viewName.getCatalogName().isEmpty() || viewName.getSchemaName().isEmpty() || viewName.getObjectName().isEmpty()) {
            return Optional.empty();
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, viewName.getCatalogName());
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            CatalogName catalogName = catalogMetadata.getConnectorId(session, viewName);
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
            ConnectorSession connectorSession = session.toConnectorSession(catalogName);
            return metadata.getView(connectorSession, viewName.asSchemaTableName());
        }
        return Optional.empty();
    }

    @Override
    public void createView(Session session, QualifiedObjectName viewName, ViewDefinition definition, boolean replace) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.createView(session.toConnectorSession(catalogName), viewName.asSchemaTableName(), definition.toConnectorViewDefinition(), replace);
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.tableCreated(session, viewName.asCatalogSchemaTableName());
        }
    }

    @Override
    public void renameView(Session session, QualifiedObjectName source, QualifiedObjectName target) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, target.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        if (!source.getCatalogName().equals(catalogName.getCatalogName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, "Cannot rename views across catalogs");
        }
        metadata.renameView(session.toConnectorSession(catalogName), source.asSchemaTableName(), target.asSchemaTableName());
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.tableRenamed(session, source.asCatalogSchemaTableName(), target.asCatalogSchemaTableName());
        }
    }

    @Override
    public void setViewAuthorization(Session session, CatalogSchemaTableName view, TrinoPrincipal principal) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, view.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.setViewOwner(session, view, principal);
        } else {
            metadata.setViewAuthorization(session.toConnectorSession(catalogName), view.getSchemaTableName(), principal);
        }
    }

    @Override
    public void dropView(Session session, QualifiedObjectName viewName) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.dropView(session.toConnectorSession(catalogName), viewName.asSchemaTableName());
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.tableDropped(session, viewName.asCatalogSchemaTableName());
        }
    }

    @Override
    public void createMaterializedView(Session session, QualifiedObjectName viewName, MaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.createMaterializedView(session.toConnectorSession(catalogName), viewName.asSchemaTableName(), definition.toConnectorMaterializedViewDefinition(), replace, ignoreExisting);
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.tableCreated(session, viewName.asCatalogSchemaTableName());
        }
    }

    @Override
    public void dropMaterializedView(Session session, QualifiedObjectName viewName) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.dropMaterializedView(session.toConnectorSession(catalogName), viewName.asSchemaTableName());
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.tableDropped(session, viewName.asCatalogSchemaTableName());
        }
    }

    @Override
    public List<QualifiedObjectName> listMaterializedViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<QualifiedObjectName> objectName = prefix.asQualifiedObjectName();
        if (objectName.isPresent()) {
            return this.isMaterializedView(session, objectName.get()) ? ImmutableList.of((Object)objectName.get()) : ImmutableList.of();
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashSet materializedViews = new LinkedHashSet();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            for (CatalogName catalogName : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                metadata.listMaterializedViews(connectorSession, prefix.getSchemaName()).stream().map(QualifiedObjectName.convertFromSchemaTableName(prefix.getCatalogName())).filter(prefix::matches).forEach(materializedViews::add);
            }
        }
        return ImmutableList.copyOf(materializedViews);
    }

    @Override
    public Map<QualifiedObjectName, ViewInfo> getMaterializedViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashMap<QualifiedObjectName, ViewInfo> views = new LinkedHashMap<QualifiedObjectName, ViewInfo>();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
            for (CatalogName catalogName : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                Map materializedViewMap = tablePrefix.getTable().isPresent() ? (Map)metadata.getMaterializedView(connectorSession, tablePrefix.toSchemaTableName()).map(view -> ImmutableMap.of((Object)tablePrefix.toSchemaTableName(), (Object)view)).orElse(ImmutableMap.of()) : metadata.getMaterializedViews(connectorSession, tablePrefix.getSchema());
                for (Map.Entry entry : materializedViewMap.entrySet()) {
                    QualifiedObjectName viewName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                    views.put(viewName, new ViewInfo((ConnectorMaterializedViewDefinition)entry.getValue()));
                }
            }
        }
        return ImmutableMap.copyOf(views);
    }

    @Override
    public boolean isMaterializedView(Session session, QualifiedObjectName viewName) {
        return this.getMaterializedViewInternal(session, viewName).isPresent();
    }

    @Override
    public Optional<MaterializedViewDefinition> getMaterializedView(Session session, QualifiedObjectName viewName) {
        Optional<ConnectorMaterializedViewDefinition> connectorView = this.getMaterializedViewInternal(session, viewName);
        if (connectorView.isEmpty() || this.isCatalogManagedSecurity(session, viewName.getCatalogName())) {
            return connectorView.map(view -> {
                String runAsUser = (String)view.getOwner().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, "Owner not set for a run-as invoker view: " + viewName));
                return new MaterializedViewDefinition((ConnectorMaterializedViewDefinition)view, Identity.ofUser((String)runAsUser));
            });
        }
        Identity runAsIdentity = this.systemSecurityMetadata.getViewRunAsIdentity(session, viewName.asCatalogSchemaTableName()).or(() -> ((ConnectorMaterializedViewDefinition)connectorView.get()).getOwner().map(Identity::ofUser)).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Materialized view does not have an owner: " + viewName));
        return Optional.of(new MaterializedViewDefinition(connectorView.get(), runAsIdentity));
    }

    private Optional<ConnectorMaterializedViewDefinition> getMaterializedViewInternal(Session session, QualifiedObjectName viewName) {
        if (viewName.getCatalogName().isEmpty() || viewName.getSchemaName().isEmpty() || viewName.getObjectName().isEmpty()) {
            return Optional.empty();
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, viewName.getCatalogName());
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            CatalogName catalogName = catalogMetadata.getConnectorId(session, viewName);
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
            ConnectorSession connectorSession = session.toConnectorSession(catalogName);
            return metadata.getMaterializedView(connectorSession, viewName.asSchemaTableName());
        }
        return Optional.empty();
    }

    @Override
    public MaterializedViewFreshness getMaterializedViewFreshness(Session session, QualifiedObjectName viewName) {
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, viewName.getCatalogName());
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            CatalogName catalogName = catalogMetadata.getConnectorId(session, viewName);
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
            ConnectorSession connectorSession = session.toConnectorSession(catalogName);
            return metadata.getMaterializedViewFreshness(connectorSession, viewName.asSchemaTableName());
        }
        return new MaterializedViewFreshness(false);
    }

    @Override
    public void renameMaterializedView(Session session, QualifiedObjectName source, QualifiedObjectName target) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, target.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        if (!source.getCatalogName().equals(catalogName.getCatalogName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, "Cannot rename materialized views across catalogs");
        }
        metadata.renameMaterializedView(session.toConnectorSession(catalogName), source.asSchemaTableName(), target.asSchemaTableName());
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.tableRenamed(session, source.asCatalogSchemaTableName(), target.asCatalogSchemaTableName());
        }
    }

    @Override
    public void setMaterializedViewProperties(Session session, QualifiedObjectName viewName, Map<String, Optional<Object>> properties) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.setMaterializedViewProperties(session.toConnectorSession(catalogName), viewName.asSchemaTableName(), properties);
    }

    @Override
    public Optional<TableScanRedirectApplicationResult> applyTableScanRedirect(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyTableScanRedirect(connectorSession, tableHandle.getConnectorHandle());
    }

    private QualifiedObjectName getRedirectedTableName(Session session, QualifiedObjectName originalTableName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(originalTableName, "originalTableName is null");
        if (originalTableName.getCatalogName().isEmpty() || originalTableName.getSchemaName().isEmpty() || originalTableName.getObjectName().isEmpty()) {
            return originalTableName;
        }
        QualifiedObjectName tableName = originalTableName;
        LinkedHashSet<QualifiedObjectName> visitedTableNames = new LinkedHashSet<QualifiedObjectName>();
        visitedTableNames.add(tableName);
        for (int count = 0; count < 10; ++count) {
            CatalogName catalogName;
            Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, tableName.getCatalogName());
            if (catalog.isEmpty()) {
                return tableName;
            }
            CatalogMetadata catalogMetadata = catalog.get();
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName = catalogMetadata.getConnectorId(session, tableName));
            Optional<QualifiedObjectName> redirectedTableName = metadata.redirectTable(session.toConnectorSession(catalogName), tableName.asSchemaTableName()).map(name -> QualifiedObjectName.convertFromSchemaTableName(name.getCatalogName()).apply(name.getSchemaTableName()));
            if (redirectedTableName.isEmpty()) {
                return tableName;
            }
            tableName = redirectedTableName.get();
            if (visitedTableNames.add(tableName)) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TABLE_REDIRECTION_ERROR, String.format("Table redirections form a loop: %s", Streams.concat((Stream[])new Stream[]{visitedTableNames.stream(), Stream.of(tableName)}).map(QualifiedObjectName::toString).collect(Collectors.joining(" -> "))));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TABLE_REDIRECTION_ERROR, String.format("Table redirected too many times (%d): %s", 10, visitedTableNames));
    }

    @Override
    public RedirectionAwareTableHandle getRedirectionAwareTableHandle(Session session, QualifiedObjectName tableName) {
        return this.getRedirectionAwareTableHandle(session, tableName, Optional.empty(), Optional.empty());
    }

    @Override
    public RedirectionAwareTableHandle getRedirectionAwareTableHandle(Session session, QualifiedObjectName tableName, Optional<TableVersion> startVersion, Optional<TableVersion> endVersion) {
        QualifiedObjectName targetTableName = this.getRedirectedTableName(session, tableName);
        if (targetTableName.equals(tableName)) {
            return RedirectionAwareTableHandle.noRedirection(this.getTableHandle(session, tableName, startVersion, endVersion));
        }
        Optional<TableHandle> tableHandle = this.getTableHandle(session, targetTableName, startVersion, endVersion);
        if (tableHandle.isPresent()) {
            return RedirectionAwareTableHandle.withRedirectionTo(targetTableName, tableHandle.get());
        }
        if (this.getCatalogHandle(session, targetTableName.getCatalogName()).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TABLE_REDIRECTION_ERROR, String.format("Table '%s' redirected to '%s', but the target catalog '%s' does not exist", tableName, targetTableName, targetTableName.getCatalogName()));
        }
        if (!this.schemaExists(session, new CatalogSchemaName(targetTableName.getCatalogName(), targetTableName.getSchemaName()))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TABLE_REDIRECTION_ERROR, String.format("Table '%s' redirected to '%s', but the target schema '%s' does not exist", tableName, targetTableName, targetTableName.getSchemaName()));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TABLE_REDIRECTION_ERROR, String.format("Table '%s' redirected to '%s', but the target table '%s' does not exist", tableName, targetTableName, targetTableName));
    }

    @Override
    public Optional<ResolvedIndex> resolveIndex(Session session, TableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
        ConnectorTransactionHandle transaction = catalogMetadata.getTransactionHandleFor(catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        Optional resolvedIndex = metadata.resolveIndex(connectorSession, tableHandle.getConnectorHandle(), indexableColumns, outputColumns, tupleDomain);
        return resolvedIndex.map(resolved -> new ResolvedIndex(tableHandle.getCatalogName(), transaction, (ConnectorResolvedIndex)resolved));
    }

    @Override
    public Optional<LimitApplicationResult<TableHandle>> applyLimit(Session session, TableHandle table, long limit) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyLimit(connectorSession, table.getConnectorHandle(), limit).map(result -> new LimitApplicationResult((Object)new TableHandle(catalogName, (ConnectorTableHandle)result.getHandle(), table.getTransaction()), result.isLimitGuaranteed(), result.isPrecalculateStatistics()));
    }

    @Override
    public Optional<SampleApplicationResult<TableHandle>> applySample(Session session, TableHandle table, SampleType sampleType, double sampleRatio) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applySample(connectorSession, table.getConnectorHandle(), sampleType, sampleRatio).map(result -> new SampleApplicationResult((Object)new TableHandle(catalogName, (ConnectorTableHandle)result.getHandle(), table.getTransaction()), result.isPrecalculateStatistics()));
    }

    @Override
    public Optional<AggregationApplicationResult<TableHandle>> applyAggregation(Session session, TableHandle table, List<AggregateFunction> aggregations, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        Preconditions.checkArgument((!groupingSets.isEmpty() ? 1 : 0) != 0, (Object)"No grouping sets provided");
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyAggregation(connectorSession, table.getConnectorHandle(), aggregations, assignments, groupingSets).map(result -> {
            this.verifyProjection(table, result.getProjections(), result.getAssignments(), aggregations.size());
            return new AggregationApplicationResult((Object)new TableHandle(catalogName, (ConnectorTableHandle)result.getHandle(), table.getTransaction()), result.getProjections(), result.getAssignments(), result.getGroupingColumnMapping(), result.isPrecalculateStatistics());
        });
    }

    @Override
    public Optional<JoinApplicationResult<TableHandle>> applyJoin(Session session, JoinType joinType, TableHandle left, TableHandle right, List<JoinCondition> joinConditions, Map<String, ColumnHandle> leftAssignments, Map<String, ColumnHandle> rightAssignments, JoinStatistics statistics) {
        if (!right.getCatalogName().equals(left.getCatalogName())) {
            return Optional.empty();
        }
        CatalogName catalogName = left.getCatalogName();
        ConnectorTransactionHandle transaction = left.getTransaction();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        Optional connectorResult = metadata.applyJoin(connectorSession, joinType, left.getConnectorHandle(), right.getConnectorHandle(), joinConditions, leftAssignments, rightAssignments, statistics);
        return connectorResult.map(result -> {
            ImmutableSet leftColumnHandles = ImmutableSet.copyOf(this.getColumnHandles(session, left).values());
            ImmutableSet rightColumnHandles = ImmutableSet.copyOf(this.getColumnHandles(session, right).values());
            Set leftColumnHandlesMappingKeys = result.getLeftColumnHandles().keySet();
            Set rightColumnHandlesMappingKeys = result.getRightColumnHandles().keySet();
            if (leftColumnHandlesMappingKeys.size() != leftColumnHandles.size() || rightColumnHandlesMappingKeys.size() != rightColumnHandles.size() || !leftColumnHandlesMappingKeys.containsAll((Collection<?>)leftColumnHandles) || !rightColumnHandlesMappingKeys.containsAll((Collection<?>)rightColumnHandles)) {
                throw new IllegalStateException(String.format("Column handle mappings do not match old column handles: left=%s; right=%s; newLeft=%s, newRight=%s", leftColumnHandles, rightColumnHandles, leftColumnHandlesMappingKeys, rightColumnHandlesMappingKeys));
            }
            return new JoinApplicationResult((Object)new TableHandle(catalogName, (ConnectorTableHandle)result.getTableHandle(), transaction), result.getLeftColumnHandles(), result.getRightColumnHandles(), result.isPrecalculateStatistics());
        });
    }

    @Override
    public Optional<TopNApplicationResult<TableHandle>> applyTopN(Session session, TableHandle table, long topNCount, List<SortItem> sortItems, Map<String, ColumnHandle> assignments) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyTopN(connectorSession, table.getConnectorHandle(), topNCount, sortItems, assignments).map(result -> new TopNApplicationResult((Object)new TableHandle(catalogName, (ConnectorTableHandle)result.getHandle(), table.getTransaction()), result.isTopNGuaranteed(), result.isPrecalculateStatistics()));
    }

    private void verifyProjection(TableHandle table, List<ConnectorExpression> projections, List<Assignment> assignments, int expectedProjectionSize) {
        projections.forEach(projection -> Objects.requireNonNull(projection, "one of the projections is null"));
        assignments.forEach(assignment -> Objects.requireNonNull(assignment, "one of the assignments is null"));
        Verify.verify((expectedProjectionSize == projections.size() ? 1 : 0) != 0, (String)"ConnectorMetadata returned invalid number of projections: %s instead of %s for %s", (Object)projections.size(), (Object)expectedProjectionSize, (Object)table);
        Set assignedVariables = (Set)assignments.stream().map(Assignment::getVariable).collect(ImmutableSet.toImmutableSet());
        projections.stream().flatMap(connectorExpression -> ConnectorExpressions.extractVariables(connectorExpression).stream()).map(Variable::getName).filter(variableName -> !assignedVariables.contains(variableName)).findAny().ifPresent(variableName -> {
            throw new IllegalStateException("Unbound variable: " + variableName);
        });
    }

    @Override
    public void validateScan(Session session, TableHandle table) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        metadata.validateScan(session.toConnectorSession(catalogName), table.getConnectorHandle());
    }

    @Override
    public Optional<ConstraintApplicationResult<TableHandle>> applyFilter(Session session, TableHandle table, Constraint constraint) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyFilter(connectorSession, table.getConnectorHandle(), constraint).map(result -> result.transform(handle -> new TableHandle(catalogName, (ConnectorTableHandle)handle, table.getTransaction())));
    }

    @Override
    public Optional<ProjectionApplicationResult<TableHandle>> applyProjection(Session session, TableHandle table, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyProjection(connectorSession, table.getConnectorHandle(), projections, assignments).map(result -> {
            this.verifyProjection(table, result.getProjections(), result.getAssignments(), projections.size());
            return new ProjectionApplicationResult((Object)new TableHandle(catalogName, (ConnectorTableHandle)result.getHandle(), table.getTransaction()), result.getProjections(), result.getAssignments(), result.isPrecalculateStatistics());
        });
    }

    @Override
    public boolean isCatalogManagedSecurity(Session session, String catalog) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, new CatalogName(catalog));
        return catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.CONNECTOR;
    }

    @Override
    public boolean roleExists(Session session, String role, Optional<String> catalog) {
        if (catalog.isEmpty()) {
            return this.systemSecurityMetadata.roleExists(session, role);
        }
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, new CatalogName(catalog.get()));
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        return metadata.roleExists(session.toConnectorSession(catalogName), role);
    }

    @Override
    public void createRole(Session session, String role, Optional<TrinoPrincipal> grantor, Optional<String> catalog) {
        if (catalog.isEmpty()) {
            this.systemSecurityMetadata.createRole(session, role, grantor);
            return;
        }
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog.get());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.createRole(session.toConnectorSession(catalogName), role, grantor);
    }

    @Override
    public void dropRole(Session session, String role, Optional<String> catalog) {
        if (catalog.isEmpty()) {
            this.systemSecurityMetadata.dropRole(session, role);
            return;
        }
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog.get());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.dropRole(session.toConnectorSession(catalogName), role);
    }

    @Override
    public Set<String> listRoles(Session session, Optional<String> catalog) {
        if (catalog.isPresent()) {
            Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog.get());
            if (catalogMetadata.isEmpty()) {
                return ImmutableSet.of();
            }
            if (catalogMetadata.get().getSecurityManagement() == Catalog.SecurityManagement.CONNECTOR) {
                CatalogName catalogName = catalogMetadata.get().getCatalogName();
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(session, catalogName);
                return (Set)metadata.listRoles(connectorSession).stream().map(role -> role.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
            }
        }
        return this.systemSecurityMetadata.listRoles(session);
    }

    @Override
    public Set<RoleGrant> listAllRoleGrants(Session session, Optional<String> catalog, Optional<Set<String>> roles, Optional<Set<String>> grantees, OptionalLong limit) {
        if (catalog.isPresent()) {
            Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog.get());
            if (catalogMetadata.isEmpty()) {
                return ImmutableSet.of();
            }
            if (catalogMetadata.get().getSecurityManagement() == Catalog.SecurityManagement.CONNECTOR) {
                CatalogName catalogName = catalogMetadata.get().getCatalogName();
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(session, catalogName);
                return metadata.listAllRoleGrants(connectorSession, roles, grantees, limit);
            }
        }
        return this.systemSecurityMetadata.listAllRoleGrants(session, roles, grantees, limit);
    }

    @Override
    public Set<RoleGrant> listRoleGrants(Session session, Optional<String> catalog, TrinoPrincipal principal) {
        if (catalog.isPresent()) {
            Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog.get());
            if (catalogMetadata.isEmpty()) {
                return ImmutableSet.of();
            }
            if (catalogMetadata.get().getSecurityManagement() == Catalog.SecurityManagement.CONNECTOR) {
                CatalogName catalogName = catalogMetadata.get().getCatalogName();
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(session, catalogName);
                return metadata.listRoleGrants(connectorSession, principal);
            }
        }
        return this.systemSecurityMetadata.listRoleGrants(session, principal);
    }

    @Override
    public void grantRoles(Session session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalog) {
        if (catalog.isEmpty()) {
            this.systemSecurityMetadata.grantRoles(session, roles, grantees, adminOption, grantor);
            return;
        }
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog.get());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.grantRoles(session.toConnectorSession(catalogName), roles, grantees, adminOption, grantor);
    }

    @Override
    public void revokeRoles(Session session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalog) {
        if (catalog.isEmpty()) {
            this.systemSecurityMetadata.revokeRoles(session, roles, grantees, adminOption, grantor);
            return;
        }
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog.get());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.revokeRoles(session.toConnectorSession(catalogName), roles, grantees, adminOption, grantor);
    }

    @Override
    public Set<RoleGrant> listApplicableRoles(Session session, TrinoPrincipal principal, Optional<String> catalog) {
        if (catalog.isPresent()) {
            Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog.get());
            if (catalogMetadata.isEmpty()) {
                return ImmutableSet.of();
            }
            if (catalogMetadata.get().getSecurityManagement() == Catalog.SecurityManagement.CONNECTOR) {
                CatalogName catalogName = catalogMetadata.get().getCatalogName();
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(session, catalogName);
                return ImmutableSet.copyOf((Collection)metadata.listApplicableRoles(connectorSession, principal));
            }
        }
        return this.systemSecurityMetadata.listApplicableRoles(session, principal);
    }

    @Override
    public Set<String> listEnabledRoles(Identity identity) {
        return this.systemSecurityMetadata.listEnabledRoles(identity);
    }

    @Override
    public Set<String> listEnabledRoles(Session session, String catalog) {
        Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog);
        if (catalogMetadata.isEmpty()) {
            return ImmutableSet.of();
        }
        if (catalogMetadata.get().getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            return this.systemSecurityMetadata.listEnabledRoles(session.getIdentity());
        }
        CatalogName catalogName = catalogMetadata.get().getCatalogName();
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(session, catalogName);
        return ImmutableSet.copyOf((Collection)metadata.listEnabledRoles(connectorSession));
    }

    @Override
    public void grantTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, tableName.getCatalogName());
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.grantTablePrivileges(session, tableName, privileges, grantee, grantOption);
            return;
        }
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.grantTablePrivileges(session.toConnectorSession(catalogName), tableName.asSchemaTableName(), privileges, grantee, grantOption);
    }

    @Override
    public void denyTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, tableName.getCatalogName());
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.denyTablePrivileges(session, tableName, privileges, grantee);
            return;
        }
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.denyTablePrivileges(session.toConnectorSession(catalogName), tableName.asSchemaTableName(), privileges, grantee);
    }

    @Override
    public void revokeTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, tableName.getCatalogName());
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.revokeTablePrivileges(session, tableName, privileges, grantee, grantOption);
            return;
        }
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.revokeTablePrivileges(session.toConnectorSession(catalogName), tableName.asSchemaTableName(), privileges, grantee, grantOption);
    }

    @Override
    public void grantSchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schemaName.getCatalogName());
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.grantSchemaPrivileges(session, schemaName, privileges, grantee, grantOption);
            return;
        }
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.grantSchemaPrivileges(session.toConnectorSession(catalogName), schemaName.getSchemaName(), privileges, grantee, grantOption);
    }

    @Override
    public void denySchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schemaName.getCatalogName());
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.denySchemaPrivileges(session, schemaName, privileges, grantee);
            return;
        }
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.denySchemaPrivileges(session.toConnectorSession(catalogName), schemaName.getSchemaName(), privileges, grantee);
    }

    @Override
    public void revokeSchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schemaName.getCatalogName());
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
            this.systemSecurityMetadata.revokeSchemaPrivileges(session, schemaName, privileges, grantee, grantOption);
            return;
        }
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata(session);
        metadata.revokeSchemaPrivileges(session.toConnectorSession(catalogName), schemaName.getSchemaName(), privileges, grantee, grantOption);
    }

    @Override
    public List<GrantInfo> listTablePrivileges(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        ImmutableSet.Builder grantInfos = ImmutableSet.builder();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getCatalogName());
            List connectorIds = prefix.asQualifiedObjectName().map(qualifiedTableName -> Collections.singletonList(catalogMetadata.getConnectorId(session, (QualifiedObjectName)qualifiedTableName))).orElseGet(catalogMetadata::listConnectorIds);
            for (CatalogName catalogName : connectorIds) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, catalogName);
                if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.SYSTEM) {
                    grantInfos.addAll(this.systemSecurityMetadata.listTablePrivileges(session, prefix));
                    continue;
                }
                grantInfos.addAll((Iterable)metadata.listTablePrivileges(connectorSession, prefix.asSchemaTablePrefix()));
            }
        }
        return ImmutableList.copyOf((Collection)grantInfos.build());
    }

    @Override
    public Collection<FunctionMetadata> listFunctions() {
        return this.functions.listFunctions();
    }

    @Override
    public ResolvedFunction decodeFunction(QualifiedName name) {
        return this.functionDecoder.fromQualifiedName(name).orElseThrow(() -> new IllegalArgumentException("Function is not resolved: " + name));
    }

    @Override
    public ResolvedFunction resolveFunction(Session session, QualifiedName name, List<TypeSignatureProvider> parameterTypes) {
        return this.resolvedFunctionInternal(session, name, parameterTypes);
    }

    @Override
    public ResolvedFunction resolveOperator(Session session, OperatorType operatorType, List<? extends Type> argumentTypes) throws OperatorNotFoundException {
        try {
            return (ResolvedFunction)CacheUtils.uncheckedCacheGet(this.operatorCache, (Object)new OperatorCacheKey(operatorType, argumentTypes), () -> {
                String name = Signature.mangleOperatorName(operatorType);
                return this.resolvedFunctionInternal(session, QualifiedName.of((String)name), TypeSignatureProvider.fromTypes(argumentTypes));
            });
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof TrinoException) {
                TrinoException cause = (TrinoException)e.getCause();
                if (cause.getErrorCode().getCode() == StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode().getCode()) {
                    throw new OperatorNotFoundException(operatorType, argumentTypes, cause);
                }
                throw cause;
            }
            throw e;
        }
    }

    private ResolvedFunction resolvedFunctionInternal(Session session, QualifiedName name, List<TypeSignatureProvider> parameterTypes) {
        return this.functionDecoder.fromQualifiedName(name).orElseGet(() -> this.resolve(session, this.functionResolver.resolveFunction(session, this.functions.getFunctions(name), name, parameterTypes)));
    }

    @Override
    public ResolvedFunction getCoercion(Session session, OperatorType operatorType, Type fromType, Type toType) {
        Preconditions.checkArgument((operatorType == OperatorType.CAST || operatorType == OperatorType.SATURATED_FLOOR_CAST ? 1 : 0) != 0);
        try {
            return (ResolvedFunction)CacheUtils.uncheckedCacheGet(this.coercionCache, (Object)new CoercionCacheKey(operatorType, fromType, toType), () -> {
                String name = Signature.mangleOperatorName(operatorType);
                FunctionBinding functionBinding = this.functionResolver.resolveCoercion(session, this.functions.getFunctions(QualifiedName.of((String)name)), new Signature(name, toType.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)fromType.getTypeSignature())));
                return this.resolve(session, functionBinding);
            });
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof TrinoException) {
                TrinoException cause = (TrinoException)e.getCause();
                if (cause.getErrorCode().getCode() == StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING.toErrorCode().getCode()) {
                    throw new OperatorNotFoundException(operatorType, (List<? extends Type>)ImmutableList.of((Object)fromType), toType.getTypeSignature(), cause);
                }
                throw cause;
            }
            throw e;
        }
    }

    @Override
    public ResolvedFunction getCoercion(Session session, QualifiedName name, Type fromType, Type toType) {
        FunctionBinding functionBinding = this.functionResolver.resolveCoercion(session, this.functions.getFunctions(name), new Signature(name.getSuffix(), toType.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)fromType.getTypeSignature())));
        return this.resolve(session, functionBinding);
    }

    private ResolvedFunction resolve(Session session, FunctionBinding functionBinding) {
        FunctionDependencyDeclaration declaration = this.functions.getFunctionDependencies(functionBinding.getFunctionId(), functionBinding.getBoundSignature());
        FunctionMetadata functionMetadata = this.getFunctionMetadata(functionBinding.getFunctionId(), functionBinding.getBoundSignature());
        return this.resolve(session, functionBinding, functionMetadata, declaration);
    }

    @VisibleForTesting
    public ResolvedFunction resolve(Session session, FunctionBinding functionBinding, FunctionMetadata functionMetadata, FunctionDependencyDeclaration declaration) {
        Map dependentTypes = (Map)declaration.getTypeDependencies().stream().map(typeSignature -> SignatureBinder.applyBoundVariables(typeSignature, functionBinding)).collect(ImmutableMap.toImmutableMap(Function.identity(), arg_0 -> ((TypeManager)this.typeManager).getType(arg_0), (left, right) -> left));
        ImmutableSet.Builder functions = ImmutableSet.builder();
        declaration.getFunctionDependencies().stream().map(functionDependency -> {
            try {
                List<TypeSignature> argumentTypes = SignatureBinder.applyBoundVariables(functionDependency.getArgumentTypes(), functionBinding);
                return this.resolvedFunctionInternal(session, functionDependency.getName(), TypeSignatureProvider.fromTypeSignatures(argumentTypes));
            }
            catch (TrinoException e) {
                if (functionDependency.isOptional()) {
                    return null;
                }
                throw e;
            }
        }).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableSet.Builder)functions).add(arg_0));
        declaration.getOperatorDependencies().stream().map(operatorDependency -> {
            try {
                List<TypeSignature> argumentTypes = SignatureBinder.applyBoundVariables(operatorDependency.getArgumentTypes(), functionBinding);
                return this.resolvedFunctionInternal(session, QualifiedName.of((String)Signature.mangleOperatorName(operatorDependency.getOperatorType())), TypeSignatureProvider.fromTypeSignatures(argumentTypes));
            }
            catch (TrinoException e) {
                if (operatorDependency.isOptional()) {
                    return null;
                }
                throw e;
            }
        }).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableSet.Builder)functions).add(arg_0));
        declaration.getCastDependencies().stream().map(castDependency -> {
            try {
                Type fromType = this.typeManager.getType(SignatureBinder.applyBoundVariables(castDependency.getFromType(), functionBinding));
                Type toType = this.typeManager.getType(SignatureBinder.applyBoundVariables(castDependency.getToType(), functionBinding));
                return this.getCoercion(session, fromType, toType);
            }
            catch (TrinoException e) {
                if (castDependency.isOptional()) {
                    return null;
                }
                throw e;
            }
        }).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableSet.Builder)functions).add(arg_0));
        return new ResolvedFunction(functionBinding.getBoundSignature(), functionBinding.getFunctionId(), functionMetadata.getKind(), functionMetadata.isDeterministic(), functionMetadata.getFunctionNullability(), dependentTypes, (Set<ResolvedFunction>)functions.build());
    }

    @Override
    public boolean isAggregationFunction(QualifiedName name) {
        return this.functions.getFunctions(name).stream().map(FunctionMetadata::getKind).anyMatch(FunctionKind.AGGREGATE::equals);
    }

    @Override
    public FunctionMetadata getFunctionMetadata(ResolvedFunction resolvedFunction) {
        return this.getFunctionMetadata(resolvedFunction.getFunctionId(), resolvedFunction.getSignature());
    }

    private FunctionMetadata getFunctionMetadata(FunctionId functionId, BoundSignature signature) {
        FunctionMetadata functionMetadata = this.functions.getFunctionMetadata(functionId);
        ImmutableList argumentNullability = functionMetadata.getFunctionNullability().getArgumentNullable();
        if (functionMetadata.getSignature().isVariableArity()) {
            List<Boolean> fixedArgumentNullability = argumentNullability.subList(0, argumentNullability.size() - 1);
            int variableArgumentCount = signature.getArgumentTypes().size() - fixedArgumentNullability.size();
            argumentNullability = ImmutableList.builder().addAll(fixedArgumentNullability).addAll(Collections.nCopies(variableArgumentCount, argumentNullability.get(argumentNullability.size() - 1))).build();
        }
        return new FunctionMetadata(functionMetadata.getFunctionId(), signature.toSignature(), functionMetadata.getCanonicalName(), new FunctionNullability(functionMetadata.getFunctionNullability().isReturnNullable(), (List<Boolean>)argumentNullability), functionMetadata.isHidden(), functionMetadata.isDeterministic(), functionMetadata.getDescription(), functionMetadata.getKind(), functionMetadata.isDeprecated());
    }

    @Override
    public AggregationFunctionMetadata getAggregationFunctionMetadata(ResolvedFunction resolvedFunction) {
        AggregationFunctionMetadata aggregationFunctionMetadata = this.functions.getAggregationFunctionMetadata(resolvedFunction.getFunctionId());
        List intermediateTypes = aggregationFunctionMetadata.getIntermediateTypes();
        if (!intermediateTypes.isEmpty()) {
            FunctionBinding functionBinding = this.toFunctionBinding(resolvedFunction);
            intermediateTypes = (List)aggregationFunctionMetadata.getIntermediateTypes().stream().map(typeSignature -> SignatureBinder.applyBoundVariables(typeSignature, functionBinding)).collect(ImmutableList.toImmutableList());
        }
        return new AggregationFunctionMetadata(aggregationFunctionMetadata.isOrderSensitive(), intermediateTypes);
    }

    private FunctionBinding toFunctionBinding(ResolvedFunction resolvedFunction) {
        Signature functionSignature = this.functions.getFunctionMetadata(resolvedFunction.getFunctionId()).getSignature();
        return MetadataManager.toFunctionBinding(resolvedFunction.getFunctionId(), resolvedFunction.getSignature(), functionSignature);
    }

    @VisibleForTesting
    public static FunctionBinding toFunctionBinding(FunctionId functionId, BoundSignature boundSignature, Signature functionSignature) {
        return SignatureBinder.bindFunction(functionId, functionSignature, boundSignature);
    }

    private static Optional<CatalogSchemaTableName> getTableNameIfSystemSecurity(Session session, CatalogMetadata catalogMetadata, TableHandle tableHandle) {
        if (catalogMetadata.getSecurityManagement() == Catalog.SecurityManagement.CONNECTOR) {
            return Optional.empty();
        }
        SchemaTableName schemaTableName = catalogMetadata.getMetadata(session).getSchemaTableName(session.toConnectorSession(tableHandle.getCatalogName()), tableHandle.getConnectorHandle());
        return Optional.of(new CatalogSchemaTableName(tableHandle.getCatalogName().getCatalogName(), schemaTableName));
    }

    private Optional<CatalogMetadata> getOptionalCatalogMetadata(Session session, String catalogName) {
        Optional<CatalogMetadata> optionalCatalogMetadata = this.transactionManager.getOptionalCatalogMetadata(session.getRequiredTransactionId(), catalogName);
        optionalCatalogMetadata.ifPresent(catalogMetadata -> this.registerCatalogForQuery(session, (CatalogMetadata)catalogMetadata));
        return optionalCatalogMetadata;
    }

    private CatalogMetadata getCatalogMetadata(Session session, CatalogName catalogName) {
        CatalogMetadata catalogMetadata = this.transactionManager.getCatalogMetadata(session.getRequiredTransactionId(), catalogName);
        this.registerCatalogForQuery(session, catalogMetadata);
        return catalogMetadata;
    }

    private CatalogMetadata getCatalogMetadataForWrite(Session session, String catalogName) {
        CatalogMetadata catalogMetadata = this.transactionManager.getCatalogMetadataForWrite(session.getRequiredTransactionId(), catalogName);
        this.registerCatalogForQuery(session, catalogMetadata);
        return catalogMetadata;
    }

    private CatalogMetadata getCatalogMetadataForWrite(Session session, CatalogName catalogName) {
        CatalogMetadata catalogMetadata = this.transactionManager.getCatalogMetadataForWrite(session.getRequiredTransactionId(), catalogName);
        this.registerCatalogForQuery(session, catalogMetadata);
        return catalogMetadata;
    }

    private ConnectorMetadata getMetadata(Session session, CatalogName catalogName) {
        return this.getCatalogMetadata(session, catalogName).getMetadataFor(session, catalogName);
    }

    private ConnectorMetadata getMetadataForWrite(Session session, CatalogName catalogName) {
        return this.getCatalogMetadataForWrite(session, catalogName).getMetadata(session);
    }

    private void registerCatalogForQuery(Session session, CatalogMetadata catalogMetadata) {
        this.catalogsByQueryId.computeIfAbsent(session.getQueryId(), queryId -> new QueryCatalogs(session)).registerCatalog(catalogMetadata);
    }

    @VisibleForTesting
    public Set<QueryId> getActiveQueryIds() {
        return ImmutableSet.copyOf(this.catalogsByQueryId.keySet());
    }

    @Override
    public boolean isValidTableVersion(Session session, QualifiedObjectName tableName, TableVersion version) {
        Objects.requireNonNull(version, "Version must not be null for table " + tableName);
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, tableName.getCatalogName());
        if (!catalog.isPresent()) {
            return false;
        }
        CatalogMetadata catalogMetadata = catalog.get();
        CatalogName connectorId = catalogMetadata.getConnectorId(session, tableName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(session, connectorId);
        return metadata.isSupportedVersionType(session.toConnectorSession(), tableName.asSchemaTableName(), version.getPointerType(), version.getObjectType());
    }

    private Optional<ConnectorTableVersion> toConnectorVersion(Optional<TableVersion> version) {
        Optional<ConnectorTableVersion> connectorVersion = Optional.empty();
        if (version.isPresent()) {
            connectorVersion = Optional.of(new ConnectorTableVersion(version.get().getPointerType(), version.get().getObjectType(), version.get().getPointer()));
        }
        return connectorVersion;
    }

    public static MetadataManager createTestMetadataManager() {
        return MetadataManager.testMetadataManagerBuilder().build();
    }

    public static TestMetadataManagerBuilder testMetadataManagerBuilder() {
        return new TestMetadataManagerBuilder();
    }

    public static class TestMetadataManagerBuilder {
        private FeaturesConfig featuresConfig;
        private TransactionManager transactionManager;
        private TypeManager typeManager = InternalTypeManager.TESTING_TYPE_MANAGER;
        private GlobalFunctionCatalog globalFunctionCatalog;

        private TestMetadataManagerBuilder() {
        }

        public TestMetadataManagerBuilder withCatalogManager(CatalogManager catalogManager) {
            this.transactionManager = InMemoryTransactionManager.createTestTransactionManager(catalogManager);
            return this;
        }

        public TestMetadataManagerBuilder withFeaturesConfig(FeaturesConfig featuresConfig) {
            this.featuresConfig = featuresConfig;
            return this;
        }

        public TestMetadataManagerBuilder withTransactionManager(TransactionManager transactionManager) {
            this.transactionManager = transactionManager;
            return this;
        }

        public TestMetadataManagerBuilder withTypeManager(TypeManager typeManager) {
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
            return this;
        }

        public TestMetadataManagerBuilder withGlobalFunctionCatalog(GlobalFunctionCatalog globalFunctionCatalog) {
            this.globalFunctionCatalog = globalFunctionCatalog;
            return this;
        }

        public MetadataManager build() {
            GlobalFunctionCatalog globalFunctionCatalog;
            TransactionManager transactionManager;
            FeaturesConfig featuresConfig = this.featuresConfig;
            if (featuresConfig == null) {
                featuresConfig = new FeaturesConfig();
            }
            if ((transactionManager = this.transactionManager) == null) {
                transactionManager = InMemoryTransactionManager.createTestTransactionManager();
            }
            if ((globalFunctionCatalog = this.globalFunctionCatalog) == null) {
                globalFunctionCatalog = new GlobalFunctionCatalog();
                TypeOperators typeOperators = new TypeOperators();
                globalFunctionCatalog.addFunctions(SystemFunctionBundle.create(featuresConfig, typeOperators, new BlockTypeOperators(typeOperators), NodeVersion.UNKNOWN));
                globalFunctionCatalog.addFunctions(new InternalFunctionBundle(new LiteralFunction(new InternalBlockEncodingSerde(new BlockEncodingManager(), this.typeManager))));
            }
            return new MetadataManager(featuresConfig, new DisabledSystemSecurityMetadata(), transactionManager, globalFunctionCatalog, this.typeManager);
        }
    }

    private static class CoercionCacheKey {
        private final OperatorType operatorType;
        private final Type fromType;
        private final Type toType;

        private CoercionCacheKey(OperatorType operatorType, Type fromType, Type toType) {
            this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
            this.fromType = Objects.requireNonNull(fromType, "fromType is null");
            this.toType = Objects.requireNonNull(toType, "toType is null");
        }

        public OperatorType getOperatorType() {
            return this.operatorType;
        }

        public Type getFromType() {
            return this.fromType;
        }

        public Type getToType() {
            return this.toType;
        }

        public int hashCode() {
            return Objects.hash(this.operatorType, this.fromType, this.toType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CoercionCacheKey)) {
                return false;
            }
            CoercionCacheKey other = (CoercionCacheKey)obj;
            return Objects.equals(this.operatorType, other.operatorType) && Objects.equals(this.fromType, other.fromType) && Objects.equals(this.toType, other.toType);
        }
    }

    private static class OperatorCacheKey {
        private final OperatorType operatorType;
        private final List<? extends Type> argumentTypes;

        private OperatorCacheKey(OperatorType operatorType, List<? extends Type> argumentTypes) {
            this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
            this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        }

        public OperatorType getOperatorType() {
            return this.operatorType;
        }

        public List<? extends Type> getArgumentTypes() {
            return this.argumentTypes;
        }

        public int hashCode() {
            return Objects.hash(this.operatorType, this.argumentTypes);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof OperatorCacheKey)) {
                return false;
            }
            OperatorCacheKey other = (OperatorCacheKey)obj;
            return Objects.equals(this.operatorType, other.operatorType) && Objects.equals(this.argumentTypes, other.argumentTypes);
        }
    }

    private static class QueryCatalogs {
        private final Session session;
        @GuardedBy(value="this")
        private final Map<CatalogName, CatalogMetadata> catalogs = new HashMap<CatalogName, CatalogMetadata>();
        @GuardedBy(value="this")
        private boolean finished;

        public QueryCatalogs(Session session) {
            this.session = Objects.requireNonNull(session, "session is null");
        }

        private synchronized void registerCatalog(CatalogMetadata catalogMetadata) {
            Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"Query is already finished");
            if (this.catalogs.putIfAbsent(catalogMetadata.getCatalogName(), catalogMetadata) == null) {
                ConnectorSession connectorSession = this.session.toConnectorSession(catalogMetadata.getCatalogName());
                catalogMetadata.getMetadata(this.session).beginQuery(connectorSession);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void finish() {
            ArrayList<CatalogMetadata> catalogs;
            QueryCatalogs queryCatalogs = this;
            synchronized (queryCatalogs) {
                Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"Query is already finished");
                this.finished = true;
                catalogs = new ArrayList<CatalogMetadata>(this.catalogs.values());
            }
            for (CatalogMetadata catalogMetadata : catalogs) {
                ConnectorSession connectorSession = this.session.toConnectorSession(catalogMetadata.getCatalogName());
                catalogMetadata.getMetadata(this.session).cleanupQuery(connectorSession);
            }
        }
    }
}

