/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import io.airlift.compress.zstd.ZstdCompressor;
import io.airlift.compress.zstd.ZstdDecompressor;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.collect.cache.NonEvictableLoadingCache;
import io.trino.collect.cache.SafeCaches;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionId;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionNullability;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.tree.QualifiedName;
import io.trino.type.TypeDeserializer;
import io.trino.type.TypeSignatureDeserializer;
import io.trino.type.TypeSignatureKeyDeserializer;
import io.trino.util.ThreadLocalCompressorDecompressor;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Provider;

public class ResolvedFunction {
    private static final String PREFIX = "@";
    private final BoundSignature signature;
    private final FunctionId functionId;
    private final FunctionKind functionKind;
    private final boolean deterministic;
    private final FunctionNullability functionNullability;
    private final Map<TypeSignature, Type> typeDependencies;
    private final Set<ResolvedFunction> functionDependencies;

    @JsonCreator
    public ResolvedFunction(@JsonProperty(value="signature") BoundSignature signature, @JsonProperty(value="id") FunctionId functionId, @JsonProperty(value="functionKind") FunctionKind functionKind, @JsonProperty(value="deterministic") boolean deterministic, @JsonProperty(value="nullability") FunctionNullability functionNullability, @JsonProperty(value="typeDependencies") Map<TypeSignature, Type> typeDependencies, @JsonProperty(value="functionDependencies") Set<ResolvedFunction> functionDependencies) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.functionId = Objects.requireNonNull(functionId, "functionId is null");
        this.functionKind = Objects.requireNonNull(functionKind, "functionKind is null");
        this.deterministic = deterministic;
        this.functionNullability = Objects.requireNonNull(functionNullability, "nullability is null");
        this.typeDependencies = ImmutableMap.copyOf(Objects.requireNonNull(typeDependencies, "typeDependencies is null"));
        this.functionDependencies = ImmutableSet.copyOf((Collection)Objects.requireNonNull(functionDependencies, "functionDependencies is null"));
        Preconditions.checkArgument((functionNullability.getArgumentNullable().size() == signature.getArgumentTypes().size() ? 1 : 0) != 0, (Object)"signature and functionNullability must have same argument count");
    }

    @JsonProperty
    public BoundSignature getSignature() {
        return this.signature;
    }

    @JsonProperty(value="id")
    public FunctionId getFunctionId() {
        return this.functionId;
    }

    @JsonProperty(value="functionKind")
    public FunctionKind getFunctionKind() {
        return this.functionKind;
    }

    @JsonProperty
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @JsonProperty
    public FunctionNullability getFunctionNullability() {
        return this.functionNullability;
    }

    @JsonProperty
    public Map<TypeSignature, Type> getTypeDependencies() {
        return this.typeDependencies;
    }

    @JsonProperty
    public Set<ResolvedFunction> getFunctionDependencies() {
        return this.functionDependencies;
    }

    public static boolean isResolved(QualifiedName name) {
        return name.getSuffix().startsWith(PREFIX);
    }

    public QualifiedName toQualifiedName() {
        return ResolvedFunctionDecoder.toQualifiedName(this);
    }

    public static String extractFunctionName(QualifiedName qualifiedName) {
        String data = qualifiedName.getSuffix();
        if (!data.startsWith(PREFIX)) {
            return data;
        }
        List parts = Splitter.on((String)PREFIX).splitToList(data.subSequence(1, data.length()));
        Preconditions.checkArgument((parts.size() == 2 ? 1 : 0) != 0, (String)"Expected encoded resolved function to contain two parts: %s", (Object)qualifiedName);
        return (String)parts.get(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedFunction that = (ResolvedFunction)o;
        return Objects.equals(this.signature, that.signature) && Objects.equals(this.functionId, that.functionId) && Objects.equals((Object)this.functionKind, (Object)that.functionKind) && this.deterministic == that.deterministic && Objects.equals(this.typeDependencies, that.typeDependencies) && Objects.equals(this.functionDependencies, that.functionDependencies);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signature, this.functionId, this.functionKind, this.deterministic, this.typeDependencies, this.functionDependencies});
    }

    public String toString() {
        return this.signature.toString();
    }

    public static class ResolvedFunctionDecoder {
        private static final JsonCodec<ResolvedFunction> SERIALIZE_JSON_CODEC = new JsonCodecFactory().jsonCodec(ResolvedFunction.class);
        private static final ThreadLocalCompressorDecompressor COMPRESSOR_DECOMPRESSOR = new ThreadLocalCompressorDecompressor(ZstdCompressor::new, ZstdDecompressor::new);
        private final NonEvictableLoadingCache<QualifiedName, ResolvedFunction> resolvedFunctions = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1024L), (CacheLoader)CacheLoader.from(this::deserialize));
        private static final NonEvictableLoadingCache<ResolvedFunction, QualifiedName> qualifiedNames = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1024L), (CacheLoader)CacheLoader.from(ResolvedFunctionDecoder::serialize));
        private final JsonCodec<ResolvedFunction> jsonCodec;

        public ResolvedFunctionDecoder(Function<TypeId, Type> typeLoader) {
            ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
            objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)((Object)new TypeDeserializer(typeLoader)), TypeSignature.class, (Object)((Object)new TypeSignatureDeserializer())));
            objectMapperProvider.setKeyDeserializers((Map)ImmutableMap.of(TypeSignature.class, (Object)((Object)new TypeSignatureKeyDeserializer())));
            this.jsonCodec = new JsonCodecFactory((Provider)objectMapperProvider).jsonCodec(ResolvedFunction.class);
        }

        public Optional<ResolvedFunction> fromQualifiedName(QualifiedName qualifiedName) {
            if (!qualifiedName.getSuffix().startsWith(ResolvedFunction.PREFIX)) {
                return Optional.empty();
            }
            return Optional.of((ResolvedFunction)this.resolvedFunctions.getUnchecked((Object)qualifiedName));
        }

        public static QualifiedName toQualifiedName(ResolvedFunction function) {
            return (QualifiedName)qualifiedNames.getUnchecked((Object)function);
        }

        private ResolvedFunction deserialize(QualifiedName qualifiedName) {
            String data = qualifiedName.getSuffix();
            List parts = Splitter.on((String)ResolvedFunction.PREFIX).splitToList((CharSequence)data.substring(1));
            Preconditions.checkArgument((parts.size() == 2 ? 1 : 0) != 0, (String)"Expected encoded resolved function to contain two parts: %s", (Object)qualifiedName);
            String base32 = (String)parts.get(1);
            base32 = base32.toUpperCase(Locale.ENGLISH);
            byte[] compressed = BaseEncoding.base32Hex().decode((CharSequence)base32);
            ByteBuffer decompressed = ByteBuffer.allocate(Math.toIntExact(ZstdDecompressor.getDecompressedSize((byte[])compressed, (int)0, (int)compressed.length)));
            COMPRESSOR_DECOMPRESSOR.decompress(ByteBuffer.wrap(compressed), decompressed);
            ResolvedFunction resolvedFunction = (ResolvedFunction)this.jsonCodec.fromJson(Arrays.copyOf(decompressed.array(), decompressed.position()));
            Preconditions.checkArgument((boolean)resolvedFunction.getSignature().getName().equalsIgnoreCase((String)parts.get(0)), (String)"Expected decoded function to have name %s, but name is %s", (Object)resolvedFunction.getSignature().getName(), parts.get(0));
            return resolvedFunction;
        }

        private static QualifiedName serialize(ResolvedFunction function) {
            byte[] value = SERIALIZE_JSON_CODEC.toJsonBytes((Object)function);
            ByteBuffer compressed = ByteBuffer.allocate(COMPRESSOR_DECOMPRESSOR.maxCompressedLength(value.length));
            COMPRESSOR_DECOMPRESSOR.compress(ByteBuffer.wrap(value), compressed);
            String base32 = BaseEncoding.base32Hex().encode(compressed.array(), 0, compressed.position());
            return QualifiedName.of((String)(ResolvedFunction.PREFIX + function.signature.getName() + ResolvedFunction.PREFIX + base32));
        }
    }
}

