/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.operator.GroupByHash;
import io.trino.operator.GroupByIdBlock;
import io.trino.operator.TransformWork;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.JoinCompiler;
import io.trino.type.BlockTypeOperators;
import java.util.List;
import java.util.Optional;

public class MarkDistinctHash {
    private final GroupByHash groupByHash;
    private long nextDistinctId;

    public MarkDistinctHash(Session session, List<Type> types, int[] channels, Optional<Integer> hashChannel, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators, UpdateMemory updateMemory) {
        this(session, types, channels, hashChannel, 10000, joinCompiler, blockTypeOperators, updateMemory);
    }

    public MarkDistinctHash(Session session, List<Type> types, int[] channels, Optional<Integer> hashChannel, int expectedDistinctValues, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators, UpdateMemory updateMemory) {
        this.groupByHash = GroupByHash.createGroupByHash(session, types, channels, hashChannel, expectedDistinctValues, joinCompiler, blockTypeOperators, updateMemory);
    }

    public long getEstimatedSize() {
        return this.groupByHash.getEstimatedSize();
    }

    public Work<Block> markDistinctRows(Page page) {
        return new TransformWork<GroupByIdBlock, Block>(this.groupByHash.getGroupIds(page), this::processNextGroupIds);
    }

    @VisibleForTesting
    public int getCapacity() {
        return this.groupByHash.getCapacity();
    }

    private Block processNextGroupIds(GroupByIdBlock ids) {
        int positions = ids.getPositionCount();
        if (positions > 1) {
            if (this.nextDistinctId == ids.getGroupCount()) {
                return new RunLengthEncodedBlock(BooleanType.createBlockForSingleNonNullValue((boolean)false), positions);
            }
            if (this.nextDistinctId + (long)positions == ids.getGroupCount()) {
                this.nextDistinctId = ids.getGroupCount();
                return new RunLengthEncodedBlock(BooleanType.createBlockForSingleNonNullValue((boolean)true), positions);
            }
        }
        byte[] distinctMask = new byte[positions];
        for (int position = 0; position < distinctMask.length; ++position) {
            if (ids.getGroupId(position) == this.nextDistinctId) {
                distinctMask[position] = 1;
                ++this.nextDistinctId;
                continue;
            }
            distinctMask[position] = 0;
        }
        Preconditions.checkState((this.nextDistinctId == ids.getGroupCount() ? 1 : 0) != 0);
        return BooleanType.wrapByteArrayAsBooleanBlockWithoutNulls((byte[])distinctMask);
    }
}

