/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import com.google.common.base.Preconditions;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.operator.aggregation.state.NullableLongState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.Objects;

public class NullableLongStateSerializer
implements AccumulatorStateSerializer<NullableLongState> {
    private final Type type;

    @UsedByGeneratedCode
    public NullableLongStateSerializer() {
        this((Type)BigintType.BIGINT);
    }

    public NullableLongStateSerializer(Type type) {
        this.type = Objects.requireNonNull(type, "type is null");
        Preconditions.checkArgument((type.getJavaType() == Long.TYPE ? 1 : 0) != 0, (Object)("Type must use long stack type: " + type));
    }

    public Type getSerializedType() {
        return this.type;
    }

    public void serialize(NullableLongState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            this.type.writeLong(out, state.getValue());
        }
    }

    public void deserialize(Block block, int index, NullableLongState state) {
        if (block.isNull(index)) {
            state.setNull(true);
        } else {
            state.setNull(false);
            state.setValue(this.type.getLong(block, index));
        }
    }
}

