/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.annotations;

import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionInvoker;
import io.trino.operator.annotations.ImplementationDependency;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.util.Objects;

public abstract class ScalarImplementationDependency
implements ImplementationDependency {
    private final InvocationConvention invocationConvention;
    private final Class<?> type;

    protected ScalarImplementationDependency(InvocationConvention invocationConvention, Class<?> type) {
        this.invocationConvention = Objects.requireNonNull(invocationConvention, "invocationConvention is null");
        this.type = Objects.requireNonNull(type, "type is null");
        if (invocationConvention.supportsInstanceFactory()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " does not support instance functions");
        }
    }

    protected abstract FunctionInvoker getInvoker(FunctionBinding var1, FunctionDependencies var2, InvocationConvention var3);

    @Override
    public Object resolve(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        MethodHandle methodHandle = this.getInvoker(functionBinding, functionDependencies, this.invocationConvention).getMethodHandle();
        if (this.invocationConvention.supportsSession() && !methodHandle.type().parameterType(0).equals(ConnectorSession.class)) {
            methodHandle = MethodHandles.dropArguments(methodHandle, 0, new Class[]{ConnectorSession.class});
        }
        if (this.type == MethodHandle.class) {
            return methodHandle;
        }
        return MethodHandleProxies.asInterfaceInstance(this.type, methodHandle);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

