/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.index;

import com.google.common.base.Preconditions;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.index.IndexSnapshotBuilder;
import io.trino.spi.Page;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PagesIndexBuilderOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final IndexSnapshotBuilder indexSnapshotBuilder;
    private boolean finished;

    public PagesIndexBuilderOperator(OperatorContext operatorContext, IndexSnapshotBuilder indexSnapshotBuilder) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.indexSnapshotBuilder = Objects.requireNonNull(indexSnapshotBuilder, "indexSnapshotBuilder is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Operator is already finished");
        if (!this.indexSnapshotBuilder.tryAddPage(page)) {
            this.finish();
            return;
        }
        this.operatorContext.recordOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class PagesIndexBuilderOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final IndexSnapshotBuilder indexSnapshotBuilder;
        private final String operatorType;
        private boolean closed;

        public PagesIndexBuilderOperatorFactory(int operatorId, PlanNodeId planNodeId, IndexSnapshotBuilder indexSnapshotBuilder, String operatorType) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.indexSnapshotBuilder = Objects.requireNonNull(indexSnapshotBuilder, "indexSnapshotBuilder is null");
            this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, this.operatorType);
            return new PagesIndexBuilderOperator(operatorContext, this.indexSnapshotBuilder);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new PagesIndexBuilderOperatorFactory(this.operatorId, this.planNodeId, this.indexSnapshotBuilder, this.operatorType);
        }
    }
}

