/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlOperator;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.TypedSet;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MethodHandleUtil;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.BlockTypeOperators;
import io.trino.util.Failures;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Objects;

public final class MapToMapCast
extends SqlOperator {
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapToMapCast.class, "mapCast", MethodHandle.class, MethodHandle.class, Type.class, BlockTypeOperators.BlockPositionIsDistinctFrom.class, BlockTypeOperators.BlockPositionHashCode.class, ConnectorSession.class, Block.class);
    private static final MethodHandle CHECK_LONG_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkLongIsNotNull", Long.class);
    private static final MethodHandle CHECK_DOUBLE_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkDoubleIsNotNull", Double.class);
    private static final MethodHandle CHECK_BOOLEAN_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkBooleanIsNotNull", Boolean.class);
    private static final MethodHandle CHECK_SLICE_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkSliceIsNotNull", Slice.class);
    private static final MethodHandle CHECK_BLOCK_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkBlockIsNotNull", Block.class);
    private final BlockTypeOperators blockTypeOperators;

    public MapToMapCast(BlockTypeOperators blockTypeOperators) {
        super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.castableToTypeParameter("FK", new TypeSignature("TK", new TypeSignatureParameter[0])), (Object)Signature.castableToTypeParameter("FV", new TypeSignature("TV", new TypeSignatureParameter[0])), (Object)Signature.typeVariable("TK"), (Object)Signature.typeVariable("TV")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.mapType((TypeSignature)new TypeSignature("TK", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("TV", new TypeSignatureParameter[0])), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.mapType((TypeSignature)new TypeSignature("FK", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("FV", new TypeSignatureParameter[0]))), true);
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        return FunctionDependencyDeclaration.builder().addCastSignature(new TypeSignature("FK", new TypeSignatureParameter[0]), new TypeSignature("TK", new TypeSignatureParameter[0])).addCastSignature(new TypeSignature("FV", new TypeSignatureParameter[0]), new TypeSignature("TV", new TypeSignatureParameter[0])).build();
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        Preconditions.checkArgument((boundSignature.getArity() == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        MapType fromMapType = (MapType)boundSignature.getArgumentType(0);
        Type fromKeyType = fromMapType.getKeyType();
        Type fromValueType = fromMapType.getValueType();
        MapType toMapType = (MapType)boundSignature.getReturnType();
        Type toKeyType = toMapType.getKeyType();
        Type toValueType = toMapType.getValueType();
        MethodHandle keyProcessor = this.buildProcessor(functionDependencies, fromKeyType, toKeyType, true);
        MethodHandle valueProcessor = this.buildProcessor(functionDependencies, fromValueType, toValueType, false);
        BlockTypeOperators.BlockPositionIsDistinctFrom keyEqual = this.blockTypeOperators.getDistinctFromOperator(toKeyType);
        BlockTypeOperators.BlockPositionHashCode keyHashCode = this.blockTypeOperators.getHashCodeOperator(toKeyType);
        MethodHandle target = MethodHandles.insertArguments(METHOD_HANDLE, 0, keyProcessor, valueProcessor, toMapType, keyEqual, keyHashCode);
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), target);
    }

    private MethodHandle buildProcessor(FunctionDependencies functionDependencies, Type fromType, Type toType, boolean isKey) {
        FunctionNullability functionNullability = functionDependencies.getCastNullability(fromType, toType);
        InvocationConvention invocationConvention = new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION), functionNullability.isReturnNullable() ? InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN : InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, true, false);
        MethodHandle cast = functionDependencies.getCastInvoker(fromType, toType, invocationConvention).getMethodHandle();
        if (cast.type().parameterArray()[0] != ConnectorSession.class) {
            cast = MethodHandles.dropArguments(cast, 0, new Class[]{ConnectorSession.class});
        }
        cast = MethodHandles.permuteArguments(cast, MethodType.methodType(cast.type().returnType(), Block.class, new Class[]{Integer.TYPE, ConnectorSession.class}), 2, 0, 1);
        if (isKey && functionNullability.isReturnNullable()) {
            cast = MethodHandleUtil.compose((MethodHandle)this.nullChecker((Class<?>)cast.type().returnType()), (MethodHandle)cast);
        }
        MethodHandle writer = MethodHandleUtil.nativeValueWriter((Type)toType);
        writer = MethodHandles.permuteArguments(writer, MethodType.methodType(Void.TYPE, writer.type().parameterArray()[1], BlockBuilder.class), 1, 0);
        cast = cast.asType(MethodType.methodType(writer.type().parameterType(0), cast.type().parameterArray()));
        return MethodHandleUtil.compose((MethodHandle)writer, (MethodHandle)cast);
    }

    private MethodHandle nullChecker(Class<?> javaType) {
        if (javaType == Long.class) {
            return CHECK_LONG_IS_NOT_NULL;
        }
        if (javaType == Double.class) {
            return CHECK_DOUBLE_IS_NOT_NULL;
        }
        if (javaType == Boolean.class) {
            return CHECK_BOOLEAN_IS_NOT_NULL;
        }
        if (javaType == Slice.class) {
            return CHECK_SLICE_IS_NOT_NULL;
        }
        if (javaType == Block.class) {
            return CHECK_BLOCK_IS_NOT_NULL;
        }
        throw new IllegalArgumentException("Unknown java type " + javaType);
    }

    @UsedByGeneratedCode
    public static long checkLongIsNotNull(Long value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static double checkDoubleIsNotNull(Double value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static boolean checkBooleanIsNotNull(Boolean value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static Slice checkSliceIsNotNull(Slice value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static Block checkBlockIsNotNull(Block value) {
        if (value == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static Block mapCast(MethodHandle keyProcessFunction, MethodHandle valueProcessFunction, Type targetType, BlockTypeOperators.BlockPositionIsDistinctFrom keyDistinctOperator, BlockTypeOperators.BlockPositionHashCode keyHashCode, ConnectorSession session, Block fromMap) {
        Preconditions.checkState((targetType.getTypeParameters().size() == 2 ? 1 : 0) != 0, (Object)"Expect two type parameters for targetType");
        Type toKeyType = (Type)targetType.getTypeParameters().get(0);
        TypedSet resultKeys = TypedSet.createDistinctTypedSet(toKeyType, keyDistinctOperator, keyHashCode, fromMap.getPositionCount() / 2, "map-to-map cast");
        BlockBuilder keyBlockBuilder = toKeyType.createBlockBuilder(null, fromMap.getPositionCount() / 2);
        for (int i = 0; i < fromMap.getPositionCount(); i += 2) {
            try {
                keyProcessFunction.invokeExact(fromMap, i, session, keyBlockBuilder);
                continue;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        Block keyBlock = keyBlockBuilder.build();
        BlockBuilder mapBlockBuilder = targetType.createBlockBuilder(null, 1);
        BlockBuilder blockBuilder = mapBlockBuilder.beginBlockEntry();
        for (int i = 0; i < fromMap.getPositionCount(); i += 2) {
            if (resultKeys.add(keyBlock, i / 2)) {
                toKeyType.appendTo(keyBlock, i / 2, blockBuilder);
                if (fromMap.isNull(i + 1)) {
                    blockBuilder.appendNull();
                    continue;
                }
                try {
                    valueProcessFunction.invokeExact(fromMap, i + 1, session, blockBuilder);
                    continue;
                }
                catch (Throwable t) {
                    throw Failures.internalError(t);
                }
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "duplicate keys");
        }
        mapBlockBuilder.closeEntry();
        return (Block)targetType.getObject((Block)mapBlockBuilder, mapBlockBuilder.getPositionCount() - 1);
    }
}

