/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.ForLoop;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.control.TryCatch;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.VariableInstruction;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.MapTransformKeysFunction;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.SqlTypeBytecodeExpression;
import io.trino.sql.gen.lambda.BinaryFunctionInterface;
import io.trino.type.UnknownType;
import io.trino.util.CompilerUtils;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class MapTransformValuesFunction
extends SqlScalarFunction {
    public static final MapTransformValuesFunction MAP_TRANSFORM_VALUES_FUNCTION = new MapTransformValuesFunction();
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(MapTransformKeysFunction.class, "createState", MapType.class);

    private MapTransformValuesFunction() {
        super(new FunctionMetadata(new Signature("transform_values", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("K"), (Object)Signature.typeVariable("V1"), (Object)Signature.typeVariable("V2")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V2", new TypeSignatureParameter[0])), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V1", new TypeSignatureParameter[0])), (Object)TypeSignature.functionType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("V1", new TypeSignatureParameter[0]), new TypeSignature("V2", new TypeSignatureParameter[0])})), false), new FunctionNullability(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false)), false, false, "Apply lambda to each entry of the map and transform the value", FunctionKind.SCALAR));
    }

    @Override
    protected ScalarFunctionImplementation specialize(BoundSignature boundSignature) {
        MapType inputMapType = (MapType)boundSignature.getArgumentType(0);
        Type inputValueType = inputMapType.getValueType();
        MapType outputMapType = (MapType)boundSignature.getReturnType();
        Type keyType = outputMapType.getKeyType();
        Type outputValueType = outputMapType.getValueType();
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.FUNCTION), (List<Class<?>>)ImmutableList.of(BinaryFunctionInterface.class), MapTransformValuesFunction.generateTransform(keyType, inputValueType, outputValueType, (Type)outputMapType), Optional.of(STATE_FACTORY.bindTo(outputMapType)));
    }

    @UsedByGeneratedCode
    public static Object createState(MapType mapType) {
        return new PageBuilder((List)ImmutableList.of((Object)mapType));
    }

    private static MethodHandle generateTransform(Type keyType, Type valueType, Type transformedValueType, Type resultMapType) {
        CallSiteBinder binder = new CallSiteBinder();
        Class keyJavaType = Primitives.wrap((Class)keyType.getJavaType());
        Class valueJavaType = Primitives.wrap((Class)valueType.getJavaType());
        Class transformedValueJavaType = Primitives.wrap((Class)transformedValueType.getJavaType());
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("MapTransformValue"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        Parameter state = Parameter.arg((String)"state", Object.class);
        Parameter block = Parameter.arg((String)"block", Block.class);
        Parameter function = Parameter.arg((String)"function", BinaryFunctionInterface.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "transform", ParameterizedType.type(Block.class), (Iterable)ImmutableList.of((Object)state, (Object)block, (Object)function));
        BytecodeBlock body = method.getBody();
        Scope scope = method.getScope();
        Variable positionCount = scope.declareVariable(Integer.TYPE, "positionCount");
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        Variable pageBuilder = scope.declareVariable(PageBuilder.class, "pageBuilder");
        Variable mapBlockBuilder = scope.declareVariable(BlockBuilder.class, "mapBlockBuilder");
        Variable blockBuilder = scope.declareVariable(BlockBuilder.class, "blockBuilder");
        Variable keyElement = scope.declareVariable(keyJavaType, "keyElement");
        Variable valueElement = scope.declareVariable(valueJavaType, "valueElement");
        Variable transformedValueElement = scope.declareVariable(transformedValueJavaType, "transformedValueElement");
        body.append((BytecodeNode)positionCount.set(block.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0])));
        body.append((BytecodeNode)pageBuilder.set(state.cast(PageBuilder.class)));
        body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)pageBuilder.invoke("isFull", Boolean.TYPE, new BytecodeExpression[0])).ifTrue((BytecodeNode)pageBuilder.invoke("reset", Void.TYPE, new BytecodeExpression[0])));
        body.append((BytecodeNode)mapBlockBuilder.set(pageBuilder.invoke("getBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)0)})));
        body.append((BytecodeNode)blockBuilder.set(mapBlockBuilder.invoke("beginBlockEntry", BlockBuilder.class, new BytecodeExpression[0])));
        BytecodeBlock throwNullKeyException = new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.newInstance(TrinoException.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.getStatic((Class)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.getDeclaringClass(), (String)"INVALID_FUNCTION_ARGUMENT").cast(ErrorCodeSupplier.class), BytecodeExpressions.constantString((String)"map key cannot be null")})).throwObject();
        SqlTypeBytecodeExpression keySqlType = SqlTypeBytecodeExpression.constantType(binder, keyType);
        BytecodeBlock loadKeyElement = !keyType.equals((Object)UnknownType.UNKNOWN) ? new BytecodeBlock().append((BytecodeNode)keyElement.set(keySqlType.getValue((BytecodeExpression)block, (BytecodeExpression)position).cast(keyJavaType))) : new BytecodeBlock().append((BytecodeNode)mapBlockBuilder.invoke("closeEntry", BlockBuilder.class, new BytecodeExpression[0]).pop()).append((BytecodeNode)keyElement.set(BytecodeExpressions.constantNull((Class)keyJavaType))).append((BytecodeNode)throwNullKeyException);
        SqlTypeBytecodeExpression valueSqlType = SqlTypeBytecodeExpression.constantType(binder, valueType);
        Object loadValueElement = !valueType.equals((Object)UnknownType.UNKNOWN) ? new IfStatement().condition((BytecodeNode)block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{BytecodeExpressions.add((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.constantInt((int)1))})).ifTrue((BytecodeNode)valueElement.set(BytecodeExpressions.constantNull((Class)valueJavaType))).ifFalse((BytecodeNode)valueElement.set(valueSqlType.getValue((BytecodeExpression)block, BytecodeExpressions.add((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.constantInt((int)1))).cast(valueJavaType))) : new BytecodeBlock().append((BytecodeNode)valueElement.set(BytecodeExpressions.constantNull((Class)valueJavaType)));
        Object writeTransformedValueElement = !transformedValueType.equals((Object)UnknownType.UNKNOWN) ? new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)transformedValueElement, (BytecodeExpression)BytecodeExpressions.constantNull((Class)transformedValueJavaType))).ifTrue((BytecodeNode)blockBuilder.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, transformedValueType).writeValue((BytecodeExpression)blockBuilder, transformedValueElement.cast(transformedValueType.getJavaType()))) : new BytecodeBlock().append((BytecodeNode)blockBuilder.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop());
        Variable transformationException = scope.declareVariable(Throwable.class, "transformationException");
        body.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)positionCount)).update((BytecodeNode)VariableInstruction.incrementVariable((Variable)position, (byte)2)).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)loadKeyElement).append((BytecodeNode)loadValueElement).append((BytecodeNode)new TryCatch("Close builder before throwing to avoid subsequent calls finding it in an inconsistent state if we are in a TRY() call.", (BytecodeNode)transformedValueElement.set(function.invoke("apply", Object.class, new BytecodeExpression[]{keyElement.cast(Object.class), valueElement.cast(Object.class)}).cast(transformedValueJavaType)), (List)ImmutableList.of((Object)new TryCatch.CatchBlock((BytecodeNode)new BytecodeBlock().append((BytecodeNode)mapBlockBuilder.invoke("closeEntry", BlockBuilder.class, new BytecodeExpression[0]).pop()).append((BytecodeNode)pageBuilder.invoke("declarePosition", Void.TYPE, new BytecodeExpression[0])).putVariable(transformationException).append((BytecodeNode)BytecodeExpressions.invokeStatic(Throwables.class, (String)"throwIfUnchecked", Void.TYPE, (BytecodeExpression[])new BytecodeExpression[]{transformationException})).append((BytecodeNode)BytecodeExpressions.newInstance(RuntimeException.class, (BytecodeExpression[])new BytecodeExpression[]{transformationException})).throwObject(), (List)ImmutableList.of((Object)ParameterizedType.type(Throwable.class)))))).append((BytecodeNode)keySqlType.invoke("appendTo", Void.TYPE, new BytecodeExpression[]{block, position, blockBuilder})).append((BytecodeNode)writeTransformedValueElement)));
        body.append((BytecodeNode)mapBlockBuilder.invoke("closeEntry", BlockBuilder.class, new BytecodeExpression[0]).pop());
        body.append((BytecodeNode)pageBuilder.invoke("declarePosition", Void.TYPE, new BytecodeExpression[0]));
        body.append((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, resultMapType).invoke("getObject", Object.class, new BytecodeExpression[]{mapBlockBuilder.cast(Block.class), BytecodeExpressions.subtract((BytecodeExpression)mapBlockBuilder.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0]), (BytecodeExpression)BytecodeExpressions.constantInt((int)1))}).ret());
        Class<Object> generatedClass = CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), MapTransformValuesFunction.class.getClassLoader());
        return Reflection.methodHandle(generatedClass, "transform", Object.class, Block.class, BinaryFunctionInterface.class);
    }
}

