/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestamp;
import io.trino.type.Constraint;
import io.trino.type.DateTimes;
import org.joda.time.DateTimeField;
import org.joda.time.chrono.ISOChronology;

public final class TimestampOperators {
    private TimestampOperators() {
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    public static final class TimestampMinusTimestamp {
        @LiteralParameters(value={"p"})
        @SqlType(value="interval day to second")
        public static long subtract(@SqlType(value="timestamp(p)") long left, @SqlType(value="timestamp(p)") long right) {
            long interval = left - right;
            interval = DateTimes.round(interval, 3);
            interval = DateTimes.rescale(interval, 6, 3);
            return interval;
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="interval day to second")
        public static long subtract(@SqlType(value="timestamp(p)") LongTimestamp left, @SqlType(value="timestamp(p)") LongTimestamp right) {
            return TimestampMinusTimestamp.subtract(left.getEpochMicros(), right.getEpochMicros());
        }
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    public static final class TimestampMinusIntervalDayToSecond {
        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u)")
        @Constraint(variable="u", expression="max(3, p)")
        public static long subtract(@SqlType(value="timestamp(p)") long timestamp, @SqlType(value="interval day to second") long interval) {
            return TimestampPlusIntervalDayToSecond.add(timestamp, -interval);
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u)")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimestamp subtract(@SqlType(value="timestamp(p)") LongTimestamp timestamp, @SqlType(value="interval day to second") long interval) {
            return TimestampPlusIntervalDayToSecond.add(timestamp, -interval);
        }
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    public static final class TimestampMinusIntervalYearToMonth {
        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p)")
        public static long subtract(@SqlType(value="timestamp(p)") long timestamp, @SqlType(value="interval year to month") long interval) {
            return TimestampPlusIntervalYearToMonth.add(timestamp, -interval);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p)")
        public static LongTimestamp subtract(ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp, @SqlType(value="interval year to month") long interval) {
            return TimestampPlusIntervalYearToMonth.add(timestamp, -interval);
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class IntervalYearToMonthPlusTimestamp {
        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p)")
        public static long add(@SqlType(value="interval year to month") long interval, @SqlType(value="timestamp(p)") long timestamp) {
            return TimestampPlusIntervalYearToMonth.add(timestamp, interval);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p)")
        public static LongTimestamp add(ConnectorSession session, @SqlType(value="interval year to month") long interval, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
            return TimestampPlusIntervalYearToMonth.add(timestamp, interval);
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class TimestampPlusIntervalYearToMonth {
        private static final DateTimeField MONTH_OF_YEAR_UTC = ISOChronology.getInstanceUTC().monthOfYear();

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p)")
        public static long add(@SqlType(value="timestamp(p)") long timestamp, @SqlType(value="interval year to month") long interval) {
            long fractionMicros = DateTimes.getMicrosOfMilli(timestamp);
            long result = MONTH_OF_YEAR_UTC.add(DateTimes.scaleEpochMicrosToMillis(timestamp), interval);
            return DateTimes.scaleEpochMillisToMicros(result) + fractionMicros;
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p)")
        public static LongTimestamp add(@SqlType(value="timestamp(p)") LongTimestamp timestamp, @SqlType(value="interval year to month") long interval) {
            return new LongTimestamp(TimestampPlusIntervalYearToMonth.add(timestamp.getEpochMicros(), interval), timestamp.getPicosOfMicro());
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class IntervalDayToSecondPlusTimestamp {
        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u)")
        @Constraint(variable="u", expression="max(3, p)")
        public static long add(@SqlType(value="interval day to second") long interval, @SqlType(value="timestamp(p)") long timestamp) {
            return TimestampPlusIntervalDayToSecond.add(timestamp, interval);
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u)")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimestamp add(@SqlType(value="interval day to second") long interval, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
            return TimestampPlusIntervalDayToSecond.add(timestamp, interval);
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class TimestampPlusIntervalDayToSecond {
        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u)")
        @Constraint(variable="u", expression="max(3, p)")
        public static long add(@SqlType(value="timestamp(p)") long timestamp, @SqlType(value="interval day to second") long interval) {
            interval = Math.multiplyExact(interval, 1000);
            return timestamp + interval;
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u)")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimestamp add(@SqlType(value="timestamp(p)") LongTimestamp timestamp, @SqlType(value="interval day to second") long interval) {
            return new LongTimestamp(timestamp.getEpochMicros() + Math.multiplyExact(interval, 1000), timestamp.getPicosOfMicro());
        }
    }
}

