/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.jaxrs.JaxrsBinder;
import io.jsonwebtoken.SigningKeyResolver;
import io.trino.server.security.jwt.JwkService;
import io.trino.server.security.jwt.JwkSigningKeyResolver;
import io.trino.server.security.oauth2.ForOAuth2;
import io.trino.server.security.oauth2.OAuth2CallbackResource;
import io.trino.server.security.oauth2.OAuth2Client;
import io.trino.server.security.oauth2.OAuth2Config;
import io.trino.server.security.oauth2.OAuth2Service;
import io.trino.server.security.oauth2.OAuth2TokenExchange;
import io.trino.server.security.oauth2.OAuth2TokenHandler;
import io.trino.server.security.oauth2.ScribeJavaOAuth2Client;
import io.trino.server.ui.OAuth2WebUiInstalled;
import java.net.URI;
import javax.inject.Singleton;

public class OAuth2ServiceModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(OAuth2CallbackResource.class);
        OptionalBinder.newOptionalBinder((Binder)binder, OAuth2WebUiInstalled.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(OAuth2Config.class);
        binder.bind(OAuth2Service.class).in(Scopes.SINGLETON);
        binder.bind(OAuth2TokenHandler.class).to(OAuth2TokenExchange.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, OAuth2Client.class).setDefault().to(ScribeJavaOAuth2Client.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("oauth2-jwk", ForOAuth2.class).withConfigDefaults(config -> config.setKeyStorePath(null).setKeyStorePassword(null).setTrustStorePath(null).setTrustStorePassword(null).setAutomaticHttpsSharedSecret(null));
    }

    @Provides
    @Singleton
    @ForOAuth2
    public static JwkService createJwkService(OAuth2Config config, @ForOAuth2 HttpClient httpClient) {
        return new JwkService(URI.create(config.getJwksUrl()), httpClient);
    }

    @Provides
    @Singleton
    @ForOAuth2
    public static SigningKeyResolver createSigningKeyResolver(@ForOAuth2 JwkService jwkService) {
        return new JwkSigningKeyResolver(jwkService);
    }

    public int hashCode() {
        return OAuth2ServiceModule.class.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof OAuth2ServiceModule;
    }
}

