/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import io.trino.metadata.FunctionKind;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.DefaultExpressionTraversalVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Node;
import java.util.Objects;

class WindowFunctionValidator
extends DefaultExpressionTraversalVisitor<Analysis> {
    private final Metadata metadata;

    public WindowFunctionValidator(Metadata metadata) {
        this.metadata = metadata;
    }

    protected Void visitFunctionCall(FunctionCall functionCall, Analysis analysis) {
        ResolvedFunction resolvedFunction;
        Objects.requireNonNull(analysis, "analysis is null");
        if (!analysis.isPatternRecognitionFunction(functionCall) && (resolvedFunction = analysis.getResolvedFunction((Expression)functionCall)) != null && functionCall.getWindow().isEmpty() && this.metadata.getFunctionMetadata(resolvedFunction).getKind() == FunctionKind.WINDOW) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_OVER, (Node)functionCall, "Window function %s requires an OVER clause", resolvedFunction.getSignature().getName());
        }
        return super.visitFunctionCall(functionCall, (Object)analysis);
    }
}

