/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.metadata.ResolvedFunction;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.FieldDereference;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.FunctionCallBuilder;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.BinaryLiteral;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CharLiteral;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.type.JoniRegexp;
import io.trino.type.Re2JRegexp;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ConnectorExpressionTranslator {
    private ConnectorExpressionTranslator() {
    }

    public static Expression translate(Session session, ConnectorExpression expression, PlannerContext plannerContext, Map<String, Symbol> variableMappings, LiteralEncoder literalEncoder) {
        return new ConnectorToSqlExpressionTranslator(session, plannerContext, literalEncoder, variableMappings).translate(expression).orElseThrow(() -> new UnsupportedOperationException("Expression is not supported: " + expression.toString()));
    }

    public static Optional<ConnectorExpression> translate(Session session, Expression expression, TypeAnalyzer types, TypeProvider inputTypes, PlannerContext plannerContext) {
        return (Optional)new SqlToConnectorExpressionTranslator(session, types.getTypes(session, inputTypes, expression), plannerContext).process((Node)expression);
    }

    @VisibleForTesting
    static FunctionName functionNameForComparisonOperator(ComparisonExpression.Operator operator) {
        switch (operator) {
            case EQUAL: {
                return StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME;
            }
            case NOT_EQUAL: {
                return StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME;
            }
            case LESS_THAN: {
                return StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME;
            }
            case LESS_THAN_OR_EQUAL: {
                return StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME;
            }
            case GREATER_THAN: {
                return StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME;
            }
            case GREATER_THAN_OR_EQUAL: {
                return StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME;
            }
            case IS_DISTINCT_FROM: {
                return StandardFunctions.IS_DISTINCT_FROM_OPERATOR_FUNCTION_NAME;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator: " + operator);
    }

    @VisibleForTesting
    static FunctionName functionNameForArithmeticBinaryOperator(ArithmeticBinaryExpression.Operator operator) {
        switch (operator) {
            case ADD: {
                return StandardFunctions.ADD_FUNCTION_NAME;
            }
            case SUBTRACT: {
                return StandardFunctions.SUBTRACT_FUNCTION_NAME;
            }
            case MULTIPLY: {
                return StandardFunctions.MULTIPLY_FUNCTION_NAME;
            }
            case DIVIDE: {
                return StandardFunctions.DIVIDE_FUNCTION_NAME;
            }
            case MODULUS: {
                return StandardFunctions.MODULUS_FUNCTION_NAME;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator: " + operator);
    }

    public static class SqlToConnectorExpressionTranslator
    extends AstVisitor<Optional<ConnectorExpression>, Void> {
        private final Session session;
        private final Map<NodeRef<Expression>, Type> types;
        private final PlannerContext plannerContext;

        public SqlToConnectorExpressionTranslator(Session session, Map<NodeRef<Expression>, Type> types, PlannerContext plannerContext) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        }

        protected Optional<ConnectorExpression> visitSymbolReference(SymbolReference node, Void context) {
            return Optional.of(new Variable(node.getName(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitBooleanLiteral(BooleanLiteral node, Void context) {
            return Optional.of(new Constant((Object)node.getValue(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitStringLiteral(StringLiteral node, Void context) {
            return Optional.of(new Constant((Object)Slices.utf8Slice((String)node.getValue()), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitDoubleLiteral(DoubleLiteral node, Void context) {
            return Optional.of(new Constant((Object)node.getValue(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitDecimalLiteral(DecimalLiteral node, Void context) {
            return Optional.of(new Constant(Decimals.parse((String)node.getValue()).getObject(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitCharLiteral(CharLiteral node, Void context) {
            return Optional.of(new Constant((Object)Slices.utf8Slice((String)node.getValue()), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitBinaryLiteral(BinaryLiteral node, Void context) {
            return Optional.of(new Constant((Object)Slices.wrappedBuffer((byte[])node.getValue()), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitLongLiteral(LongLiteral node, Void context) {
            return Optional.of(new Constant((Object)node.getValue(), this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitNullLiteral(NullLiteral node, Void context) {
            return Optional.of(new Constant(null, this.typeOf((Expression)node)));
        }

        protected Optional<ConnectorExpression> visitGenericLiteral(GenericLiteral node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            return Optional.of(this.constantFor((Expression)node));
        }

        protected Optional<ConnectorExpression> visitLogicalExpression(LogicalExpression node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            ImmutableList.Builder arguments = ImmutableList.builderWithExpectedSize((int)node.getTerms().size());
            for (Node argument : node.getChildren()) {
                Optional translated = (Optional)this.process(argument);
                if (translated.isEmpty()) {
                    return Optional.empty();
                }
                arguments.add((Object)((ConnectorExpression)translated.get()));
            }
            switch (node.getOperator()) {
                case AND: {
                    return Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.AND_FUNCTION_NAME, (List)arguments.build()));
                }
                case OR: {
                    return Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.OR_FUNCTION_NAME, (List)arguments.build()));
                }
            }
            throw new UnsupportedOperationException("Unsupported operator: " + node.getOperator());
        }

        protected Optional<ConnectorExpression> visitComparisonExpression(ComparisonExpression node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            return ((Optional)this.process((Node)node.getLeft())).flatMap(left -> ((Optional)this.process((Node)node.getRight())).map(right -> new Call(this.typeOf((Expression)node), ConnectorExpressionTranslator.functionNameForComparisonOperator(node.getOperator()), (List)ImmutableList.of((Object)left, (Object)right))));
        }

        protected Optional<ConnectorExpression> visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            return ((Optional)this.process((Node)node.getLeft())).flatMap(left -> ((Optional)this.process((Node)node.getRight())).map(right -> new Call(this.typeOf((Expression)node), ConnectorExpressionTranslator.functionNameForArithmeticBinaryOperator(node.getOperator()), (List)ImmutableList.of((Object)left, (Object)right))));
        }

        protected Optional<ConnectorExpression> visitBetweenPredicate(BetweenPredicate node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            return ((Optional)this.process((Node)node.getValue())).flatMap(value -> ((Optional)this.process((Node)node.getMin())).flatMap(min -> ((Optional)this.process((Node)node.getMax())).map(max -> new Call((Type)BooleanType.BOOLEAN, StandardFunctions.AND_FUNCTION_NAME, (List)ImmutableList.of((Object)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)value, (Object)min)), (Object)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)value, (Object)max)))))));
        }

        protected Optional<ConnectorExpression> visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            switch (node.getSign()) {
                case PLUS: {
                    return (Optional)this.process((Node)node.getValue());
                }
                case MINUS: {
                    return ((Optional)this.process((Node)node.getValue())).map(value -> new Call(this.typeOf((Expression)node), StandardFunctions.NEGATE_FUNCTION_NAME, (List)ImmutableList.of((Object)value)));
                }
            }
            throw new UnsupportedOperationException("Unsupported sign: " + node.getSign());
        }

        protected Optional<ConnectorExpression> visitCast(Cast node, Void context) {
            if (ExpressionUtils.isEffectivelyLiteral(this.plannerContext, this.session, (Expression)node)) {
                return Optional.of(this.constantFor((Expression)node));
            }
            if (node.isSafe()) {
                return Optional.empty();
            }
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            Optional translatedExpression = (Optional)this.process((Node)node.getExpression());
            if (translatedExpression.isPresent()) {
                Type type = this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature(node.getType()));
                return Optional.of(new Call(type, StandardFunctions.CAST_FUNCTION_NAME, List.of((ConnectorExpression)translatedExpression.get())));
            }
            return Optional.empty();
        }

        protected Optional<ConnectorExpression> visitFunctionCall(FunctionCall node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            if (ExpressionUtils.isEffectivelyLiteral(this.plannerContext, this.session, (Expression)node)) {
                return Optional.of(this.constantFor((Expression)node));
            }
            if (node.getFilter().isPresent() || node.getOrderBy().isPresent() || node.getWindow().isPresent() || node.getNullTreatment().isPresent() || node.isDistinct()) {
                return Optional.empty();
            }
            String functionName = ResolvedFunction.extractFunctionName(node.getName());
            Preconditions.checkArgument((!"$internal$dynamic_filter_function".equals(functionName) ? 1 : 0) != 0, (Object)"Dynamic filter has no meaning for a connector, it should not be translated into ConnectorExpression");
            if ("$literal$".equalsIgnoreCase(functionName)) {
                Object value = this.evaluateConstant((Expression)node);
                if (value instanceof JoniRegexp) {
                    Slice pattern = ((JoniRegexp)value).pattern();
                    return Optional.of(new Constant((Object)pattern, (Type)VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)pattern))));
                }
                if (value instanceof Re2JRegexp) {
                    Slice pattern = Slices.utf8Slice((String)((Re2JRegexp)value).pattern());
                    return Optional.of(new Constant((Object)pattern, (Type)VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)pattern))));
                }
                return Optional.of(new Constant(value, this.types.get(NodeRef.of((Node)node))));
            }
            ImmutableList.Builder arguments = ImmutableList.builder();
            for (Expression argumentExpression : node.getArguments()) {
                Optional argument = (Optional)this.process((Node)argumentExpression);
                if (argument.isEmpty()) {
                    return Optional.empty();
                }
                arguments.add((Object)((ConnectorExpression)argument.get()));
            }
            FunctionName name = new FunctionName(functionName);
            return Optional.of(new Call(this.typeOf((Expression)node), name, (List)arguments.build()));
        }

        protected Optional<ConnectorExpression> visitIsNullPredicate(IsNullPredicate node, Void context) {
            Optional translatedValue = (Optional)this.process((Node)node.getValue());
            if (translatedValue.isPresent()) {
                return Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.IS_NULL_FUNCTION_NAME, (List)ImmutableList.of((Object)((ConnectorExpression)translatedValue.get()))));
            }
            return Optional.empty();
        }

        protected Optional<ConnectorExpression> visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            Optional translatedValue = (Optional)this.process((Node)node.getValue());
            if (translatedValue.isPresent()) {
                Call isNullCall = new Call(this.typeOf((Expression)node), StandardFunctions.IS_NULL_FUNCTION_NAME, List.of((ConnectorExpression)translatedValue.get()));
                return Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_FUNCTION_NAME, List.of(isNullCall)));
            }
            return Optional.empty();
        }

        protected Optional<ConnectorExpression> visitNotExpression(NotExpression node, Void context) {
            Optional translatedValue = (Optional)this.process((Node)node.getValue());
            if (translatedValue.isPresent()) {
                return Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_FUNCTION_NAME, List.of((ConnectorExpression)translatedValue.get())));
            }
            return Optional.empty();
        }

        private ConnectorExpression constantFor(Expression node) {
            Type type = this.typeOf(node);
            Object value = ExpressionInterpreter.evaluateConstantExpression(node, type, this.plannerContext, this.session, new AllowAllAccessControl(), (Map<NodeRef<Parameter>, Expression>)ImmutableMap.of());
            return new Constant(value, type);
        }

        protected Optional<ConnectorExpression> visitLikePredicate(LikePredicate node, Void context) {
            Optional value = (Optional)this.process((Node)node.getValue());
            Optional pattern = (Optional)this.process((Node)node.getPattern());
            if (value.isPresent() && pattern.isPresent()) {
                if (node.getEscape().isEmpty()) {
                    return Optional.of(new Call(this.typeOf((Expression)node), StandardFunctions.LIKE_PATTERN_FUNCTION_NAME, List.of((ConnectorExpression)value.get(), (ConnectorExpression)pattern.get())));
                }
                Optional escape = (Optional)this.process((Node)node.getEscape().get());
                if (escape.isPresent()) {
                    return Optional.of(new Call(this.typeOf((Expression)node), StandardFunctions.LIKE_PATTERN_FUNCTION_NAME, List.of((ConnectorExpression)value.get(), (ConnectorExpression)pattern.get(), (ConnectorExpression)escape.get())));
                }
            }
            return Optional.empty();
        }

        protected Optional<ConnectorExpression> visitNullIfExpression(NullIfExpression node, Void context) {
            Optional firstValue = (Optional)this.process((Node)node.getFirst());
            Optional secondValue = (Optional)this.process((Node)node.getSecond());
            if (firstValue.isPresent() && secondValue.isPresent()) {
                return Optional.of(new Call(this.typeOf((Expression)node), StandardFunctions.NULLIF_FUNCTION_NAME, (List)ImmutableList.of((Object)((ConnectorExpression)firstValue.get()), (Object)((ConnectorExpression)secondValue.get()))));
            }
            return Optional.empty();
        }

        protected Optional<ConnectorExpression> visitSubscriptExpression(SubscriptExpression node, Void context) {
            if (!(this.typeOf(node.getBase()) instanceof RowType)) {
                return Optional.empty();
            }
            Optional translatedBase = (Optional)this.process((Node)node.getBase());
            if (translatedBase.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new FieldDereference(this.typeOf((Expression)node), (ConnectorExpression)translatedBase.get(), Math.toIntExact(((LongLiteral)node.getIndex()).getValue() - 1L)));
        }

        protected Optional<ConnectorExpression> visitExpression(Expression node, Void context) {
            return Optional.empty();
        }

        private Type typeOf(Expression node) {
            return this.types.get(NodeRef.of((Node)node));
        }

        private Object evaluateConstant(Expression node) {
            Type type = this.typeOf(node);
            Object value = ExpressionInterpreter.evaluateConstantExpression(node, type, this.plannerContext, this.session, new AllowAllAccessControl(), (Map<NodeRef<Parameter>, Expression>)ImmutableMap.of());
            Verify.verify((!(value instanceof Expression) ? 1 : 0) != 0, (String)"Expression %s did not evaluate to constant: %s", (Object)node, (Object)value);
            return value;
        }
    }

    private static class ConnectorToSqlExpressionTranslator {
        private final Session session;
        private final PlannerContext plannerContext;
        private final LiteralEncoder literalEncoder;
        private final Map<String, Symbol> variableMappings;

        public ConnectorToSqlExpressionTranslator(Session session, PlannerContext plannerContext, LiteralEncoder literalEncoder, Map<String, Symbol> variableMappings) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.literalEncoder = Objects.requireNonNull(literalEncoder, "literalEncoder is null");
            this.variableMappings = Objects.requireNonNull(variableMappings, "variableMappings is null");
        }

        public Optional<Expression> translate(ConnectorExpression expression) {
            if (expression instanceof Variable) {
                String name = ((Variable)expression).getName();
                return Optional.of(this.variableMappings.get(name).toSymbolReference());
            }
            if (expression instanceof Constant) {
                return Optional.of(this.literalEncoder.toExpression(this.session, ((Constant)expression).getValue(), expression.getType()));
            }
            if (expression instanceof FieldDereference) {
                FieldDereference dereference = (FieldDereference)expression;
                return this.translate(dereference.getTarget()).map(base -> new SubscriptExpression(base, (Expression)new LongLiteral(Long.toString(dereference.getField() + 1))));
            }
            if (expression instanceof Call) {
                return this.translateCall((Call)expression);
            }
            return Optional.empty();
        }

        protected Optional<Expression> translateCall(Call call) {
            Optional<ComparisonExpression.Operator> operator;
            if (call.getFunctionName().getCatalogSchema().isPresent()) {
                return Optional.empty();
            }
            if (StandardFunctions.AND_FUNCTION_NAME.equals((Object)call.getFunctionName())) {
                return this.translateLogicalExpression(LogicalExpression.Operator.AND, call.getArguments());
            }
            if (StandardFunctions.OR_FUNCTION_NAME.equals((Object)call.getFunctionName())) {
                return this.translateLogicalExpression(LogicalExpression.Operator.OR, call.getArguments());
            }
            if (StandardFunctions.NOT_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 1) {
                Call innerCall;
                ConnectorExpression expression = (ConnectorExpression)Iterables.getOnlyElement((Iterable)call.getArguments());
                if (expression instanceof Call && (innerCall = (Call)expression).getFunctionName().equals((Object)StandardFunctions.IS_NULL_FUNCTION_NAME) && innerCall.getArguments().size() == 1) {
                    return this.translateIsNotNull((ConnectorExpression)innerCall.getArguments().get(0));
                }
                return this.translateNot(expression);
            }
            if (StandardFunctions.IS_NULL_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 1) {
                return this.translateIsNull((ConnectorExpression)call.getArguments().get(0));
            }
            if (StandardFunctions.NULLIF_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 2) {
                return this.translateNullIf((ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1));
            }
            if (StandardFunctions.CAST_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 1) {
                return this.translateCast(call.getType(), (ConnectorExpression)call.getArguments().get(0));
            }
            if (call.getArguments().size() == 2 && (operator = this.comparisonOperatorForFunctionName(call.getFunctionName())).isPresent()) {
                return this.translateComparison(operator.get(), (ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1));
            }
            if (call.getArguments().size() == 2 && (operator = this.arithmeticBinaryOperatorForFunctionName(call.getFunctionName())).isPresent()) {
                return this.translateArithmeticBinary((ArithmeticBinaryExpression.Operator)operator.get(), (ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1));
            }
            if (StandardFunctions.NEGATE_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 1) {
                return this.translate((ConnectorExpression)Iterables.getOnlyElement((Iterable)call.getArguments())).map(argument -> new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, argument));
            }
            if (StandardFunctions.LIKE_PATTERN_FUNCTION_NAME.equals((Object)call.getFunctionName())) {
                switch (call.getArguments().size()) {
                    case 2: {
                        return this.translateLike((ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1), Optional.empty());
                    }
                    case 3: {
                        return this.translateLike((ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1), Optional.of((ConnectorExpression)call.getArguments().get(2)));
                    }
                }
                return Optional.empty();
            }
            QualifiedName name = QualifiedName.of((String)call.getFunctionName().getName());
            List argumentTypes = (List)call.getArguments().stream().map(argument -> argument.getType().getTypeSignature()).collect(ImmutableList.toImmutableList());
            ResolvedFunction resolved = this.plannerContext.getMetadata().resolveFunction(this.session, name, TypeSignatureProvider.fromTypeSignatures(argumentTypes));
            FunctionCallBuilder builder = FunctionCallBuilder.resolve(this.session, this.plannerContext.getMetadata()).setName(name);
            for (int i = 0; i < call.getArguments().size(); ++i) {
                Type type = resolved.getSignature().getArgumentTypes().get(i);
                Expression expression = ConnectorExpressionTranslator.translate(this.session, (ConnectorExpression)call.getArguments().get(i), this.plannerContext, this.variableMappings, this.literalEncoder);
                builder.addArgument(type, expression);
            }
            return Optional.of(builder.build());
        }

        private Optional<Expression> translateIsNotNull(ConnectorExpression argument) {
            Optional<Expression> translatedArgument = this.translate(argument);
            if (translatedArgument.isPresent()) {
                return Optional.of(new IsNotNullPredicate(translatedArgument.get()));
            }
            return Optional.empty();
        }

        private Optional<Expression> translateIsNull(ConnectorExpression argument) {
            Optional<Expression> translatedArgument = this.translate(argument);
            if (translatedArgument.isPresent()) {
                return Optional.of(new IsNullPredicate(translatedArgument.get()));
            }
            return Optional.empty();
        }

        private Optional<Expression> translateNot(ConnectorExpression argument) {
            Optional<Expression> translatedArgument = this.translate(argument);
            if (argument.getType().equals(BooleanType.BOOLEAN) && translatedArgument.isPresent()) {
                return Optional.of(new NotExpression(translatedArgument.get()));
            }
            return Optional.empty();
        }

        private Optional<Expression> translateCast(Type type, ConnectorExpression expression) {
            Optional<Expression> translatedExpression = this.translate(expression);
            if (translatedExpression.isPresent()) {
                return Optional.of(new Cast(translatedExpression.get(), TypeSignatureTranslator.toSqlType(type)));
            }
            return Optional.empty();
        }

        private Optional<Expression> translateLogicalExpression(LogicalExpression.Operator operator, List<ConnectorExpression> arguments) {
            ImmutableList.Builder translatedArguments = ImmutableList.builderWithExpectedSize((int)arguments.size());
            for (ConnectorExpression argument : arguments) {
                Optional<Expression> translated = this.translate(argument);
                if (translated.isEmpty()) {
                    return Optional.empty();
                }
                translatedArguments.add((Object)translated.get());
            }
            return Optional.of(new LogicalExpression(operator, (List)translatedArguments.build()));
        }

        private Optional<Expression> translateComparison(ComparisonExpression.Operator operator, ConnectorExpression left, ConnectorExpression right) {
            return this.translate(left).flatMap(leftTranslated -> this.translate(right).map(rightTranslated -> new ComparisonExpression(operator, leftTranslated, rightTranslated)));
        }

        private Optional<Expression> translateNullIf(ConnectorExpression first, ConnectorExpression second) {
            Optional<Expression> firstExpression = this.translate(first);
            Optional<Expression> secondExpression = this.translate(second);
            if (firstExpression.isPresent() && secondExpression.isPresent()) {
                return Optional.of(new NullIfExpression(firstExpression.get(), secondExpression.get()));
            }
            return Optional.empty();
        }

        private Optional<ComparisonExpression.Operator> comparisonOperatorForFunctionName(FunctionName functionName) {
            if (StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.EQUAL);
            }
            if (StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.NOT_EQUAL);
            }
            if (StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.LESS_THAN);
            }
            if (StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL);
            }
            if (StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.GREATER_THAN);
            }
            if (StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL);
            }
            if (StandardFunctions.IS_DISTINCT_FROM_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.IS_DISTINCT_FROM);
            }
            return Optional.empty();
        }

        private Optional<Expression> translateArithmeticBinary(ArithmeticBinaryExpression.Operator operator, ConnectorExpression left, ConnectorExpression right) {
            return this.translate(left).flatMap(leftTranslated -> this.translate(right).map(rightTranslated -> new ArithmeticBinaryExpression(operator, leftTranslated, rightTranslated)));
        }

        private Optional<ArithmeticBinaryExpression.Operator> arithmeticBinaryOperatorForFunctionName(FunctionName functionName) {
            if (StandardFunctions.ADD_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ArithmeticBinaryExpression.Operator.ADD);
            }
            if (StandardFunctions.SUBTRACT_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ArithmeticBinaryExpression.Operator.SUBTRACT);
            }
            if (StandardFunctions.MULTIPLY_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ArithmeticBinaryExpression.Operator.MULTIPLY);
            }
            if (StandardFunctions.DIVIDE_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ArithmeticBinaryExpression.Operator.DIVIDE);
            }
            if (StandardFunctions.MODULUS_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ArithmeticBinaryExpression.Operator.MODULUS);
            }
            return Optional.empty();
        }

        protected Optional<Expression> translateLike(ConnectorExpression value, ConnectorExpression pattern, Optional<ConnectorExpression> escape) {
            Optional<Expression> translatedValue = this.translate(value);
            Optional<Expression> translatedPattern = this.translate(pattern);
            if (translatedValue.isPresent() && translatedPattern.isPresent()) {
                if (escape.isPresent()) {
                    Optional<Expression> translatedEscape = this.translate(escape.get());
                    if (translatedEscape.isEmpty()) {
                        return Optional.empty();
                    }
                    return Optional.of(new LikePredicate(translatedValue.get(), translatedPattern.get(), translatedEscape));
                }
                return Optional.of(new LikePredicate(translatedValue.get(), translatedPattern.get(), Optional.empty()));
            }
            return Optional.empty();
        }
    }
}

